/* **************************************************************************
*                                                                           *
*  MailBox.CPP                                                              *
*                                                                           *
*  28-01-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control dels MailBoxes                                     *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\mailbox.h"
#include "errors.h"
#include "kernel\kernel.h"
#include "string.h"
#include "kernel\asm.h"
#include "kernel\system.h"

extern PCkeKernel Kernel;

// **************************************************************************
// Construeix l'objecte
CkeMailBox::CkeMailBox( PCkeObject pParent, PSTR sName, BOOL bTemp ) : CkeResource( pParent, sName, bTemp )
	{
	id = CID_MailBox;

	DWORD flags = CLI();

	dwwaitingmsgs = 0L;
	Kernel->MemSet( (PBYTE) pregion, MAILBOX_SIZE, 0 ); // Inicializem la zona

	pfirstmsg = (PTMSG) pregion;
	plastmsg = (PTMSG) pregion;

	STI( flags );
	}

// **************************************************************************
// Destructor de la classe
CkeMailBox::~CkeMailBox()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CkeMailBox::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_MailBox )
		return TRUE;
	else
		return CkeResource::ClassCheck( Cuid );
	}

// **************************************************************************
// Envia un missatge a la bstia
// Com a entrada ha de rebre:
// Msg      	- Missatge que s'envia
VOID CkeMailBox::PostMessage( PTMSG pMessage )
	{
	DWORD flags = CLI();

	// Si no hi cap al final, tornem al principi
	if( (DWORD) plastmsg - (DWORD) pregion + sizeof( TMSG ) > MAILBOX_SIZE )
		plastmsg = (PTMSG) pregion;

	if( (DWORD) pfirstmsg > (DWORD) plastmsg )
		{
		if( (DWORD) pfirstmsg - (DWORD) plastmsg <= sizeof( TMSG ) )
			{ // Si no hi cap al principi -> Error
			TRACE( TEXT( "MB_FULL" ) );
			SETERRORCODE( MB_FULL );
			STI( flags );
			return;
			}
		}

	// Passem el missatge
	Kernel->MemCopy( (PBYTE) pMessage, (PBYTE) plastmsg, sizeof( TMSG ) );
	plastmsg++; // El proper, ms endavant

	dwwaitingmsgs++; // Un missatge ms

	if( dwwaitingmsgs == 1 ) // Hem passat de 0 a 1 missatge
		{
		if( pwaiting ) // Si hi ha algun procs en espera, l'hem de despertar
			{
			PCkeThread pfirst = (PCkeThread) pwaiting->Get();

			while( pfirst )
				{
				PCkeListItem pnext = pfirst->GetNext(); // Obtenim el segent
				pwaiting->Delete( pfirst ); // Esborrem l'actual de la llista
				System->Ready( pfirst ); // Afegim l'actual a la llista de preparats
				pfirst = (PCkeThread) pnext; // Passem al segent
				}
			}
		}

	SETERRORCODE( OK );
	STI( flags );
	}

// **************************************************************************
// Obt el primer dels missatges de la bstia (si no n'hi ha s'espera)
// Com a entrada ha de rebre:
// Msg      	- Missatge rebut
BOOL CkeMailBox::WaitMessage( PTMSG pMessage )
	{
	DWORD flags = CLI();

	if( !dwwaitingmsgs )
		{
// Afegir a la llista:		pwaiting;
		(System->Running())->Status( STATUS_BLOCKED );
		pwaiting->Add( System->Running() ); // Afegim el flux a la llista d'espera

		Kernel->Scheduler(); // Planifiquem
		}

	// El missatge que volem agafar s el posterior a l'ltim de la bstia?
	if( (DWORD) pfirstmsg - (DWORD) pregion + sizeof( TMSG ) > MAILBOX_SIZE )
		pfirstmsg = (PTMSG) pregion; // Doncs, hem de passar al principi

	// Obtenim el missatge
	Kernel->MemCopy( (PBYTE) pfirstmsg, (PBYTE) pMessage, sizeof( TMSG ) );
	pfirstmsg++; // El segent est ms endavant
	dwwaitingmsgs--; // Un missatge menys

	STI( flags );

	return FALSE;
	}

// **************************************************************************
// Obt el primer dels missatges de la bustia (si no n'hi ha retorna)
// Com a entrada ha de rebre:
// Msg      	- Missatge rebut o indeterminat si no n'hi havia
BOOL CkeMailBox::PeekMessage( PTMSG pMessage )
	{
	if( !dwwaitingmsgs )
		return FALSE; // No hi ha cap missatge

	DWORD flags = CLI();

	// Igual que 'WaitMessage'
	if( (DWORD) pfirstmsg - (DWORD) pregion > MAILBOX_SIZE )
		pfirstmsg = (PTMSG) pregion;

	Kernel->MemCopy( (PBYTE) pMessage, (PBYTE) pfirstmsg, sizeof( TMSG ) );
	pfirstmsg++;
	dwwaitingmsgs--;

	STI( flags );

	return TRUE;
	}

// **************************************************************************
// Obt el nombre de missatges que s'esperen en la bustia
DWORD CkeMailBox::WaitingMessages()
	{
	return dwwaitingmsgs;
	}

