/* **************************************************************************
*                                                                           *
*  Object.CPP                                                               *
*                                                                           *
*  29-01-97                                                    BUILD:0004   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica per al control dels recursos i el directori d'objectes   *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\object.h"
#include "errors.h"
#include "string.h"
#include "kernel\mem.h"
#include "kernel\system.h"
#include "kernel\asm.h"

extern BOOL bSpecialMemory;

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Name 	   	- Nom de l'objecte (pot ser NULL)
// Temp  	  	- Indica si es temporal
CkeObject::CkeObject( PCkeObject pParent, PSTR sName, BOOL bTemp ) : CkeDblListItem( NULL, NULL )
	{
	DWORD flags = CLI();

	if( sName )
		sname			= Parse( sName );
	else
		sname			= NULL;
	dwusecount     = 1L;
	btemporal		= bTemp;
	pparent			= pParent;
	pcreator			= System->Running();

	if( sname && pparent ) // Si ha de formar part de l'estructura jerrquica, l'integrem en ella
		((PCkeObjectDirectory) pparent)->AddChild( this );

	STI( flags );
	}

// **************************************************************************
// Destrueix l'objecte
CkeObject::~CkeObject()
	{
	free( sname );
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CkeObject::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Object )
		return TRUE;
	else
		return CkeDblListItem::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'adrea de la cadena de carcters d'una cpia del parmetre
// Com a entrada ha de rebre:
// Name     - Apunta cap a la cadena de carcters que ser el nom de l'objecte
PSTR CkeObject::Parse( PSTR sName )
	{
	DWORD flags = CLI();

	bSpecialMemory = TRUE; // Reservem memria global
	PSTR sname = (PSTR) malloc( strlen( sName ) * sizeof( CHAR ) + 1 );
	bSpecialMemory = FALSE;

	STI( flags );

	strcpy( sname, sName );

	return sname;
	}

// **************************************************************************
// Retorna l'adrea del flux que ha creat l'objecte
PCkeThread CkeObject::Creator()
	{
	return pcreator;
	}

// **************************************************************************
// Retorna l'adrea de l'objecte desprs d'obrir un apuntador cap a ell
// Com a entrada ha de rebre:
// Interrupt	- Identifica la interrupcio en la que es vol registrar
// Address  	- Indica l'adrea de memoria de la RSI
PCkeObject CkeObject::Enter()
	{
	DWORD flags = CLI();
	dwusecount++;
	STI( flags );

	return this;
	}

// **************************************************************************
// Tanca un apuntador cap a l'objecte
VOID CkeObject::Leave()
	{
	DWORD flags = CLI();
	dwusecount--;
	STI( flags );
	}

// **************************************************************************
// Retorna el nom de l'objecte
PSTR CkeObject::Name()
	{
	return sname;
	}

// **************************************************************************
// Retorna el valor del comptador d'apuntadors oberts a l'objecte
DWORD CkeObject::UseCount()
	{
	return dwusecount;
	}

// **************************************************************************
// Retorna l'indicador de temporal
BOOL CkeObject::Temporal()
	{
	return btemporal;
	}

// **************************************************************************
// Realitza la funci d'anlisi de la cadena de carcters
// Com a entrada ha de rebre:
// str      	- Cadena de carcters sobre la qual es realitza l'anlisi
PCkeObject CkeObject::Analysis( PSTR )
	{
	return this; // Per defecte noms es retorna l'objecte
	}

