/* **************************************************************************
*                                                                           *
*  Page.CPP                                                                 *
*                                                                           *
*  13-07-96                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control de les pgines                                     *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\page.h"
#include "errors.h"
#include "kernel\system.h"

// **************************************************************************
// Construeix l'objecte
// Com a entrada ha de rebre:
// Pag      	- Apuntador a l'entrada de taula de pagines
CPage::CPage( PTPage Pag ) : CkeType( CID_Page )
	{
	Page( Pag );
	}

// **************************************************************************
// Destructor de la classe
CPage::~CPage()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CPage::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Page )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'adrea de l'entrada a la taula de pgines
PTPage CPage::Page()
	{
	return ppag;
	}

// **************************************************************************
// Selecciona una nova entrada de la taula de pgines
// Com a entrada ha de rebre:
// Pag      	- Apuntador a la nova entrada
VOID CPage::Page( PTPage Pag )
	{
	ppag = Pag;
	}

// **************************************************************************
// Inicialitza l'entrada amb uns valors determinats
VOID CPage::Clear()
	{
	if( ppag )
		{
		ppag->LoWord.Bytes.Flags1 		= 0;
		ppag->LoWord.Bytes.Flags2 		= 0;
		ppag->PageDirHi					= 0;
		}
	}

// **************************************************************************
// Aquestes funcions retornen l'estat dels parametres de l'entrada

// -- Pgina present
BOOL CPage::Present()
	{
	if( ppag )
		return ppag->LoWord.Bits.Pres;

	return FALSE;
	}

// -- La pgina pot ser escrita
BOOL CPage::Writeable()
	{
	if( ppag )
		return ppag->LoWord.Bits.ReadWrite;

	return FALSE;
	}

// -- La pgina pot ser accedida des de mode no privilegiat
BOOL CPage::User()
	{
	if( ppag )
		return ppag->LoWord.Bits.UserSuper;

	return FALSE;
	}

// -- Page Cache Disable (486+)
BOOL CPage::PCD()
	{
	if( ppag )
		return ppag->LoWord.Bits.PCD;

	return FALSE;
	}

// -- La pgina ha estat accedida
BOOL CPage::Accessed()
	{
	if( ppag )
		return ppag->LoWord.Bits.Accessed;

	return FALSE;
	}

// -- La pgina ha estat modificada
BOOL CPage::Dirty()
	{
	if( ppag )
		return ppag->LoWord.Bits.Dirty;

	return FALSE;
	}

// -- L'entrada del directori de pgines fa referncia a una pgina de 4MB (Pentium+)
BOOL CPage::Page4MB()
	{
	if( ppag )
		return ppag->LoWord.Bits.P4MB;

	return FALSE;
	}

// -- Pagina amb 'Copy-on-write'
BOOL CPage::COW()
	{
	if( ppag )
		return ppag->LoWord.Bits.System0;

	return FALSE;
	}

// -- Adrea a la que fa referncia l'entrada
DWORD CPage::PageAddress()
	{
	if( ppag )
		return (((DWORD) ppag->LoWord.Bits.PageDirLo) << PAGE_BITS) + (((DWORD) ppag->PageDirHi) << 16);

	return 0L;
	}

BOOL CPage::Readable()
	{
	return TRUE;
	}

BOOL CPage::Executable()
	{
	return TRUE;
	}

// **************************************************************************
// Aquestes funcions modifiquen els parametres de l'entrada

// -- Posa la pgina com a present (1) o no (0)
VOID CPage::Present( BOOL bit )
	{
	if( ppag )
		ppag->LoWord.Bits.Pres	= bit;
	}

// -- La pgina podra ser escrita (1) o no (0)
VOID CPage::Writeable( BOOL bit )
	{
	if( ppag )
		ppag->LoWord.Bits.ReadWrite	= bit;
	}

// -- La pgina podra ser accedida des del mode usuari (1) o no (0)
VOID CPage::User( BOOL bit )
	{
	if( ppag )
		ppag->LoWord.Bits.UserSuper	= bit;
	}

// -- La pgina no sera cachejada (1) o si (0)
VOID CPage::PCD( BOOL bit )
	{
	if( ppag )
		ppag->LoWord.Bits.PCD	= bit;
	}

// -- La pgina ha estat accedida (1) o no (0)
VOID CPage::Accessed( BOOL bit )
	{
	if( ppag )
		ppag->LoWord.Bits.Accessed	= bit;
	}

// -- La pgina ha estat modificada (1) o no (0)
VOID CPage::Dirty( BOOL bit )
	{
	if( ppag )
		ppag->LoWord.Bits.Dirty	= bit;
	}

// -- La pgina es de 4MB (1) o de 4KB (0)
VOID CPage::Page4MB( BOOL bit )
	{
	if( ppag )
		ppag->LoWord.Bits.P4MB	= bit;
	}

// -- La pgina utilitza el metode COW (1) o no (0)
VOID CPage::COW( BOOL bit )
	{
	if( ppag )
		ppag->LoWord.Bits.System0	= bit;
	}

// -- Posa l'adrea de la pgina
VOID CPage::PageAddress( DWORD pdir )
	{
	if( ppag )
		{
		ppag->LoWord.Bits.PageDirLo	= (BYTE) ((pdir >> PAGE_BITS) & 0x0f);
		ppag->PageDirHi					= (WORD) (pdir >> 16);
		}
	}

VOID CPage::Readable( BOOL )
	{
// Els microprocessadors Intel 386+ no controlen aquest estat
	}

VOID CPage::Executable( BOOL )
	{
// Els microprocessador Intel 386+ no controlen aquest estat
	}

