/* **************************************************************************
*                                                                           *
*  PageDir.CPP                                                              *
*                                                                           *
*  13-05-97                                                    BUILD:0005   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control de la memria (proporciona independncia del proc.)*
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\pagedir.h"
#include "errors.h"
#include "string.h"
#include "kernel\kernel.h"
#include "kernel\system.h"
#include "kernel\asm.h"

extern PCkeKernel _export Kernel;

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Proc     	- Procs al que pertany aquest directori de pgines independent del processador
CkePageDirectory::CkePageDirectory( PCkeProcess pProc ) : CkeType( CID_PageDirectory )
	{
	CHECK_CLASS( pProc, CID_Process, TEXT( "CkePageDirectory::CkePageDirectory cridat amb parametre pProc incorrecte" ) );

	pproc = pProc;
	pvad = NULL; // Encara no hem reservat cap regi de memria

	if( pproc->PrivilegeLevel() == MODE_USER ) // Procs d'usuari
		{
		// Reservem la pgina que fa de directori de pgines
		dwpdbr = (System->PAT())->AllocPage( SYSTEM_PAGE, NULL, NULL, NULL, 0, TRUE );
		dwlogpdbr = System->MapPT( dwpdbr ); // Mapegem la pgina en una adrea lgica
		pphyspagedir = new CTPage( (PTPage) dwlogpdbr );
		// Reservem la pgina que guarda les adreces lgiques
		DWORD dwlogpagedir = (System->PAT())->AllocPage( SYSTEM_PAGE, NULL, NULL, NULL, 0, TRUE );
		DWORD logpagedir = System->MapPT( dwlogpagedir ); // Mapegem aquesta pgina
		plogpagedir = new CTPage( (PTPage) logpagedir );

		pphyspagedir->Clear(); // Esborrem els directoris de pgines
		plogpagedir->Clear();

		System->CopyPageDirectory( (PVOID) dwlogpdbr ); // Copiem la part global del directori de pgines

		{ // Fem que l'adrea 0xc00xxxxx / 4 vagi cap al directori de pgines
		PTPage page = (PTPage) (dwlogpdbr + 0x300 * sizeof( TPage ) );
		CPage cpage( page );
		cpage.PageAddress( dwpdbr );
		cpage.Writeable( TRUE );
		cpage.Present( TRUE );
		}
		}
	else // Procs del sistema
		{
		dwpdbr = dwlogpdbr = 0x80000; // El sistema utilitza aquest directori de pgines
		pphyspagedir = new CTPage( (PTPage) 0x80000 );

		DWORD dwlogpagedir = (System->PAT())->AllocPage( SYSTEM_PAGE, NULL, NULL, NULL, 0, TRUE );
		DWORD logpagedir = System->MapPT( dwlogpagedir );
		plogpagedir = new CTPage ( (PTPage) logpagedir );
		plogpagedir->Clear();

		System->CopyPageDirectory( (PVOID) logpagedir );
		}
	}

// **************************************************************************
// Destructor de la classe
CkePageDirectory::~CkePageDirectory()
	{
// Esborrar tots els VADs -BUG
	delete pphyspagedir;
	delete plogpagedir;
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CkePageDirectory::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_PageDirectory )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'adrea fsica/lgica del directori de pgines del sistema
DWORD CkePageDirectory::PDBR()
	{
	return dwpdbr;
	}

// **************************************************************************
// Retorna cert quan ha pogut mapejar una certa regi en una adrea lgica concreta
// Com a entrada ha de rebre:
// Region   	- Regi que volem mapejar
// Address  	- Adrea lgica on la volem mapejar
// Flags    	- 'Flags' del mapeig
BOOL CkePageDirectory::TryToMapRegion( PCkeRegion pRegion, PVOID pAddress, DWORD /*dwFlags*/ )
	{
// Cercar entre els VADs el rang especificat
	PCkeVAD pcurrent;	// VAD que estem comprovant actualment
	PCkeVAD plast = NULL; // ltim VAD comprovat

	if( pproc->PrivilegeLevel() == MODE_USER )
		pcurrent = pvad; // En mode usuari coneixem el primer VAD
	else
		pcurrent = Kernel->VAD(); // El sistema t els seus propis VADs

	BOOL bfound = FALSE; // Encara no hem trobat espai lliure
	BOOL bexit = FALSE; // Encara podem continuar

	while( pcurrent && !bfound && !bexit )
		{
		if( (DWORD) pcurrent->VirtualAddress() >= (DWORD) pAddress && (DWORD) pcurrent->VirtualAddress() < (DWORD) pAddress + pRegion->VirtualSize() )
			bexit = TRUE; // Si volem mapejar dins una regi que ja est ocupada, no podem mapejar
		else
			{
			if( (DWORD) pAddress >= (DWORD) pcurrent->VirtualAddress() && (DWORD) pAddress < (DWORD) pcurrent->VirtualAddress() + (pcurrent->Region())->VirtualSize() )
				bexit = TRUE; // Si hem trobat un VAD que est dins la regi que volem mapejar, no podem mapejar
			else
				{
				if( (DWORD) pAddress <= (DWORD) pcurrent->VirtualAddress() && (DWORD) pcurrent->VirtualAddress() < (DWORD) pAddress + pRegion->VirtualSize() )
					bexit = TRUE; // Si hem trobat un VAD que es solapa amb la regi que volem mapejar, no podem mapejar
				else
					{
					if( pcurrent->GetNext() ) // Si hi ha ms VADs a la llista
						{
						if( (DWORD) ((PCkeVAD) pcurrent->GetNext())->VirtualAddress() >= (DWORD) pAddress + pRegion->VirtualSize() && (DWORD) pcurrent->VirtualAddress() + (pcurrent->Region())->VirtualSize() <= (DWORD) pAddress )
							bfound = TRUE; // Hi ha prou espai entre el VAD actual i el segent per a la regi
						else
							{
							plast = pcurrent; // Passem al segent
							pcurrent = (PCkeVAD) pcurrent->GetNext();
							}
						}
					else
						{
						plast = pcurrent; // No hi ha segent
						pcurrent = NULL;
						}
					}
				}
			}
		}

	SETERRORCODE( OK ); // Fins ara, tot correcte

	if( bexit )
		return FALSE; // SETERRORCODE? -BUG

// Hi ha espai, reservem el rang
	PCkeVAD pnewvad = new CkeVAD( pAddress, pproc, pRegion, 0, NULL, NULL );	// Protection -BUG
// mapejar!!!! -BUG
	if( plast && (DWORD) plast->VirtualAddress() < (DWORD) pAddress )
		{
		plast->SetNext( pnewvad ); // Enllacem amb l'anterior (si n'hi ha)
		pnewvad->SetPrev( plast );
		}

	if( pcurrent && (DWORD) pcurrent->VirtualAddress() > (DWORD) pAddress )
		{
		pcurrent->SetPrev( pnewvad ); // Enllacem amb el segent (si n'hi ha)
		pnewvad->SetNext( pcurrent );
		}

	if( !pvad || (DWORD) pvad->VirtualAddress() > (DWORD) pAddress )
		{
		if( pvad )
			{
			pnewvad->SetNext( pvad ); // Seleccionem el nou primer
			pvad->SetPrev( pnewvad );
			}

		pvad = pnewvad;
		}

	return TRUE; // Hem mapejat correctament
	}

// **************************************************************************
// Retorna l'adrea lgica on s'ha mapejat una certa regi
// Com a entrada ha de rebre:
// Region   	- Regi que volem mapejar
// Flags    	- 'Flags' del mapeig
PVOID CkePageDirectory::MapRegion( PCkeRegion pRegion, DWORD /*dwFlags*/ )
	{
// Cercar entre els VADs un rang suficientment gran
// El reservem si n'hem trobat un
	PCkeVAD pcurrent;

	if( pproc->PrivilegeLevel() == MODE_USER )
		pcurrent = pvad; // Cada procs d'usuari t la seva prpia llista
	else
		pcurrent = Kernel->VAD(); // Els processos del sistema tenen una llista com

#ifdef _DEBUG
	if( DebugLevel > 19 )
		{
		CHAR str[ 80 ];
		sprintf( str, TEXT( "MAP - pcurrent = %08x" ), pcurrent );
		TRACE( str );
		}
#endif

	PCkeVAD plast = NULL;

	BOOL bfound;

	if( pcurrent )
		bfound = FALSE; // Encara no s'ha trobat espai
	else
		bfound = TRUE; // Si no hi ha elements a la llista, ja hem trobat espai

	PVOID pAddress;

	if( pproc->PrivilegeLevel() == MODE_USER )
		pAddress = (PVOID) 0x400000;	// Els primers 4 MB. estan reservats
	else
		pAddress = (PVOID) 0x80300000; // Els processos del sistema agafen memria a partir d'aqu

	while( pcurrent && !bfound )
		{
#ifdef _DEBUG
		if( DebugLevel > 19 )
			{
			CHAR str[ 80 ];
			sprintf( str, TEXT( "ad %08x, sz %08x (Region %08x)" ), (DWORD) pcurrent->VirtualAddress(), (pcurrent->Region())->VirtualSize(), pcurrent->Region() );
			TRACE( str );
			}
#endif

		if( (DWORD) pcurrent->VirtualAddress() > (DWORD) pAddress && (DWORD) pcurrent->VirtualAddress() >= (DWORD) pAddress + pRegion->VirtualSize() )
			{
			if( plast )
				{
				if( (DWORD) plast->VirtualAddress() + (plast->Region())->VirtualSize() <= (DWORD) pAddress )
					bfound = TRUE;
				else
					{
					plast = pcurrent;
					pcurrent = (PCkeVAD) pcurrent->GetNext();
					}
				}
			else
				{
				plast = pcurrent;
				pcurrent = (PCkeVAD) pcurrent->GetNext();
				}
			}
		else
			{
			plast = pcurrent;
			pcurrent = (PCkeVAD) pcurrent->GetNext();
			}
		}

	SETERRORCODE( OK );

	if( !bfound ) // No hem trobat espai
		{
		if( plast ) // No hem trobat i com a mnim hi ha un element a la llista
			pAddress = (PVOID) ((PBYTE) plast->VirtualAddress() + (plast->Region())->VirtualSize()); // L'espai est desprs de l'element
		else
			{
			TRACE( TEXT( "No trobat espai (Pagedir->Map)" ) ); // No hem trobat espai i no hi ha elements ? -BUG
			return NULL;
			}
		}

#ifdef _DEBUG
	if( DebugLevel > 19 )
		{
		CHAR str[ 80 ];
		sprintf( str, TEXT( "new VAD %08x (%08x)" ), (DWORD) pAddress, pRegion->VirtualSize() );
		TRACE( str );
		}
#endif
	// Hem trobat espai
	PCkeVAD pnewvad = new CkeVAD( pAddress, pproc, pRegion, 0, plast, pcurrent );	// Protection -BUG

#ifdef _DEBUG
	if( DebugLevel > 19 )
		{
		CHAR str[ 80 ];
		sprintf( str, TEXT( "new VAD %08x" ), (DWORD) pnewvad );
		TRACE( str );
		}
#endif

	if( plast ) // Enllacem amb l'ltim tractat
		plast->SetNext( pnewvad );

	if( pcurrent ) // Si no hem arribat al final de la llista, enllacem amb el segent
		pcurrent->SetPrev( pnewvad );

	if( !pvad ) // Si no hi ha primer en la llista
		pvad = pnewvad;

// mapejar!!!! -BUG
	return pAddress;
	}

// **************************************************************************
// Desmapeja una certa regi
// Com a entrada ha de rebre:
// Region   	- Regi que volem desmapejar
VOID CkePageDirectory::UnmapRegion( PCkeRegion pRegion )
	{
	PCkeVAD pcurrent = pvad;
	BOOL bfound = FALSE;

// Cercar entre els VADs la regi
	while( pcurrent && !bfound )
		{
// L'alliberem si l'hem trobada
		if( pcurrent->Region() == pRegion )
			{
// L'hem de treure de la llista (si no ho fa el delete) -BUG
			delete pcurrent;
			bfound = TRUE; // Regi trobada
			}
		else
			pcurrent = (PCkeVAD) pcurrent->GetNext();
		}

	if( bfound )
		SETERRORCODE( OK );
	else
		SETERRORCODE( PD_BADREGION ); // La regi especificada no s'ha trobat
	}

// **************************************************************************
// Compromet una certa adrea lgica i les pgines posteriors especificades
// Com a entrada ha de rebre:
// Address  	- Adrea on es comena a comprometre la memria
// Size			- Tamany en 'bytes' de la zona a comprometre
VOID CkePageDirectory::Commit( PVOID pAddress, DWORD dwSize )
	{
// Reservar memria fsica segons els parmetres
	dwSize = ROUND_UP( dwSize, PAGE_SIZE ); // El tamany ha de ser un mltiple d'una pgina

#ifdef _DEBUG
	if( DebugLevel > 35 )
		{
		CHAR str[ 80 ];
		sprintf( str, TEXT( "addr %08x, sz %08x, dwpdbr %08x" ), (DWORD) pAddress, dwSize, dwpdbr );
		TRACE( str );
		}
#endif

// Mapegem l'espai d'adreces del flux al qual hem de comprometre pgines
	DWORD flags = CLI();
	DWORD temp = 0;
	PCTSS pctss;

	if( System->Running() )
		{
		pctss = (System->Running())->TSS();
		temp = GetCR3();
		pctss->PDBR( dwpdbr );
		SetCR3( dwpdbr );
		}

	STI( flags );

	while( dwSize ) // Repetim per el nombre de 'bytes' que ens han indicat
		{
		DWORD physpage;
		// Anem cap a l'entrada del directori de pgines corresponent a l'adrea
		PTPage pPTE = pphyspagedir->Page( (WORD) (((DWORD) pAddress) >> (PAGE_BITS + 10)) );

#ifdef _DEBUG
		if( DebugLevel > 35 )
			{
			CHAR str[ 80 ];
			PDWORD px = (PDWORD) (dwlogpdbr + 0xc00);
			sprintf( str, TEXT( "pPTE %08x, 0xc00 -> %08x" ), (DWORD) pPTE, (DWORD) *px );
			TRACE( str );
			}
#endif

		CPage cPTE( pPTE );

		if( !cPTE.Present() ) // La taula de pgines no est present -> No existeix
			{
			// Creem la taula de pgines
#ifdef _DEBUG
			if( DebugLevel > 35 )
				TRACE( TEXT( "!cPTE.Present" ) );
#endif
			// Reservem una pgina
			physpage = (System->PAT())->AllocPage( SYSTEM_PAGE, NULL, NULL, NULL, NULL, TRUE ); // -BUG

			if( pproc && pproc->PrivilegeLevel() == MODE_USER )
				cPTE.User( TRUE ); // En mode usuari s'hi ha de poder accedir
			else
				cPTE.User( FALSE ); // L'usuari no hi ha de poder accedir

			// Preparem l'entrada del directori de pgines
			cPTE.Writeable( TRUE );
			cPTE.COW( FALSE );
			cPTE.Readable( TRUE );
			cPTE.Executable( FALSE );
			cPTE.PageAddress( physpage );
			cPTE.Present( TRUE );

			// Mapegem en una adrea lgica la taula de pgines
			DWORD logaddr = System->MapPT( physpage );
			PTPage plogPTE = plogpagedir->Page( (WORD) (((DWORD) pAddress) >> (PAGE_BITS + 10)) );
			CTPage pagetable( plogPTE );
			PDWORD pdw = (PDWORD) pagetable.Page( (WORD) ((((DWORD) pAddress) >> (PAGE_BITS)) & 0x03ff ) );
			*pdw = logaddr; // Guardem l'adrea al directori de pgines lgic
			}

		// Anem cap a la taula de pgines
		PTPage plogPTE = (PTPage) ((((DWORD) pAddress) >> 10) + 0xc0000000);
/*		CPage clogpag( plogPTE );

#ifdef _DEBUG
		if( DebugLevel > 35 )
			{
			CHAR str[ 80 ];
			sprintf( str, TEXT( "plogPTE %08x" ), (DWORD) plogPTE );
			TRACE( str );
			(System->Debug())->MemoryDump( (PBYTE) plogPTE, 0x10 );
			}
#endif

		if( !clogpag.Present() ) // Si no est present la pgina
			{
#ifdef _DEBUG
			if( DebugLevel > 35 )
				TRACE( TEXT( "!clogpag.Present" ) );
#endif
			// Reservem una nova pgina
			physpage = (System->PAT())->AllocPage( SYSTEM_PAGE, NULL, NULL, NULL, NULL, TRUE ); // -BUG

			if( pproc && pproc->PrivilegeLevel() == MODE_USER )
				clogpag.User( TRUE );
			else
				clogpag.User( FALSE );

			clogpag.Writeable( TRUE );
			clogpag.User( TRUE );
			clogpag.COW( FALSE );
			clogpag.Readable( TRUE );
			clogpag.Executable( FALSE );
			clogpag.PageAddress( physpage );
			clogpag.Present( TRUE );

			// Mapegem la taula
			DWORD logaddr = System->MapPT( physpage );
			PTPage plogPTE = plogpagedir->Page( (WORD) (((DWORD) pAddress) >> (PAGE_BITS + 10)) );
			CTPage pagetable( plogPTE );
			PDWORD pdw = (PDWORD) pagetable.Page( (WORD) ((((DWORD) pAddress) >> (PAGE_BITS)) & 0x03ff ) );
			*pdw = logaddr; // Guardem l'adrea lgica en la taula lgica
			}
*/
		pPTE = plogPTE; // Aquesta s l'entrada de la taula de pgines

#ifdef _DEBUG
		if( DebugLevel > 35 )
			{
			CHAR str[ 80 ];
			sprintf( str, TEXT( "pPTE %08x, padd %08x, %08x" ), (DWORD) pPTE, (DWORD) pAddress, (DWORD) ((((DWORD) pAddress) >> (PAGE_BITS)) & 0x03ff) );
			TRACE( str );
			(System->Debug())->MemoryDump( (PBYTE) pPTE, 0x10 );
			}
#endif
		// Reservem la pgina demanada en el mode adient
		if( pproc && pproc->PrivilegeLevel() == MODE_USER )
			physpage = (System->PAT())->AllocPage( USER_PAGE, pPTE, (DWORD) pAddress, NULL, NULL, FALSE ); // -BUG
		else
			physpage = (System->PAT())->AllocPage( SYSTEM_PAGE, pPTE, (DWORD) pAddress, NULL, NULL, TRUE ); // -BUG

#ifdef _DEBUG
		if( DebugLevel > 35 )
			{
			(System->Debug())->MemoryDump( (PBYTE) pPTE, 0x10 );
			TRACE( TEXT( "dwSize" ) );
			}
#endif
		dwSize -= PAGE_SIZE; // Ja falta menys
		pAddress = ((PBYTE) pAddress + PAGE_SIZE); // Pgina segent
		}

	if( temp ) // Si havem canviat el nostre espai d'adreces, tornem a l'antic
		{
		flags = CLI();
		pctss->PDBR( temp );
		SetCR3( temp );
		STI( flags );
		}

#ifdef _DEBUG
	if( DebugLevel > 35 )
		TRACE( TEXT( "fi de Commit" ) );
#endif
	}

