/* **************************************************************************
*                                                                           *
*  PAT.CPP                                                                  *
*                                                                           *
*  13-05-97                                                    BUILD:0005   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control de la memria fsica                                             *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\pat.h"
#include "kernel\asm.h"
#include "errors.h"
#include "kernel\kernel.h"
#include "string.h"
#include "kernel\system.h"

extern PCkeKernel _export Kernel;

// **************************************************************************
// Prepara l'objecte per a utilitzar les adreces correctes de la PAT
// Com a entrada ha de rebre:
// Table			- L'adrea logica de la PAT
// Size			- El tamany en bytes de la PAT
// Special		- Indica si estem creant una PAT especial (la PAT16)
CkePAT::CkePAT( DWORD Table, DWORD Size, BOOL bSpecial ) : CkeType( CID_PAT )
	{
	ptable	= (PTPAT) Table;
	dwsize	= Size;
	bspecial	= bSpecial;
	}

// **************************************************************************
// Destructor de l'objecte
CkePAT::~CkePAT()
	{
// No s'arriba a cridar mai per a la PAT32
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CkePAT::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_PAT )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Inicialitza la PAT assignada a l'objecte
VOID CkePAT::Clear()
	{
	PDWORD addr = (PDWORD) ptable;

	for( DWORD i = 0; i < dwsize / sizeof( DWORD ); i++ )
		addr[ i ] = 0L;
	}

// **************************************************************************
// Inicialitza a zero la pgina demanada
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina a inicialitzar
// LPage	- Adrea logica de la pgina a inicialitzar
VOID CkePAT::ClearPage( DWORD PPage, PDWORD LPage )
	{
	for( DWORD pos = 0; pos < PAGE_SIZE / sizeof( DWORD ); pos++ )
		LPage[ pos ] = 0L;

	// activar el flag INITIALIZED_PAGE de PPage
	ptable[ (PPage >> PAGE_BITS) ].cFlags |= INITIALIZED_PAGE;
	}

// **************************************************************************
// Retorna l'adrea fsica de la pgina reservada
// Com a entrada ha de rebre:
// Owner			- Identifica al destinatari de la pgina
// PTE      	- Indica la PageTableEntry que fa referncia a aquesta pgina
// LogAddress	- Adrea lgica sobre la que volem mapejar la pgina
// Region		- Regi a la qual pertany la pgina
// Offset    	- Desplaament dins la regi
// Locked		- Indica si la pgina ha d'estar fixada en memria
DWORD CkePAT::AllocPage( BYTE cOwner, PTPage pPTE, DWORD dwLogAddress, PCkeRegion pRegion, DWORD dwOffset, BOOL bLocked )
	{
	DWORD flags = CLI();
	// Cercar una pgina lliure
	DWORD count = 0L;

	while( ptable[ count ].cOwner != FREE_PAGE && count < (dwsize / sizeof( TPAT )) )
		count++;

	// si no en trobem cap, no queda memria
	if( ptable[ count ].cOwner != FREE_PAGE )
		{
		TRACE( TEXT( "NO HI HA PROU MEMORIA!!!" ) );
		STI( flags );
		return 0L;
		}

	// quan tenim ja una pgina lliure, la inicialitzem si no ho est
	if( !(ptable[ count ].cFlags & INITIALIZED_PAGE) )
		{
		if( dwLogAddress ) // Si ens donen informaci de mapeig, la utilitzem
			{
			if( !pPTE )
				TRACE( TEXT( "Error en els parametres de PAT::AllocPage (pPTE == NULL i dwLogAddress != NULL)" ) );

			CPage Page( pPTE );
			Page.Writeable( TRUE );
			Page.COW( FALSE );
			Page.Readable( FALSE );
			Page.Executable( FALSE );

			if( cOwner == USER_PAGE )
				Page.User( TRUE );
			else
				Page.User( FALSE );

			if( bspecial ) // La PAT16 comnea per el segon MB.
				Page.PageAddress( (count << PAGE_BITS) + 0x100000 );
			else
				Page.PageAddress( count << PAGE_BITS );

			Page.Present( TRUE );

#ifdef _DEBUG
			if( DebugLevel > 98 )
				(System->Debug())->MemoryDump( (PBYTE) pPTE, 0x10 );
#endif
			ClearPage( count << PAGE_BITS, (PDWORD) dwLogAddress ); // Inicialitzem a zero
			}
		else // No tenim informaci de mapeig, per per a inicialitzar la pgina cal mapejar-la
			{
			CTPage PageDir16( (PTPage) 0x80000L );
			CPage SpecialPage( PageDir16.Page( 0 ) );
			CTPage SpecialTable( (PTPage) SpecialPage.PageAddress() );

			SpecialPage.Page( SpecialTable.Page( 0 ) );
			DWORD oldaddr = SpecialPage.PageAddress();

			SpecialPage.Writeable( TRUE );

			if( bspecial )
				SpecialPage.PageAddress( (count << PAGE_BITS) + 0x100000 );
			else
				SpecialPage.PageAddress( count << PAGE_BITS );

			BOOL bPresent = SpecialPage.Present();
			SpecialPage.Present( TRUE );
			CacheCR3();

			PDWORD logpos = (PDWORD) 0x0L; // Hem mapejat en posici 0x00000000

			for( DWORD pos = 0; pos < PAGE_SIZE / sizeof( DWORD ); pos++ )
				logpos[ pos ] = 0;

			SpecialPage.PageAddress( oldaddr );
			SpecialPage.Present( bPresent );
			CacheCR3();
			}
		}

	// ara podem assignar els nous valors a la PATEntry i retornar l'adrea
	ptable[ count ].pRegion = pRegion;
	ptable[ count ].dwOffset = dwOffset;
	ptable[ count ].pHelper = NULL;	// -BUG
	ptable[ count ].dwAge = 0;
	ptable[ count ].wUsageCount = 1;
	if( bLocked )
		ptable[ count ].cFlags |= LOCKED_PAGE;
	ptable[ count ].cOwner = cOwner;
	STI( flags );

	if( bspecial )
		return (count << PAGE_BITS) + 0x100000;
	else
		return (count << PAGE_BITS);
	}

// **************************************************************************
// Allibera la pgina fsica assenyalada
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina alliberada
VOID CkePAT::FreePage( DWORD PPage )
	{
// comprovem que la pgina estigui ocupada i l'alliberem
	if( ptable[ PPage >> PAGE_BITS ].cOwner != FREE_PAGE )
		{
		ptable[ PPage >> PAGE_BITS ].cOwner = FREE_PAGE;
		ptable[ PPage >> PAGE_BITS ].cFlags = 0;
// Qu en fem de pRegion i pHelper ? -BUG
		}
	}

// **************************************************************************
// Retorna l'adrea de la regi que t assignada la pgina fsica assenyalada
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina sobre la qual volem informaci
PCkeRegion CkePAT::Region( DWORD PPage )
	{
	SETERRORCODE( OK );
// comprovem que sigui del tipus USER_PAGE i retornem el pRegion
	if( ptable[ PPage >> PAGE_BITS ].cOwner == USER_PAGE )
		return ptable[ PPage >> PAGE_BITS ].pRegion;

	SETERRORCODE( PAT_BADPAGE );
	return NULL;
	}

// **************************************************************************
// Retorna l'edat de la pgina
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina sobre la qual volem informaci
DWORD CkePAT::Age( DWORD PPage )
	{
// Noms cal retornar el valor de dwAge per a la pgina indicada
	return ptable[ PPage >> PAGE_BITS ].dwAge;
	}

// **************************************************************************
// Retorna el compte d's d'una pgina fsica
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina sobre la qual volem informaci
WORD CkePAT::UsageCount( DWORD PPage )
	{
// Nomes cal retornar el valor de wUsageCount per a la pgina indicada
	return ptable[ PPage >> PAGE_BITS ].wUsageCount;
	}

// **************************************************************************
// Retorna la paraula que identifica quin tipus de propietari t la pgina
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina sobre la qual volem informaci
BYTE CkePAT::Owner( DWORD PPage )
	{
// Nomes cal retornar el valor de cOwner
	return ptable[ PPage >> PAGE_BITS ].cOwner;
	}

// **************************************************************************
// Retorna el 'byte' de flags de la pgina
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina sobre la qual volem informaci
BYTE CkePAT::Flags( DWORD PPage )
	{
// retornem el valor de cFlags
	return ptable[ PPage >> PAGE_BITS ].cFlags;
	}

// **************************************************************************
// Indica si la pgina fsica esta lliure
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina sobre la qual volem informaci
BOOL CkePAT::IsFreePage( DWORD PPage )
	{
// comprovar si es de tipus FREE_PAGE i retornem TRUE o FALSE
	if( ptable[ PPage >> PAGE_BITS ].cOwner == FREE_PAGE )
		return TRUE;

	return FALSE;
	}

// **************************************************************************
// Indica si la pgina fsica es propietat del sistema
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina sobre la qual volem informaci
BOOL CkePAT::IsSystemPage( DWORD PPage )
	{
// comprovar si es de tipus SYSTEM_PAGE i retornem TRUE o FALSE
	if( ptable[ PPage >> PAGE_BITS ].cOwner == SYSTEM_PAGE )
		return TRUE;

	return FALSE;
	}

// **************************************************************************
// Indica si la pgina fsica es propietat de la 'cache' de disc
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina sobre la qual volem informaci
BOOL CkePAT::IsCachePage( DWORD PPage )
	{
// comprovar si es de tipus CACHE_PAGE i retornem TRUE o FALSE
	if( ptable[ PPage >> PAGE_BITS ].cOwner == CACHE_PAGE )
		return TRUE;

	return FALSE;
	}

// **************************************************************************
// Indica si la pgina fsica es propietat d'un procs d'usuari
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina sobre la qual volem informaci
BOOL CkePAT::IsUserPage( DWORD PPage )
	{
// comprovar si es de tipus USER_PAGE i retornem TRUE o FALSE
	if( ptable[ PPage >> PAGE_BITS ].cOwner == USER_PAGE )
		return TRUE;

	return FALSE;
	}

// **************************************************************************
// Assigna a una pgina fsica un procs propietari
// Com a entrada ha de rebre:
// PPage		- Adrea fsica de la pgina a la qual canviem la informaci
// Region	- Adrea del CkeRegion
VOID CkePAT::Region( DWORD PPage, PCkeRegion pRegion )
	{
// comprovem que sigui de tipus USER_PAGE i li assignem el procs
	if( ptable[ PPage >> PAGE_BITS ].cOwner == USER_PAGE )
		ptable[ PPage >> PAGE_BITS ].pRegion = pRegion;
	}

// **************************************************************************
// Assigna a una pgina fsica una certa edat
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina a la qual canviem la informaci
// Age  	- Edat de la pgina
VOID CkePAT::Age( DWORD PPage, BYTE cAge )
	{
// assignem l'edat a la pgina indicada
	ptable[ PPage >> PAGE_BITS ].dwAge = cAge;
	}

// **************************************************************************
// Assigna a una pgina fsica un cert compte d's
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina a la qual canviem la informaci
// Count	- Nou valor per a UsageCount
VOID CkePAT::UsageCount( DWORD PPage, WORD wCount )
	{
// assignem el nou valor a wUsageCount
	ptable[ PPage >> PAGE_BITS ].wUsageCount = wCount;
	}

// **************************************************************************
// Assigna a una pgina fsica un nou valor per als seus 'flags'
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina a la qual canviem la informaci
// Flags	- Nou valor per a Flags
VOID CkePAT::Flags( DWORD PPage, BYTE cFlags )
	{
// assignar el nou valor a cFlags
	ptable[ PPage >> PAGE_BITS ].cFlags = cFlags;
	}

// **************************************************************************
// Incrementa el compte d's d'una pgina
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina a la qual canviem la informaci
VOID CkePAT::UsePage( DWORD PPage )
	{
	SETERRORCODE( OK );
// incrementar el wUsageCount si no es de tipus FREE_PAGE i es < 0xffff -BUG
	if( ptable[ PPage >> PAGE_BITS ].cOwner != FREE_PAGE )
		{
		if( ptable[ PPage >> PAGE_BITS ].wUsageCount < MAX_USAGE )
			ptable[ PPage >> PAGE_BITS ].wUsageCount++;
		else
			SETERRORCODE( PAT_TOOMUCHUSED );
		}
	}

// **************************************************************************
// Decrementa el compte d's d'una pgina
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina a la qual canviem la informaci
VOID CkePAT::LetPage( DWORD PPage )
	{
	SETERRORCODE( OK );
// decrementar el wUsageCount si no es de tipus FREE_PAGE i es > 0 -BUG
	if( ptable[ PPage >> PAGE_BITS ].cOwner != FREE_PAGE )
		{
		if( ptable[ PPage >> PAGE_BITS ].wUsageCount > 0 )
			ptable[ PPage >> PAGE_BITS ].wUsageCount--;
		else
			SETERRORCODE( PAT_BADLET );
		}
	}

// **************************************************************************
// Assigna al sistema una certa pgina fsica
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina a la qual canviem la informaci
VOID CkePAT::SetSystemPage( DWORD PPage )
	{
// assignar l'cOwner = SYSTEM_PAGE
	ptable[ PPage >> PAGE_BITS ].cOwner = SYSTEM_PAGE;
// ATENCIO - No canvia el PTE !!!
	}

// **************************************************************************
// Assigna a la 'cache' una certa pgina fsica
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina a la qual canviem la informaci
VOID CkePAT::SetCachePage( DWORD PPage )
	{
// assignar l'cOwner = CACHE_PAGE
	ptable[ PPage >> PAGE_BITS ].cOwner = CACHE_PAGE;
// ATENCIO - No canvia el PTE !!!
	}

// **************************************************************************
// Assigna a un usuari una certa pgina fsica
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina a la qual canviem la informaci
VOID CkePAT::SetUserPage( DWORD PPage )
	{
// assignar l'cOwner = USER_PAGE
	ptable[ PPage >> PAGE_BITS ].cOwner = USER_PAGE;
// ATENCIO - No canvia el PTE !!!
	}

// **************************************************************************
// Assigna a una pgina fsica l'edat mxima
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina a la qual canviem la informaci
VOID CkePAT::MakeOld( DWORD PPage )
	{
// assignar a dwAge = 0L
	ptable[ PPage >> PAGE_BITS ].dwAge = 0;
	}

// **************************************************************************
// Assigna a una pgina l'edat mnima
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina a la qual canviem la informaci
VOID CkePAT::MakeYoung( DWORD PPage )
	{
	ptable[ PPage >> PAGE_BITS ].dwAge = MIN_AGE;
	}

// **************************************************************************
// Incrementa l'edat d'una pgina fsica
// Com a entrada ha de rebre:
// PPage	- Adrea fsica de la pgina a la qual canviem la informaci
// Age  	- Valor a sumar (0 o 1)
VOID CkePAT::AddAge( DWORD PPage, BOOL bAge )
	{
// suma el valor Age a dwAge (segons l'algorisme li suma al bit mes/meys
// significatiu) -BUG
	ptable[ PPage >> PAGE_BITS ].dwAge = (BYTE) (ptable[ PPage >> PAGE_BITS ].dwAge >> 1);
	ptable[ PPage >> PAGE_BITS ].dwAge |= (BYTE) (bAge << AGE_BITS);
	}

// **************************************************************************
// Prepara la pgina segons els parmetres
// Com a entrada ha de rebre:
// PPage		- Adrea fsica de la pgina a la qual canviem la informaci
// Region	- Regi a la qual pertany la pgina
// Offset	- Desplaament de la pgina dins la regi
// Owner		- Propietari
VOID CkePAT::MakePage( DWORD PPage, PCkeRegion pRegion, DWORD dwOffset, BYTE cOwner )
	{
	ptable[ PPage >> PAGE_BITS ].pRegion = pRegion;
	ptable[ PPage >> PAGE_BITS ].dwOffset = dwOffset;
	ptable[ PPage >> PAGE_BITS ].pHelper = NULL;	// -BUG
	ptable[ PPage >> PAGE_BITS ].dwAge = 0;
	ptable[ PPage >> PAGE_BITS ].wUsageCount = 1;
	ptable[ PPage >> PAGE_BITS ].cFlags = 0;
	ptable[ PPage >> PAGE_BITS ].cOwner = cOwner;
	}

// **************************************************************************
// Indica si la zona est lliure
// Com a entrada ha de rebre:
// PPage		- Adrea fsica de la primera pgina de la zona
// Size 		- Quantitat de 'bytes' de la regi
BOOL CkePAT::IsRegionFree( DWORD PPage, DWORD dwSize )
	{
	DWORD flags = CLI();

	while( ptable[ PPage >> PAGE_BITS ].cOwner == FREE_PAGE && dwSize )
		{
		dwSize -= PAGE_SIZE;
		PPage += PAGE_SIZE;
		}

	STI( flags );

	if( dwSize )
		return FALSE;
	else
		return TRUE;
	}

// **************************************************************************
// Indica si la zona est reservada
// Com a entrada ha de rebre:
// PPage		- Adrea fsica de la primera pgina de la zona
// Size 		- Quantitat de 'bytes' de la regi
BOOL CkePAT::IsRegionReserved( DWORD PPage, DWORD dwSize )
	{
	DWORD flags = CLI();
	DWORD count = (PPage >> PAGE_BITS);

	while( ptable[ count ].cOwner == RESERVED_PAGE && dwSize )
		{
		dwSize -= PAGE_SIZE;
		count++;
		}

	STI( flags );

	if( dwSize )
		return FALSE;
	else
		return TRUE;
	}

// **************************************************************************
// Retorna el compte de pgines lliures
DWORD CkePAT::CountFreePages()
	{
	DWORD flags = CLI();
	DWORD count = 0;

	for( DWORD current = 0; current < (dwsize / sizeof( TPAT )); current++ )
		{
		if( ptable[ current ].cOwner == FREE_PAGE )
			count++;
		}

	STI( flags );
	return count;
	}

// **************************************************************************
// Retorna el compte de pgines utilitzades
DWORD CkePAT::CountUsedPages()
	{
	DWORD flags = CLI();
	DWORD count = 0;

	for( DWORD current = 0; current < (dwsize / sizeof( TPAT )); current++ )
		{
		if( ptable[ current ].cOwner != FREE_PAGE )
			count++;
		}

	STI( flags );

	return count;
	}

