/* **************************************************************************
*                                                                           *
*  Resource.CPP                                                             *
*                                                                           *
*  02-05-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica per a tots els recursos                                  *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\resource.h"
#include "kernel\kernel.h"
#include "errors.h"
#include "kernel\system.h"
#include "string.h"
#include "kernel\asm.h"

extern PCkeKernel Kernel;
extern BOOL bSpecialMemory;

// **************************************************************************
// Constructor de la classe
CkeResource::CkeResource( PCkeObject pParent, PSTR sName, BOOL bTemp ) : CkeObject( pParent, sName, bTemp )
	{
	id = CID_Resource;

	DWORD flags = CLI();

	cstatus 		= 0;
	lwaitcalls 	= 0;
	pthread 		= NULL;

	{ // En memria global per poder accedir-hi sempre
	bSpecialMemory = TRUE;
	pwaiting = new CkeThreadList(); // Preparem la llista de fluxos en espera
	bSpecialMemory = FALSE;
	}

	STI( flags );
	}

// **************************************************************************
// Destructor de la classe
CkeResource::~CkeResource()
	{
	if( pwaiting ) // Eliminem la llista d'espera
		{
		delete pwaiting;
		pwaiting = NULL;
		}
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CkeResource::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Resource )
		return TRUE;
	else
		return CkeObject::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'estat del recurs
BYTE CkeResource::Status()
	{
	return cstatus;
	}

// **************************************************************************
// Modifica l'estat del recurs
// Com a entrada ha de rebre:
// Status	  	- Nou estat del recurs
VOID CkeResource::Status( BYTE cStatus )
	{
	DWORD flags = CLI();
	cstatus = cStatus;
	STI( flags );
	}

// **************************************************************************
// Allibera el recurs
VOID CkeResource::Release()
	{
	if( !System->Running() ) // Si no s'est executant cap flux podem retornar
		return;

	DWORD flags = CLI();

	if( pthread == System->Running() ) // El flux que fa 'Release' ha de ser el que havia fet 'Wait'
		{
		SETERRORCODE( OK );

		lwaitcalls--;

		// Si s l'ltim 'Release' del flux
		if( !lwaitcalls )
			{
			pthread = NULL; // Ja no hi ha cap flux que hagi fet 'Wait'

			if( pwaiting ) // Despertem els fluxos en espera
				{
				PCkeThread pfirst = (PCkeThread) pwaiting->Get();

				while( pfirst )
					{
					PCkeListItem pnext = pfirst->GetNext();
					pwaiting->Delete( pfirst );
					System->Ready( pfirst );
					pfirst = (PCkeThread) pnext;
					}
				}
			}
		}
	else
		SETERRORCODE( RES_BADRELEASE );

	STI( flags );
	}

// **************************************************************************
// Espera l'alliberaci del recurs
VOID CkeResource::Wait()
	{
	if( !System->Running() )
		return;

	DWORD flags = CLI();

	if( !pthread ) // Si no hi ha cap flux que hagi fer 'Wait'...
		pthread = System->Running(); // ...ara ja n'hi ha un

	if( pthread == System->Running() ) // Si el flux que ha fet 'Wait', ja n'havia fet un altre...
		lwaitcalls++; // ...incrementem compte de crides
	else // Si s un altre flux
		{
		(System->Running())->Status( STATUS_BLOCKED );
		pwaiting->Add( System->Running() ); // Aquest flux s'ha de bloquejar

		Kernel->Scheduler(); // Planifiquem
		// Quan despertem...
		pthread = System->Running(); // ...serem els "propietaris" del recurs
		lwaitcalls++; // i haurem fet una crida a 'Wait'
		}

	STI( flags );
	}

