/* **************************************************************************
*                                                                           *
*  Sem.CPP                                                                  *
*                                                                           *
*  19-03-97                                                    BUILD:0003   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe que implementa els semfors                                       *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\sem.h"
#include "errors.h"
#include "kernel\system.h"
#include "kernel\asm.h"
#include "kernel\kernel.h"

extern PCkeKernel _export Kernel;

// **************************************************************************
// Constructor de la classe
CkeSemaphore::CkeSemaphore( LONG lCount, PCkeObject pParent, PSTR sName, BOOL bTemp ) : CkeResource( pParent, sName, bTemp )
	{
	id = CID_Semaphore;

	lwaitcalls = lCount;
	}

// **************************************************************************
// Destructor de la classe
CkeSemaphore::~CkeSemaphore()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CkeSemaphore::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Semaphore )
		return TRUE;
	else
		return CkeResource::ClassCheck( Cuid );
	}

// **************************************************************************
// Espera a un semfor
VOID CkeSemaphore::Wait()
	{
	DWORD flags = CLI();

	lwaitcalls--;

	if( lwaitcalls < 0 ) // No hi poden haver ms fluxos concurrents
		{
		(System->Running())->Status( STATUS_BLOCKED );
		pwaiting->Add( System->Running() ); // Bloquejar el flux

		Kernel->Scheduler(); // Planifiquem
		}

	STI( flags );
	}

// **************************************************************************
// Allibera un semfor
VOID CkeSemaphore::Release()
	{
	DWORD flags = CLI();

	lwaitcalls++;

	if( lwaitcalls >= 0 )
		{
		if( pwaiting ) // Despertar els fluxos en espera
			{
			PCkeThread pfirst = (PCkeThread) pwaiting->Get();

			while( pfirst ) // Mentre hi hagi fluxos per a despertar
				{
				PCkeListItem pnext = pfirst->GetNext(); // Obtenim el segent
				pwaiting->Delete( pfirst ); // Treiem el flux de la llista d'espera
				System->Ready( pfirst ); // Passem el flux a la llista de preparats
				pfirst = (PCkeThread) pnext; // Tractem el segent
				}
			}
		}

	STI( flags );
	}

