/* **************************************************************************
*                                                                           *
*  Thread.CPP                                                               *
*                                                                           *
*  19-03-97                                                    BUILD:0003   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe CkeThread per al control dels fluxos de cada procs               *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\thread.h"
#include "errors.h"
#include "kernel\mem.h"
#include "string.h"
#include "kernel\eflags.h"
#include "kernel\kernel.h"
#include "kernel\asm.h"
#include "kernel\system.h"

#define USER_RPL	3

extern PCkeKernel _export Kernel;

// **************************************************************************
// Constructor de la classe
CkeThreadList::CkeThreadList() : CkeLIFOList()
	{
	id	= CID_ThreadList;
	}

// **************************************************************************
// Destructor de la classe
CkeThreadList::~CkeThreadList()
	{
	}

// **************************************************************************
// Afegir un flux a la llista (ordenadament)
// Com a entrada ha de rebre:
// Item     	- Flux a afegir
VOID CkeThreadList::Add( PCkeListItem pItem )
	{
	DWORD flags = CLI();

	PCkeThread pThread = (PCkeThread) pItem;

	if( pfirst ) // Ja hi ha algun element a la llista
		{
		PCkeThread pelem = (PCkeThread) pfirst;

		// Cerquem el primer flux que tingui una prioritat ms gran o igual
		while( pelem->GetNext() && pelem->Priority() < pThread->Priority() )
			pelem = (PCkeThread) pelem->GetNext();

		if( pelem->Priority() == pThread->Priority() )
			{
			// Cerquem el primer flux que tingui un 'LastQuantum' o una prioritat superiors
			while( pelem->GetNext() && pelem->LastQuantum() < pThread->LastQuantum() && pelem->Priority() == pThread->Priority() )
				pelem = (PCkeThread) pelem->GetNext();

			if( pelem->Priority() > pThread->Priority() )
				pelem = (PCkeThread) pelem->GetPrev();
			}

		PCkeThread pelem2 = (PCkeThread) pelem->GetNext();

		pelem->SetNext( pThread ); // Introdum el nou flux a la llista
		pThread->SetNext( pelem2 );
		pThread->SetPrev( pelem );

		if( pelem2 )
			pelem2->SetPrev( pThread );
		}
	else // La llista s buida
		{
		pThread->SetPrev( NULL );
		pThread->SetNext( NULL );
		pfirst = pThread; // Nou cap de la llista
		}

	STI( flags );
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// EntryPoint		- Punt d'entrada al flux
// StackReserve	- Quantitat de memria reservada per a la pila del flux
// StackCommit		- Quantitat de memria compromesa per a la pila del flux
// Proc		    	- Apuntador al procs al qual pertany el flux
// Parent	   	- Apuntador a l'objecte que fa de pare del flux
// Name     		- Nom del flux
// Temp     		- Indica si el flux s temporal (no s'utilitza actualment)
CkeThread::CkeThread( DWORD dwEntryPoint, DWORD dwStackReserve, DWORD dwStackCommit, PCkeProcess pProc, PCkeObject pParent, PSTR sName, BOOL bTemp ) : CkeResource( pParent, sName, bTemp )
	{
	CHECK_CLASS( pProc, CID_Process, TEXT( "CkeThread::CkeThread->pProc no s de tipus PCkeProcess" ) );

	pproc					= pProc;
	dwusertime			= dwkerneltime = 0;
	dwcreationtime		= System->TickTime();
	ccurrentpriority	= pproc->BasePriority();
	dwexitstatus		= 0;
	dwerrorcode			= OK;
	BOOL bUser			= pproc->PrivilegeLevel();

	DWORD flags = CLI();

	PTDescriptor ptdesc;

	{ // Creem el descriptor del TSS
	WORD index = (System->GDT())->CreateDescriptor();
	ptdesc = (System->GDT())->Descriptor( index );
	CDescriptor desc( ptdesc );
	WORD tsssize = (WORD) sizeof( TTSS );
	DWORD tssbase = (DWORD) malloc( tsssize );
	desc.Base( tssbase );
	desc.Limit( tsssize - 1 );
	desc.Granularity( FALSE );
	desc.Present( TRUE );
	}

	ptss = new CTSS( ptdesc );
	ptss->Clear(); // Inicialitzem el TSS

	ptss->Set( TSS_FREE );
	ptss->PDBR( pproc->PDBR() );

	if( bUser ) // Els fluxos d'usuari utilitzen un RPL = 3
		{
		ptss->SetCSEIP( PROC_CODE | USER_RPL, dwEntryPoint );
		ptss->ES( PROC_DATA | USER_RPL );
		ptss->DS( PROC_DATA | USER_RPL );
		ptss->FS( PROC_DATA | USER_RPL );
		ptss->GS( PROC_DATA | USER_RPL );
		}
	else // Els fluxos del sistema tenen RPL = 0
		{
		ptss->SetCSEIP( PROC_CODE, dwEntryPoint );
		ptss->ES( PROC_DATA );
		ptss->DS( PROC_DATA );
		ptss->FS( PROC_DATA );
		ptss->GS( PROC_DATA );
		}

	ptss->LDT( (WORD) (pproc->LDTEntry() << 3) ); // Selector de LDT
	ptss->EFLAGS( NORMAL_FLAGS );
	ptss->IOMap( (WORD) 0xffff );

	if( pproc->PrivilegeLevel() == MODE_USER )
		{ // Els fluxos d'usuari necessiten dues piles: una per a ells i una per al sistema
		PCkeRegion Stackregion = new CkeRegion( NULL, dwStackReserve, REGION_WRITE | REGION_USER, NULL );
		PVOID Stackaddr = pproc->Map( Stackregion, VA_READ | VA_WRITE );
		// SS tamb ha de tenir un RPL = 3
		ptss->SetSSESP( PROC_DATA | USER_RPL, (DWORD) Stackaddr + (dwStackReserve - 1) );
		pproc->Commit( (PBYTE) Stackaddr + (dwStackReserve - dwStackCommit), dwStackCommit );

		// Pila del nivell 0 (una sola pgina)
		PCkeRegion SysStackregion = new CkeRegion( NULL, PAGE_SIZE, REGION_WRITE, NULL );
		PVOID SysStackaddr = pproc->Map( SysStackregion, VA_READ | VA_WRITE );
		ptss->SetStack( 0, 0x10, (DWORD) SysStackaddr + (PAGE_SIZE - 1) );
		pproc->Commit( SysStackaddr, PAGE_SIZE );
		}
	else // Els fluxos del sistema tenen una sola pila amb RPL = 0
		{
		PCkeRegion Stackregion = new CkeRegion( NULL, dwStackReserve, REGION_WRITE, NULL );
		PVOID Stackaddr = pproc->Map( Stackregion, VA_READ | VA_WRITE );
		ptss->SetSSESP( PROC_DATA, (DWORD) Stackaddr + (dwStackReserve - 1) );
		ptss->SetStack( 0, 0x10, (DWORD) Stackaddr + (dwStackReserve - 1) );
		pproc->Commit( (PBYTE) Stackaddr + (dwStackReserve - dwStackCommit), dwStackCommit );
		}

	pproc->AddThread( this ); // Afegim el flux a totes les llistes necessries
	System->AddThread( this );
	System->Ready( this );

	STI( flags );
	}

// **************************************************************************
// Destructor de la classe
CkeThread::~CkeThread()
	{
	DWORD flags = CLI();

// Sortir de les llistes
	if( NextInProc() )
		(NextInProc())->PrevInProc( PrevInProc() );

	if( PrevInProc() )
		(PrevInProc())->NextInProc( NextInProc() );

// Esborrar el TSS -BUG
	delete ptss;

	STI( flags );
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CkeThread::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Thread )
		return TRUE;
	else
		return CkeResource::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna el codi d'error actual del flux
DWORD CkeThread::ErrorCode()
	{
	return dwerrorcode;
	}

// **************************************************************************
// Afegeix temps d'execucio en mode usuari
// Com a entrada ha de rebre:
// Count    	- Valor a afegir al comptador
VOID CkeThread::AddUserTime( DWORD dwCount )
	{
	dwusertime += dwCount;
	}

// **************************************************************************
// Afegeix temps d'execuci en mode privilegiat
// Com a entrada ha de rebre:
// Count    	- Valor a afegir al comptador
VOID CkeThread::AddKernelTime( DWORD dwCount )
	{
	dwkerneltime += dwCount;
	}

// **************************************************************************
// Obt el temps d'execuci en mode privilegiat
DWORD CkeThread::KernelTime()
	{
	return dwkerneltime;
	}

// **************************************************************************
// Obt el temps d'execuci en mode usuari
DWORD CkeThread::UserTime()
	{
	return dwusertime;
	}

// **************************************************************************
// Modifica el codi d'error actual del flux
// Com a entrada ha de rebre:
// ErrorCode	- Nou codi d'error
VOID CkeThread::ErrorCode( DWORD dwErrorCode )
	{
	dwerrorcode = dwErrorCode;
	}

// **************************************************************************
// Retorna l'apuntador al flux segent de la llista d'un procs
PCkeThread CkeThread::NextInProc()
	{
	return psameprocnext;
	}

// **************************************************************************
// Retorna l'apuntador al flux anterior de la llista d'un procs
PCkeThread CkeThread::PrevInProc()
	{
	return psameprocprev;
	}

// **************************************************************************
// Retorna l'apuntador al flux segent de la llista d'un recurs/de preparats
PCkeThread CkeThread::NextInAll()
	{
	return pallnext;
	}

// **************************************************************************
// Retorna l'apuntador al flux anterior de la llista d'un recurs/de preparats
PCkeThread CkeThread::PrevInAll()
	{
	return pallprev;
	}

// **************************************************************************
// Modifica l'apuntador al flux segent de la llista d'un procs
// Com a entrada ha de rebre:
// pNext		- Nou valor
VOID CkeThread::NextInProc( PCkeThread pNext )
	{
	DWORD flags = CLI();
	psameprocnext = pNext;
	STI( flags );
	}

// **************************************************************************
// Modifica l'apuntador al flux anterior de la llista d'un procs
// Com a entrada ha de rebre:
// pPrev		- Nou valor
VOID CkeThread::PrevInProc( PCkeThread pPrev )
	{
	DWORD flags = CLI();
	psameprocprev = pPrev;
	STI( flags );
	}

// **************************************************************************
// Modifica l'apuntador al flux segent de la llista d'un recurs/de preparats
// Com a entrada ha de rebre:
// pNext		- Nou valor
VOID CkeThread::NextInAll( PCkeThread pNext )
	{
	DWORD flags = CLI();
	pallnext = pNext;
	STI( flags );
	}

// **************************************************************************
// Modifica l'apuntador al flux anterior de la llista d'un recurs/de preparats
// Com a entrada ha de rebre:
// pPrev		- Nou valor
VOID CkeThread::PrevInAll( PCkeThread pPrev )
	{
	DWORD flags = CLI();
	pallprev = pPrev;
	STI( flags );
	}

// **************************************************************************
// Retorna la prioritat actual del flux
BYTE CkeThread::Priority()
	{
	return ccurrentpriority;
	}

// **************************************************************************
// Modifica la prioritat actual del flux
// Com a entrada ha de rebre:
// Priority	- Nou valor per a la prioritat
VOID CkeThread::Priority( BYTE cPriority )
	{
// Controlar els lmits -BUG
	DWORD flags = CLI();
	ccurrentpriority = cPriority;
	STI( flags );
	}

// **************************************************************************
// Retorna el procs al que pertany el flux
PCkeProcess CkeThread::Process()
	{
	return pproc;
	}

// **************************************************************************
// Retorna el comptador del moment de la creaci del flux
DWORD CkeThread::CreationTime()
	{
	return dwcreationtime;
	}

// **************************************************************************
// Retorna l'estat del flux finalitzat
DWORD CkeThread::ExitStatus()
	{
// Retornar error si no s'ha finalitzat? -BUG
	return dwexitstatus;
	}

// **************************************************************************
// Modifica la variable que cont l'estat a la finalitzaci del flux
// Com a entrada ha de rebre:
// Status	- Nou valor
VOID CkeThread::Exit( DWORD dwStatus )
	{
	dwexitstatus = dwStatus;
// Finalitzaci del thread -> ZOMBIE -BUG
	}

// **************************************************************************
// Retorna el temps d'execuci del flux en l'ltim quantum
BYTE CkeThread::LastQuantum()
	{
	return clastquantum;
	}

// **************************************************************************
// Modifica la variable que cont el temps d'execuci del flux en l'ltim quantum
// Com a entrada ha de rebre:
// Quantum	- Nou valor
VOID CkeThread::LastQuantum( BYTE cQuantum )
	{
	clastquantum = cQuantum;
	}

// **************************************************************************
// Retorna l'apuntador a l'objecte que controla el TSS
PCTSS CkeThread::TSS()
	{
	return ptss;
	}

