/* **************************************************************************
*                                                                           *
*  Timer.CPP                                                                *
*                                                                           *
*  13-05-97                                                    BUILD:0003   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a la implementaci d'alarmes (Timers)                         *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\timer.h"
#include "kernel.h"
#include "errors.h"
#include "aal\aal.h"
#include "string.h"
#include "messages.h"
#include "kernel\asm.h"

extern PCkeKernel EXPKERNEL Kernel;

// **************************************************************************
// Prepara l'objecte
CkeTimer::CkeTimer( LONG lTimeOut, PCkeMailBox pMailBox, PCkeObject pParent, PSTR sName, BOOL bTemp ) : CkeCallback( pMailBox, pParent, sName, bTemp )
	{
	id = CID_Timer;

	Time(	lTimeOut );
	Kernel->AddTimer( this );
	}

// **************************************************************************
// Destructor de l'objecte
CkeTimer::~CkeTimer()
	{
	SETERRORCODE( OK );
	Kernel->DestroyTimer( this );
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CkeTimer::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Timer )
		return TRUE;
	else
		return CkeCallback::ClassCheck( Cuid );
	}

// **************************************************************************
// Selecciona un nou interval per a l'alarma
// Com a entrada ha de rebre:
// Time     	- Nou interval
VOID CkeTimer::Time( LONG lTime )
	{
	ltimeout = lTime;
	}

// **************************************************************************
// Retorna l'interval de l'alarma
LONG CkeTimer::Time()
	{
	return ltimeout;
	}

// **************************************************************************
// Fem sonar l'alarma enviant un missatge a la bstia del 'timer'
VOID CkeTimer::Release()
	{
//	DWORD flags = CLI();

	TMSG msg; // Preparem el missatge
	msg.dwMessage	= SM_TIMER;
	msg.dwParam1	= (DWORD) this;
	msg.dwParam2	= 0;
	msg.pReply    	= NULL;

	pmailbox->PostMessage( &msg ); // Enviem el missatge

//	STI( flags ); !!!!!
	}

