/* **************************************************************************
*                                                                           *
*  TrapGate.CPP                                                             *
*                                                                           *
*  13-07-96                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control de les portes de trampa                            *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\trapgate.h"
#include "errors.h"
#include "kernel\system.h"

// **************************************************************************
// Prepara l'objecte
// Com a entrada ha de rebre:
// pDescr	- Apunta al descriptor de la CallGate
CTrapGate::CTrapGate( PTDescriptor pDescr ) : CGate( pDescr )
	{
	id	= CID_TrapGate;
	}

// **************************************************************************
// Destructor de la classe
CTrapGate::~CTrapGate()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CTrapGate::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_TrapGate )
		return TRUE;
	else
		return CGate::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna el nombre de dobles paraules que pren com a parmetres (no en pren)
BYTE CTrapGate::Params()
	{
	if( binitialized )
		SETERRORCODE( GATE_NOTPERMITTED );
	else
		SETERRORCODE( GATE_UNINITIALIZED );

	return 0;
	}

// **************************************************************************
// Aquest tipus de portes no tenen parmetres
// Com a entrada ha de rebre:
// p	- Nombre de dobles paraules que formen els parmetres (no vlid)
VOID CTrapGate::Params( BYTE )
	{
	if( binitialized )
		SETERRORCODE( GATE_NOTPERMITTED );
	else
		SETERRORCODE( GATE_UNINITIALIZED );
	}

// **************************************************************************
// Prepara el descriptor segons les necessitats de les portes de trampa
// Com a entrada ha de rebre:
// Desc	- Apuntador cap al descriptor
VOID CTrapGate::Descriptor( PTDescriptor pDesc )
	{
	CGate::Descriptor( pDesc );

	SetProcessor();
	SetTrapgate386();
	DPL( 0 );
	Present( TRUE );
	}

