/* **************************************************************************
*                                                                           *
*  MailBox.CPP                                                              *
*                                                                           *
*  03-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control de 'mailboxes'                                     *
*                                                                           *
************************************************************************** */

#include "sys\private\mailbox.h"
#include "kernel\mailbox.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Object  			- Objecte pare de la bstia
// Name    			- Nom de la bstia
CMailBox::CMailBox( PCObject pObject, PSTR sName ) : CResource()
	{
	id = CID_MailBox;
	pobject = new CkeMailBox( (PCkeObject) pObject->GetInternalPointer(), sName );
	}

// **************************************************************************
// Destructor de la classe
CMailBox::~CMailBox()
	{
	delete pobject;
	}

BOOL CMailBox::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_MailBox )
		return TRUE;
	else
		return CResource::ClassCheck( Cuid );
	}

// **************************************************************************
// Envia un missatge a la bstia
// Com a entrada ha de rebre:
// Msg     			- Apuntador al lloc des d'on es copia el missatge
VOID CMailBox::PostMessage( PTMSG pMsg )
	{
	((PCkeMailBox) pobject)->PostMessage( pMsg );
	}

// **************************************************************************
// Comprova si hi ha missatges a la bstia (si no n'hi ha es bloqueja)
// Com a entrada ha de rebre:
// Msg     			- Apuntador al lloc on es guardar el primer missatge
BOOL CMailBox::WaitMessage( PTMSG pMsg )
	{
	return ((PCkeMailBox) pobject)->WaitMessage( pMsg );
	}

// **************************************************************************
// Comprova si hi ha missatges a la bstia (si no n'hi ha NO es bloqueja)
// Com a entrada ha de rebre:
// Msg     			- Apuntador al lloc on es guardar el primer missatge (si n'hi ha)
BOOL CMailBox::PeekMessage( PTMSG pMsg )
	{
	return ((PCkeMailBox) pobject)->PeekMessage( pMsg );
	}

// **************************************************************************
// Retorna el nombre de missatges que estan esperant en la bstia
DWORD CMailBox::WaitingMessages()
	{
	return ((PCkeMailBox) pobject)->WaitingMessages();
	}

