/* **************************************************************************
*                                                                           *
*  Mutex.CPP                                                                *
*                                                                           *
*  03-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a la utilitzaci de 'mutex'                                   *
*                                                                           *
************************************************************************** */

#include "sys\private\mutex.h"
#include "kernel\mutex.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Object  			- Objecte pare del 'mutex'
// Name    			- Nom del 'mutex'
CMutex::CMutex( PCObject pObject, PSTR sName )
	{
	if( pObject )
		pobject = new CkeMutex( (PCkeObject) pObject->GetInternalPointer(), sName );
	else
		pobject = new CkeMutex( NULL, sName );
	}

// **************************************************************************
// Destructor de la classe
CMutex::~CMutex()
	{
	delete pobject;
	}

BOOL CMutex::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Mutex )
		return TRUE;
	else
		return CMutex::ClassCheck( Cuid );
	}

