/* **************************************************************************
*                                                                           *
*  Object.H                                                                 *
*                                                                           *
*  03-02-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica per al control dels recursos i el directori d'objectes   *
*                                                                           *
************************************************************************** */

#include "sys\private\object.h"
#include "kernel\object.h"
#include "string.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Object  			- Objecte del nucli que s representat per aquest objecte del nivell sistema
CObject::CObject( PCkeObject pObject ) : CkeDblListItem( NULL, NULL )
	{
	pobject		= pObject;
	pacl			= NULL;
	pcreator		= NULL; // -BUG
	dwquotecost	= 0;	// -BUG
	}

// **************************************************************************
// Destructor de la classe
CObject::~CObject()
	{
	}

BOOL CObject::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Object )
		return TRUE;
	else
		return CkeDblListItem::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'apuntador a l'objecte intern
PCkeObject CObject::GetInternalPointer()
	{
	return pobject;
	}

// **************************************************************************
// Augmenta el compte d's de l'objecte
PCObject CObject::Enter()
	{
	pobject->Enter();
	return this;
	}

// **************************************************************************
// Disminueix el compte d's de l'objecte
VOID CObject::Leave()
	{
	pobject->Leave();
	}

// **************************************************************************
// Obt el nom de l'objecte
// Com a entrada ha de rebre:
// Name    			- Apuntador cap al 'buffer' on copiem el nom
// Size    			- Nombre mxim de carcters a omplir
VOID CObject::Name( PSTR sName, DWORD dwSize )
	{
	strncpy( sName, pobject->Name(), dwSize );
	}

// **************************************************************************
// Retorna el compte d's de l'objecte
DWORD CObject::UseCount()
	{
	return pobject->UseCount();
	}

// **************************************************************************
// Indica si es tracta o no d'un objecte temporal
BOOL CObject::Temporal()
	{
	return pobject->Temporal();
	}

// **************************************************************************
// Retorna un apuntador cap al flux creador de l'objecte
PCThread CObject::Creator()
	{
	return pcreator;
	}

// **************************************************************************
// Analitza la cadena de carcters que es passa com a parmetre i retorna l'objecte adient
// Com a entrada ha de rebre:
// Name    			- Nom demanat
PCObject CObject::Analysis( PSTR )
	{
	return this;
	}

