/* **************************************************************************
*                                                                           *
*  Resource.CPP                                                             *
*                                                                           *
*  03-02-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica per a tots els recursos                                  *
*                                                                           *
************************************************************************** */

#include "sys\private\resource.h"
#include "kernel\resource.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Object  			- Objecte intern representat per l'objecte de nivell sistema
CResource::CResource( PCkeObject pObject ) : CObject( pObject )
	{
	id = CID_Resource;
	}

// **************************************************************************
// Destructor de la classe
CResource::~CResource()
	{
	}

BOOL CResource::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Resource )
		return TRUE;
	else
		return CResource::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'estat actual del recurs
BYTE CResource::Status()
	{
	return ((PCkeResource) pobject)->Status();
	}

// **************************************************************************
// Canvia l'estat del recurs
// Com a entrada ha de rebre:
// Status  			- Nou estat
VOID CResource::Status( BYTE cStatus )
	{
	((PCkeResource) pobject)->Status( cStatus );
	}

// **************************************************************************
// Allibera el recurs
VOID CResource::Release()
	{
	((PCkeResource) pobject)->Release();
	}

// **************************************************************************
// Espera al recurs
VOID CResource::Wait()
	{
	((PCkeResource) pobject)->Wait();
	}

