/* **************************************************************************
*                                                                           *
*  Sem.CPP                                                                  *
*                                                                           *
*  03-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a la gesti de semfors                                       *
*                                                                           *
************************************************************************** */

#include "sys\private\sem.h"
#include "kernel\sem.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Value   			- Valor inicial del semfor
// Object  			- Pare del semfor
// Name    			- Nom del semfor
CSemaphore::CSemaphore( LONG lValue, PCObject pObject, PSTR sName ) : CResource()
	{
	id = CID_Semaphore;
	if( pObject )
		pobject = new CkeSemaphore( lValue, (PCkeObject) pObject->GetInternalPointer(), sName );
	else
		pobject = new CkeSemaphore( lValue, NULL, sName );
	}

// **************************************************************************
// Destructor de la classe
CSemaphore::~CSemaphore()
	{
	delete pobject;
	}

BOOL CSemaphore::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Semaphore )
		return TRUE;
	else
		return CResource::ClassCheck( Cuid );
	}

