/* **************************************************************************
*                                                                           *
*  User.CPP                                                                 *
*                                                                           *
*  28-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe de seguretat per a cada usuari individual                         *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\private\user.h"
#include "string.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Name    			- Nom de l'usuari
// Password			- Clau de pas de l'usuari
// LongName			- Descripci de l'usuari
// Group   			- Grup al qual pertany l'usuari
// MaximumQuote	- Valor de la quota
// Privileges		- Privilegis otorgats a l'usuari
// NotPrivileges 	- Privilegis denegats a l'usuari
CUser::CUser( PSTR sName, PSTR sPassword, PSTR sLongName, PCGroup pGroup, DWORD dwMaximumQuote, DWORD dwPrivileges, DWORD dwNotPrivileges ) : CAccessToken( sName, sLongName, dwPrivileges, dwNotPrivileges )
	{
	pgroup = pGroup;
	dwquote = dwMaximumQuote;
	sprintf( spassword, TEXT( "%s" ), sPassword );
	}

// **************************************************************************
// Destructor de la classe
CUser::~CUser()
	{
	}

BOOL CUser::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_User )
		return TRUE;
	else
		return CAccessToken::ClassCheck( Cuid );
	}

// **************************************************************************
// Comprova si el 'password' s correcte
// Com a entrada ha de rebre:
// Password			- Clau que es vol comprovar
BOOL CUser::CheckPassword( PSTR )
	{
	return TRUE;
	}

// **************************************************************************
// Canvia la clau de pas de l'usuari
// Com a entrada ha de rebre:
// OldPassword		- 'Password' antic (per comprovaci)
// NewPassword		- Nou 'password'
VOID CUser::NewPassword( PSTR, PSTR )
	{
	}

// **************************************************************************
// Consulta el grup al qual pertany l'usuari
PCGroup CUser::Group()
	{
	return pgroup;
	}

// **************************************************************************
// Canvia el grup al qual pertany l'usuari
// Com a entrada ha de rebre:
// Group   			- Nou grup
VOID CUser::Group( PCGroup pGroup )
	{
	pgroup = pGroup;
	}

// **************************************************************************
// Modifica el valor de la quota
// Com a entrada ha de rebre:
// Value   			- Increment de la quota
VOID CUser::Quote( LONG lValue )
	{
	dwquote += lValue;
	}

// **************************************************************************
// Retorna el valor de la quota actual
DWORD CUser::Quote()
	{
	return dwquote;
	}

