/* **************************************************************************
*                                                                           *
*  AcToken.CPP                                                              *
*                                                                           *
*  30-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica de seguretat per a usuaris i grups                       *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\actoken.h"
#include "string.h"
#include "sys\mailbox.h"
#include "sys\asm.h"
#include "sys\sys.h"

CsysAccessToken::CsysAccessToken( PVOID pAccessToken ) : CsysType( CID_AccessToken )
	{
	paccesstoken = pAccessToken;
	}

CsysAccessToken::~CsysAccessToken()
	{
	}

BOOL CsysAccessToken::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_AccessToken )
		return TRUE;
	else
		return CsysType::ClassCheck( Cuid );
	}

PVOID CsysAccessToken::GetInternalPointer()
	{
	return paccesstoken;
	}

VOID CsysAccessToken::LongName( PSTR sLongName, DWORD dwMaxSize )
	{
	PCsysMailBox box = new CsysMailBox();

	TData data;
	data.dwParam1 = (DWORD) sLongName;
	data.dwParam2 = dwMaxSize;

	TMSG msg;

	msg.dwMessage	= SYS_GETLONGNAME_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysAccessToken::Name( PSTR sName, DWORD dwMaxSize )
	{
	PCsysMailBox box = new CsysMailBox();

	TData data;
	data.dwParam1 = (DWORD) sName;
	data.dwParam2 = dwMaxSize;

	TMSG msg;

	msg.dwMessage	= SYS_GETNAME_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

BOOL CsysAccessToken::None()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETNONE_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CsysAccessToken::LockMemory()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETLOCKMEMORY_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CsysAccessToken::IncreaseQuota()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETINCREASEQUOTA_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CsysAccessToken::LoadDriver()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETLOADDRIVER_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CsysAccessToken::Systemtime()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETSYSTEMTIME_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CsysAccessToken::IncreaseBasePriority()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETINCREASEBASEPRIORITY_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CsysAccessToken::CreatePageFile()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETCREATEPAGEFILE_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CsysAccessToken::Backup()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETBACKUP_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CsysAccessToken::Restore()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETRESTORE_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CsysAccessToken::Shutdown()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETSHUTDOWN_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CsysAccessToken::Debug()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETDEBUG_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CsysAccessToken::Audit()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETAUDIT_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

VOID CsysAccessToken::LongName( PSTR sLongName )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETLONGNAME_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) sLongName;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysAccessToken::Name( PSTR sName )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETNAME_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) sName;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysAccessToken::None( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETNONE_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysAccessToken::LockMemory( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETLOCKMEMORY_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysAccessToken::IncreaseQuota( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETINCREASEQUOTA_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysAccessToken::LoadDriver( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETLOADDRIVER_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysAccessToken::Systemtime( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETSYSTEMTIME_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysAccessToken::IncreaseBasePriority( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETINCREASEBASEPRIORITY_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysAccessToken::CreatePageFile( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETCREATEPAGEFILE_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysAccessToken::Backup( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETBACKUP_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysAccessToken::Restore( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETRESTORE_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysAccessToken::Shutdown( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETSHUTDOWN_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysAccessToken::Debug( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETDEBUG_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysAccessToken::Audit( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETAUDIT_TOKEN;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

