/* **************************************************************************
*                                                                           *
*  Debug.CPP                                                                *
*                                                                           *
*  30-01-97                                                    BUILD:0003   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a ajudar a la depuraci del sistema i dels programes          *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\debug.h"
#include "errors.h"
#include "sys\mailbox.h"
#include "sys\asm.h"
#include "sys\sys.h"

// **************************************************************************
// Prepara l'objecte
CsysDebug::CsysDebug() : CsysType( CID_Debug )
	{
	}

// **************************************************************************
// Destructor de l'objecte
CsysDebug::~CsysDebug()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CsysDebug::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Debug )
		return TRUE;
	else
		return CsysType::ClassCheck( Cuid );
	}

// **************************************************************************
// Realitza la comprovaci de tipus en temps d'execuci
// Com a entrada ha de rebre:
// Type     	- Objecte sobre el qual es fa la comprovaci
// id       	- Identificador esperat
// Error    	- Cadena de caracters que s'ha d'enviar en cas d'error
VOID CsysDebug::CheckPanic( PCsysType pType, CUID id, PSTR sError )
	{
	if( pType->ClassID() != id )
		Trace( sError );
// Hauria d'aturar l'execuci? -BUG
	}

// **************************************************************************
// Realitza la funcio de traa
// Com a entrada ha de rebre:
// str      	- Cadena de caracters que s'ha d'enviar
VOID CsysDebug::Trace( PSTR str )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_TRACE_DEBUG;
	msg.dwParam1	= (DWORD) str;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysDebug::MemoryDump( PBYTE pAddress, DWORD dwSize )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_MEMORYDUMP_DEBUG;
	msg.dwParam1	= (DWORD) pAddress;
	msg.dwParam2	= dwSize;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

