/* **************************************************************************
*                                                                           *
*  MailBox.CPP                                                              *
*                                                                           *
*  29-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control de 'mailboxes'                                     *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\mailbox.h"
#include "sys\asm.h"
#include "string.h"

CsysMailBox::CsysMailBox( PCsysObject pParent, PSTR sName ) : CsysResource()
	{
	id = CID_MailBox;

	if( pParent )
		pobject = ::CreateMailBox( sName, pParent->GetInternalPointer() );
	else
		pobject = ::CreateMailBox( sName, NULL );
	}

CsysMailBox::CsysMailBox( PVOID pParent, PSTR sName ) : CsysResource()
	{
	id = CID_MailBox;

	pobject = ::CreateMailBox( sName, pParent );
	}

CsysMailBox::~CsysMailBox()
	{
	::DestroyMailBox( pobject );
	}

BOOL CsysMailBox::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_MailBox )
		return TRUE;
	else
		return CsysResource::ClassCheck( Cuid );
	}

VOID CsysMailBox::PostMessage( PTMSG pMessage )
	{
/*
	PWORD pant = (PWORD) 0xb8000;
	PSTR str = TEXT( "CsysMailBox::PostMessage entra " );
	DWORD x = 0;
	while( str[ x ] )
		{
		pant[ x ] = (WORD)(str[ x ] | 0x700);
		x++;
		}
	for( DWORD a = 0; a < 0x4000000; a++ );
*/
	::PostMessage( pobject, pMessage );
/*
	PSTR str2 = TEXT( "CsysMailBox::PostMessage surt " );
	x = 0;
	while( str2[ x ] )
		{
		pant[ x+80 ] = (WORD)(str2[ x ] | 0x700);
		x++;
		}
	for( DWORD a = 0; a < 0x4000000; a++ );
*/
	}

BOOL CsysMailBox::WaitMessage( PTMSG pMessage )
	{
/*
	PWORD pant = (PWORD) 0xb8000;
	CHAR str[ 80 ];
	sprintf( str, TEXT( "MailBox - %08x" ), pobject );
	DWORD x = 0;
	while( str[ x ] )
		{
		pant[ x ] = (WORD)(str[ x ] | 0x700);
		x++;
		}
	for( DWORD a = 0; a < 0x4000000; a++ );
*/
	return ::WaitMessage( pobject, pMessage );
/*
	PSTR str2 = TEXT( "CsysMailBox::WaitMessage surt " );
	x = 0;
	while( str2[ x ] )
		{
		pant[ x+80 ] = (WORD)(str2[ x ] | 0x700);
		x++;
		}
	for( DWORD a = 0; a < 0x4000000; a++ );
	return FALSE;
*/
	}

BOOL CsysMailBox::PeekMessage( PTMSG pMessage )
	{
	return ::PeekMessage( pobject, pMessage );
	}

DWORD CsysMailBox::WaitingMessages()
	{
	return ::WaitingMessages( pobject );
	}

