/* **************************************************************************
*                                                                           *
*  Rights.CPP                                                               *
*                                                                           *
*  29-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica per als drets adquirits i la llista de control d'accs   *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\rights.h"
#include "sys\mailbox.h"
#include "sys\asm.h"
#include "sys\sys.h"

CsysRights::CsysRights( PVOID pRights ) : CsysType( CID_Rights )
	{
	prights = pRights;
	}

CsysRights::~CsysRights()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CsysRights::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Rights )
		return TRUE;
	else
		return CsysType::ClassCheck( Cuid );
	}

BOOL CsysRights::Read()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETREAD_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CsysRights::Write()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETWRITE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CsysRights::Execute()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETEXECUTE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CsysRights::Delete()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETDELETE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CsysRights::Syncronize()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETSYNCRONIZE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CsysRights::ModifyRights()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETMODIFYRIGHTS_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CsysRights::ModifyState()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETMODIFYSTATE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

VOID CsysRights::Read( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETREAD_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysRights::Write( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETWRITE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysRights::Execute( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETEXECUTE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysRights::Delete( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETDELETE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysRights::Syncronize( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETSYNCRONIZE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysRights::ModifyRights( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETMODIFYRIGHTS_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysRights::ModifyState( BOOL bState )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETMODIFYSTATE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

