/* **************************************************************************
*                                                                           *
*  Security.CPP                                                             *
*                                                                           *
*  29-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe que implementa les llistes de control d'accs (ACL)               *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\security.h"
#include "sys\mailbox.h"
#include "sys\asm.h"
#include "sys\sys.h"

CsysSecurityItem::CsysSecurityItem( PVOID pItem ) : CsysDblListItem( NULL, NULL ), CsysRights( pItem )
	{
	id = CID_SecurityItem;
	}

CsysSecurityItem::~CsysSecurityItem()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CsysSecurityItem::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_SecurityItem )
		return TRUE;
	else
		return CsysDblListItem::ClassCheck( Cuid ) | CsysRights::ClassCheck( Cuid );
	}

BYTE CsysSecurityItem::Type()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETTYPE_ACL;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

