/* **************************************************************************
*                                                                           *
*  SymLink.CPP                                                              *
*                                                                           *
*  03-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control dels enllaos simblics en el directori d'objectes               *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\symlink.h"
#include "errors.h"
#include "sys\sys.h"
#include "sys\asm.h"
#include "sys\mailbox.h"

// **************************************************************************
// Constructor de la classe
CsysSymbolicLink::CsysSymbolicLink( PVOID pParent, PSTR sName ) : CsysObject()
	{
	id = CID_SymbolicLink;

	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_SYMBOLICLINK;
	msg.dwParam1	= (DWORD) pParent;
	msg.dwParam2	= (DWORD) sName;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	pobject = (PVOID) msg.dwParam1;
	}

CsysSymbolicLink::CsysSymbolicLink( PCsysObject pParent, PSTR sName ) : CsysObject()
	{
	id = CID_SymbolicLink;

	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_SYMBOLICLINK;
	msg.dwParam1	= (DWORD) pParent->GetInternalPointer();
	msg.dwParam2	= (DWORD) sName;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	pobject = (PVOID) msg.dwParam1;
	}

// **************************************************************************
// Destructor de la classe
CsysSymbolicLink::~CsysSymbolicLink()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_SYMBOLICLINK;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CsysSymbolicLink::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_SymbolicLink )
		return TRUE;
	else
		return CsysObject::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna el nom al que fa referencia l'enlla
VOID CsysSymbolicLink::NewName( PSTR sName, DWORD dwMaxSize )
	{
	PCsysMailBox box = new CsysMailBox();

	TData data;
	data.dwParam1	= (DWORD) sName;
	data.dwParam2	= dwMaxSize;

	TMSG msg;

	msg.dwMessage	= SYS_GETNAME_SYMBOLICLINK;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

// **************************************************************************
// Modifica el nom al que fa referencia l'enlla
// Com a entrada ha de rebre:
// sNewName   	- Nou nom
VOID CsysSymbolicLink::NewName( PSTR sNewName )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETNAME_SYMBOLICLINK;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) sNewName;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

