/* **************************************************************************
*                                                                           *
*  Thread.CPP                                                               *
*                                                                           *
*  03-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a la gesti dels fluxos                                       *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\thread.h"
#include "sys\sys.h"
#include "sys\asm.h"
#include "sys\mailbox.h"

CsysThread::CsysThread( PVOID pObject ) : CsysResource( pObject )
	{
	id = CID_Thread;
	}

CsysThread::~CsysThread()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CsysThread::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Thread )
		return TRUE;
	else
		return CsysResource::ClassCheck( Cuid );
	}

DWORD CsysThread::ErrorCode()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETERRORCODE_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

DWORD CsysThread::KernelTime()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETKERNELTIME_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

DWORD CsysThread::UserTime()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETUSERTIME_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

VOID CsysThread::ErrorCode( DWORD dwCode )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETERRORCODE_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= dwCode;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

PCsysThread CsysThread::NextInProc()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETNEXTINPROCESS_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return new CsysThread( (PVOID) msg.dwParam1 );
	}

PCsysThread CsysThread::NextInAll()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETNEXTINALL_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return new CsysThread( (PVOID) msg.dwParam1 );
	}

BYTE CsysThread::Priority()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETPRIORITY_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

VOID CsysThread::Priority( BYTE cPriority )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETPRIORITY_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) cPriority;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

PCsysProcess CsysThread::Process()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETPROCESS_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return new CsysProcess( (PVOID) msg.dwParam1 );
	}

DWORD CsysThread::CreationTime()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETCREATIONTIME_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

DWORD CsysThread::ExitStatus()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETEXITSTATUS_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

VOID CsysThread::Exit( DWORD dwCode )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETEXITSTATUS_THREAD;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= dwCode;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

