/* **************************************************************************
*                                                                           *
*  Timer.CPP                                                                *
*                                                                           *
*  06-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a la utilitzaci d'alarmes                                    *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\timer.h"
#include "sys\mailbox.h"
#include "sys\asm.h"
#include "sys\sys.h"

CsysTimer::CsysTimer( LONG lTimeout, PCsysMailBox pMailBox, PCsysObject pParent, PSTR sName ) : CsysCallback( NULL, NULL, NULL )
	{
	id = CID_Timer;

	PCsysMailBox box = new CsysMailBox();

	TData data;
	data.dwParam1	= (DWORD) sName;
	data.dwParam2	= (DWORD) pMailBox;
	data.dwParam3	= (DWORD) lTimeout;

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_TIMER;
	msg.dwParam1	= (DWORD) pParent;
	msg.dwParam2	= (DWORD) &data;

	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	pobject = (PVOID) msg.dwParam1;
	}

CsysTimer::~CsysTimer()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_DESTROY_TIMER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CsysTimer::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Timer )
		return TRUE;
	else
		return CsysCallback::ClassCheck( Cuid );
	}

VOID CsysTimer::Time( LONG lTimeout )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETTIME_TIMER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) lTimeout;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

LONG CsysTimer::Time()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETTIME_TIMER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (LONG) msg.dwParam1;
	}

