/* **************************************************************************
*                                                                           *
*  User.CPP                                                                 *
*                                                                           *
*  29-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe de seguretat per a cada usuari individual                         *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\user.h"
#include "string.h"
#include "sys\mailbox.h"
#include "sys\asm.h"
#include "sys\sys.h"

CsysUser::CsysUser( PVOID pUser ) : CsysAccessToken( pUser )
	{
	}

CsysUser::~CsysUser()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CsysUser::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_User )
		return TRUE;
	else
		return CsysAccessToken::ClassCheck( Cuid );
	}

BOOL CsysUser::CheckPassword( PSTR sPassword )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_CHECKPASSWORD_USER;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) sPassword;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

VOID CsysUser::NewPassword( PSTR sOldPassword, PSTR sNewPassword )
	{
	PCsysMailBox box = new CsysMailBox();

	TData data;
	data.dwParam1 = (DWORD) sOldPassword;
	data.dwParam2 = (DWORD) sNewPassword;

	TMSG msg;

	msg.dwMessage	= SYS_SETPASSWORD_USER;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

PCsysGroup CsysUser::Group()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETGROUP_USER;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (PCsysGroup) msg.dwParam1;
	}

VOID CsysUser::Group( PCsysGroup pGroup )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETGROUP_USER;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) pGroup->GetInternalPointer();
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CsysUser::Quote( LONG lValue )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETQUOTE_USER;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= lValue;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

DWORD CsysUser::Quote()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETQUOTE_USER;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

