/* **************************************************************************
*                                                                           *
*  Sys.CPP                                                                  *
*                                                                           *
*  29-04-97                                                    BUILD:0011   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ pconsentiment per escrit de l'autor.        *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Nivell 'System' de l'Eros ver 1.00                                       *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\sys.h"
#include "errors.h"
#include "kernel\kernel.h"
#include "kernel\system.h"
#include "string.h"
#include "kernel\mailbox.h"
#include "sys\private\user.h"
#include "sys\private\security.h"
#include "sys\private\callback.h"
#include "sys\private\mailbox.h"
#include "sys\private\thread.h"
#include "sys\private\mutex.h"
#include "sys\private\objdir.h"
#include "sys\private\sem.h"
#include "sys\private\timer.h"
#include "common.h"
#include "messages.h"
#include "sys\driver.h"
#include "drivers\block\blockdev.h"
#include "drivers\char\video.h"
#include "drivers\char\keyb.h"
#include "drivers\messages.h"
#include "kernel\mem.h"
#include "drivers\fs\fs.h"
#include "drivers\fs\fub.h"
#include "kernel\symlink.h"
#include "sys\private\exe.h"
#include "sys\private\section.h"
#include "lang.h"

// *********************************** DEFINES
#ifdef _DEBUG
#define _VER					TEXT( "0.01" )
#else
#define _VER					TEXT( "1.00" )
#endif

#define _BUILD					16

// Aquests sn els valors que utilitzem per als controladors de dispositius
#define SYS_HEAPRESERVE		0x00080000	/* 512KB. */
#define SYS_HEAPCOMMIT		0x00010000	/*  64KB. */
#define SYS_STACKRESERVE	0x00003000	/*  12KB. */
#define SYS_STACKCOMMIT		0x00002000  /*   8KB. */

// *********************************** GLOBALS
extern PCkeKernel _import Kernel;
extern PCkeSystem _import System;
PCdrvVideo pvideo = NULL;						// Pantalla virtual de depuraci
CHAR sComputerName[ MAX_COMPUTERNAME ];	// Nom de l'ordinador
PTDriver pLoadedDrivers = NULL;				// Llista dels controladors carregats
DWORD dwloadeddrivers = 0;						// Quantitat de controladors carregats
volatile DWORD dwinitdrivers = 0;			// Quantitat de controladors iniciats
volatile DWORD dwshutdowncount = 0;			// Quantitat de programes que han de realitzar el 'shutdown'
PCkeThread pinit = NULL;						// Flux inicialitzador/executor
PCkeMailBox pinitmb = NULL;					// Bstia de l'inicialitzador -BUG
PCkeMailBox prepmb = NULL;						// Bstia de l'executor -BUG

// *********************************** DECLARACIONS
DWORD _import CLI();
VOID _import STI( DWORD );
VOID Init();
VOID Info( PCdrvVideo );
BOOL DispatchMessage( TMSG& );
VOID Transform( DWORD, BYTE&, BYTE&, BYTE& );
VOID Prepare();
VOID Thread2();
VOID Thread3();
VOID Thread4();
PSTR GetFilename( PSTR );
BOOL Exec( PSTR );
VOID RegisterShutdownNotification( PCkeCallback pCallback );
VOID UnregisterShutdownNotification( PCkeCallback pCallback );
VOID Shutdown();

// *********************************** FUNCIONS
void main()
	{
	CHAR str[ 80 ];
	sprintf( str, TEXT( "System Module ver %s (Build %3u) Date: %s\r\n" ), _VER, _BUILD, TEXT( __DATE__ ) );
	(System->Console())->OutText( str );

	sprintf( sComputerName, TEXT( "DEFAULT" ) ); // Donem un nom a l'ordinador

	// Preparem la bstia del sistema
	PCkeMailBox box = new CkeMailBox( System->FindObject( MAILBOX_DIR ), nSYS_MAILBOX );

	Init(); // Creem els processos dels controladors de dispositiu

	TMSG msg;

	while( 1 )
		{
		box->WaitMessage( &msg );
		DispatchMessage( msg ); // Tractem els missatges que ens arriben
		}
	}

// **************************************************************************
// Tracta el missatge que se li passa com a parmetre
// Com a entrada ha de rebre:
// msg     		- Missatge que s'ha de tractar
BOOL DispatchMessage( TMSG &msg )
	{
	CHAR str[ 100 ];

	if( msg.pReply ) // Hem de mapejar el flux que ens fa la petici
		Kernel->MapThreadSpace( ((PCkeMailBox) msg.pReply)->Creator() );

	switch( msg.dwMessage )
		{
		case SYS_GETCOMPUTERNAME_MOD:
			{ // Copiem el nom de l'ordinador en la zona indicada en el parmetre
			strncpy( (PSTR) msg.dwParam1, sComputerName, (msg.dwParam2 < MAX_COMPUTERNAME ? msg.dwParam2 : MAX_COMPUTERNAME) );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_REGISTERDRIVER_MOD:
			{ // Cada controlador es registra
			((PTDriver) msg.dwParam1)->pnext = pLoadedDrivers; // Afegim el controlador a la llista
			if( pLoadedDrivers )
				pLoadedDrivers->pprev = (PTDriver) msg.dwParam1;
			pLoadedDrivers = (PTDriver) msg.dwParam1;
			dwinitdrivers++; // Un controlador preparat ms

			if( dwinitdrivers == dwloadeddrivers ) // preparats = carregats -> Generem el flux que retorna el missatge
				pinit = new CkeThread( (DWORD) Prepare, SYS_STACKRESERVE, SYS_STACKCOMMIT, (System->Running())->Process(), NULL );
			}
			break;

		case SYS_UNREGISTERDRIVER_MOD:
			{ // Quan un controlador surt de memria, s'ha de desregistrar
			sprintf( str, TEXT( "Rebut UnregisterDriver (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			// NO IMPLEMENTAT
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETTIME_MOD:
			{ // Obtenir l'hora
			TAAL_TIME time;
			time = (System->AAL())->Time();
			msg.dwParam1 = time.dwAll;
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETDATE_MOD:
			{ // Obtenir la data
			TAAL_DATE date;
			date = (System->AAL())->Date();
			msg.dwParam1 = date.dwAll;
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETTIME_MOD:
			{ // Posar l'hora
			sprintf( str, TEXT( "Rebut SetTime (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			TAAL_TIME time;
			time.dwAll = msg.dwParam1;
			(System->AAL())->Time( time );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETDATE_MOD:
			{ // Posar la data
			sprintf( str, TEXT( "Rebut SetDate (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			TAAL_DATE date;
			date.dwAll = msg.dwParam1;
			(System->AAL())->Date( date );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_REGISTERSHUTDOWN_MOD:
			{ // Registrar una funci que ser cridada abans d'aturar el sistema
			sprintf( str, TEXT( "Rebut RegisterShutdown (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
//			Kernel->RegisterShutdownNotification( (PCkeCallback) msg.dwParam1 );
			RegisterShutdownNotification( (PCkeCallback) msg.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_UNREGISTERSHUTDOWN_MOD:
			{ // Desregistrar una funci
			sprintf( str, TEXT( "Rebut UnregisterShutdown (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
//			Kernel->UnregisterShutdownNotification( (PCkeCallback) msg.dwParam1 );
			UnregisterShutdownNotification( (PCkeCallback) msg.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SHUTDOWN_MOD:
			{ // Aturar el sistema
			if( prepmb ) // Hem d'estar preparats per fer-ho
				{
				TMSG pass;

				pass.dwMessage = SYS_SHUTDOWN_MOD;
				pass.dwParam1 = 0;
				pass.dwParam2 = NULL;
				pass.pReply = msg.pReply;

				// Passem el missatge al flux executor
				prepmb->PostMessage( &pass );
				}
			}
			break;

		case SYS_MEMCOPY_MOD:
			{ // Copiar una zona de memria
			PTData data = (PTData) msg.dwParam1;
			Kernel->MemCopy( (PBYTE) data->dwParam1, (PBYTE) data->dwParam2, data->dwParam3 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_MEMMOVE_MOD:
			{ // Copiar una zona de memria tenint en compte el solapament
			sprintf( str, TEXT( "Rebut MemMove (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			PTData data = (PTData) msg.dwParam1;
			Kernel->MemMove( (PBYTE) data->dwParam1, (PBYTE) data->dwParam2, data->dwParam3 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_MEMSET_MOD:
			{ // Preparar una zona de memria segons el valor passat com a parmetre
			PTData data = (PTData) msg.dwParam1;
			Kernel->MemSet( (PBYTE) data->dwParam1, data->dwParam2, (BYTE) data->dwParam3 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_MEMCOMPARE_MOD:
			{ // Comparar dues zones de memria
			sprintf( str, TEXT( "Rebut MemCompare (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			PTData data = (PTData) msg.dwParam1;
			Kernel->MemCompare( (PBYTE) data->dwParam1, (PBYTE) data->dwParam2, data->dwParam3 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_EXEC_MOD:
			{ // Executar un fitxer
			if( prepmb ) // Hem d'estar preparats per fer-ho
				{
				TMSG pass;

				PSTR sname = (PSTR) msg.dwParam1;
				pass.dwMessage = SYS_EXEC_MOD;
				pass.dwParam1 = (DWORD) malloc( strlen( sname ) + 1 );
				pass.dwParam2 = NULL;
				pass.pReply = msg.pReply;

				strcpy( (PSTR) pass.dwParam1, sname );
				// Passem el missatge al flux executor
				prepmb->PostMessage( &pass );
				}
			}
			break;

		case SYS_DRIVERREADY: // Controlador preparat per a rebre peticions
			pinitmb->PostMessage( &msg ); // No t retorn, el missatge s assncron
			break;

		// Funcions sobre 'AccessToken'
		case SYS_GETLONGNAME_TOKEN:
			{
			sprintf( str, TEXT( "Rebut GetLongName (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			PTData data = (PTData) msg.dwParam2;
			strncpy( (PSTR) data->dwParam1, ((PCAccessToken) msg.dwParam1)->LongName(), (data->dwParam2 < MAX_LONG_NAME ? data->dwParam2 : MAX_LONG_NAME) );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETNAME_TOKEN:
			{
			sprintf( str, TEXT( "Rebut GetName (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			PTData data = (PTData) msg.dwParam2;
			strncpy( (PSTR) data->dwParam1, ((PCAccessToken) msg.dwParam1)->Name(), (data->dwParam2 < MAX_LONG_NAME ? data->dwParam2 : MAX_CALL_NAME) );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETNONE_TOKEN:
			{
			sprintf( str, TEXT( "Rebut GetNone (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCAccessToken) msg.dwParam1)->None();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETLOCKMEMORY_TOKEN:
			{
			sprintf( str, TEXT( "Rebut GetLockMemory (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCAccessToken) msg.dwParam1)->LockMemory();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETINCREASEQUOTA_TOKEN:
			{
			sprintf( str, TEXT( "Rebut GetIncreaseQuota (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCAccessToken) msg.dwParam1)->IncreaseQuota();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETLOADDRIVER_TOKEN:
			{
			sprintf( str, TEXT( "Rebut GetLoadDriver (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCAccessToken) msg.dwParam1)->LoadDriver();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETSYSTEMTIME_TOKEN:
			{
			sprintf( str, TEXT( "Rebut GetSystemTime (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCAccessToken) msg.dwParam1)->SystemTime();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETINCREASEBASEPRIORITY_TOKEN:
			{
			sprintf( str, TEXT( "Rebut GetIncreaseBasePriority (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCAccessToken) msg.dwParam1)->IncreaseBasePriority();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETCREATEPAGEFILE_TOKEN:
			{
			sprintf( str, TEXT( "Rebut GetCreatePageFile (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCAccessToken) msg.dwParam1)->CreatePageFile();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETBACKUP_TOKEN:
			{
			sprintf( str, TEXT( "Rebut GetBackup (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCAccessToken) msg.dwParam1)->Backup();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETRESTORE_TOKEN:
			{
			sprintf( str, TEXT( "Rebut GetRestore (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCAccessToken) msg.dwParam1)->Restore();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETSHUTDOWN_TOKEN:
			{
			sprintf( str, TEXT( "Rebut GetShutdown (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCAccessToken) msg.dwParam1)->Shutdown();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETDEBUG_TOKEN:
			{
			sprintf( str, TEXT( "Rebut GetDebug (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCAccessToken) msg.dwParam1)->Debug();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETAUDIT_TOKEN:
			{
			sprintf( str, TEXT( "Rebut GetAudit (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCAccessToken) msg.dwParam1)->Audit();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETLONGNAME_TOKEN:
			{
			sprintf( str, TEXT( "Rebut SetLongName (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCAccessToken) msg.dwParam1)->LongName( (PSTR) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETNAME_TOKEN:
			{
			sprintf( str, TEXT( "Rebut SetName (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCAccessToken) msg.dwParam1)->Name( (PSTR) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETNONE_TOKEN:
			{
			sprintf( str, TEXT( "Rebut SetNone (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCAccessToken) msg.dwParam1)->None( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETLOCKMEMORY_TOKEN:
			{
			sprintf( str, TEXT( "Rebut SetLockMemory (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCAccessToken) msg.dwParam1)->LockMemory( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETINCREASEQUOTA_TOKEN:
			{
			sprintf( str, TEXT( "Rebut SetIncreaseQuota (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCAccessToken) msg.dwParam1)->IncreaseQuota( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETLOADDRIVER_TOKEN:
			{
			sprintf( str, TEXT( "Rebut SetLoadDriver (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCAccessToken) msg.dwParam1)->LoadDriver( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETSYSTEMTIME_TOKEN:
			{
			sprintf( str, TEXT( "Rebut SetSystemTime (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCAccessToken) msg.dwParam1)->SystemTime( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETINCREASEBASEPRIORITY_TOKEN:
			{
			sprintf( str, TEXT( "Rebut SetIncreaseBasePriority (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCAccessToken) msg.dwParam1)->IncreaseBasePriority( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETCREATEPAGEFILE_TOKEN:
			{
			sprintf( str, TEXT( "Rebut SetCreatePageFile (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCAccessToken) msg.dwParam1)->CreatePageFile( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETBACKUP_TOKEN:
			{
			sprintf( str, TEXT( "Rebut SetBackup (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCAccessToken) msg.dwParam1)->Backup( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETRESTORE_TOKEN:
			{
			sprintf( str, TEXT( "Rebut SetRestore (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCAccessToken) msg.dwParam1)->Restore( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETSHUTDOWN_TOKEN:
			{
			sprintf( str, TEXT( "Rebut SetShutdown (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCAccessToken) msg.dwParam1)->Shutdown( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETDEBUG_TOKEN:
			{
			sprintf( str, TEXT( "Rebut SetDebug (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCAccessToken) msg.dwParam1)->Debug( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETAUDIT_TOKEN:
			{
			sprintf( str, TEXT( "Rebut SetAudit (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCAccessToken) msg.dwParam1)->Audit( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		// Funcions sobre 'Rights'
		case SYS_GETREAD_RIGHTS:
			{
			sprintf( str, TEXT( "Rebut GetRead (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCRights) msg.dwParam1)->Read();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETWRITE_RIGHTS:
			{
			sprintf( str, TEXT( "Rebut GetWrite (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCRights) msg.dwParam1)->Write();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETEXECUTE_RIGHTS:
			{
			sprintf( str, TEXT( "Rebut GetExecute (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCRights) msg.dwParam1)->Execute();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETDELETE_RIGHTS:
			{
			sprintf( str, TEXT( "Rebut GetDelete (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCRights) msg.dwParam1)->Delete();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETSYNCRONIZE_RIGHTS:
			{
			sprintf( str, TEXT( "Rebut GetSyncronize (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCRights) msg.dwParam1)->Syncronize();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETMODIFYRIGHTS_RIGHTS:
			{
			sprintf( str, TEXT( "Rebut GetModifyRights (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCRights) msg.dwParam1)->ModifyRights();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETMODIFYSTATE_RIGHTS:
			{
			sprintf( str, TEXT( "Rebut GetModifyState (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCRights) msg.dwParam1)->ModifyState();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;
/*
		case SYS_SETREAD_RIGHTS:
			{
			sprintf( str, TEXT( "Rebut SetRead (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCRights) msg.dwParam1)->Read( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETWRITE_RIGHTS:
			{
			sprintf( str, TEXT( "Rebut SetWrite (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCRights) msg.dwParam1)->Write( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETEXECUTE_RIGHTS:
			{
			sprintf( str, TEXT( "Rebut SetExecute (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCRights) msg.dwParam1)->Execute( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETDELETE_RIGHTS:
			{
			sprintf( str, TEXT( "Rebut SetDelete (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCRights) msg.dwParam1)->Delete( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETSYNCRONIZE_RIGHTS:
			{
			sprintf( str, TEXT( "Rebut SetSyncronize (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCRights) msg.dwParam1)->Syncronize( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETMODIFYRIGHTS_RIGHTS:
			{
			sprintf( str, TEXT( "Rebut SetModifyRights (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCRights) msg.dwParam1)->ModifyRights( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETMODIFYSTATE_RIGHTS:
			{
			sprintf( str, TEXT( "Rebut SetModifyState (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCRights) msg.dwParam1)->ModifyState( (BOOL) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;
*/
		// Funcions sobre 'Section' -BUG
		case SYS_GETNAME_SECTION:
			break;

		case SYS_GETVIRTUALSIZE_SECTION:
			break;

		case SYS_GETVIRTUALADDRESS_SECTION:
			break;

		case SYS_GETSIZEOFRAWDATA_SECTION:
			break;

		case SYS_GETPOINTERTORAWDATA_SECTION:
			break;

		case SYS_GETCHARACTERISTICS_SECTION:
			break;

		// Funcions sobre 'SecurityItem'
		case SYS_CREATE_ACL:
			{
			sprintf( str, TEXT( "Rebut CreateSecurityItem (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			PTData data = (PTData) msg.dwParam2;
			msg.dwParam1 = (DWORD) new CSecurityItem( data->dwParam1, (BYTE) data->dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_DESTROY_ACL:
			{
			sprintf( str, TEXT( "Rebut DestroySecurityItem (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			delete( (PCSecurityItem) msg.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETTYPE_ACL:
			{
			sprintf( str, TEXT( "Rebut GetType (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCSecurityItem) msg.dwParam1)->Type();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		// Funcions sobre 'User'
		case SYS_CREATE_USER:
			{
			sprintf( str, TEXT( "Rebut CreateUser (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
//			PTData data = (PTData) msg.dwParam2;
//			msg.dwParam1 = new PCUser( data.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_DESTROY_USER:
			{
			sprintf( str, TEXT( "Rebut DestroyUser (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			delete( (PCUser) msg.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETGROUP_USER:
			{
			sprintf( str, TEXT( "Rebut GetGroup (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCUser) msg.dwParam1)->Group();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETQUOTE_USER:
			{
			sprintf( str, TEXT( "Rebut GetQuote (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCUser) msg.dwParam1)->Quote();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_CHECKPASSWORD_USER:
			{
			sprintf( str, TEXT( "Rebut CheckPassword (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCUser) msg.dwParam1)->CheckPassword( (PSTR) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETGROUP_USER:
			{
			sprintf( str, TEXT( "Rebut SetGroup (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCUser) msg.dwParam1)->Group( (PCGroup) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETQUOTE_USER:
			{
			sprintf( str, TEXT( "Rebut SetQuote (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCUser) msg.dwParam1)->Quote( msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETPASSWORD_USER:
			{
			sprintf( str, TEXT( "Rebut SetPassword (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			PTData data = (PTData) msg.dwParam2;
			((PCUser) msg.dwParam1)->NewPassword( (PSTR) data->dwParam1, (PSTR) data->dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		// Funcions sobre 'Callback'
		case SYS_CREATE_CALLBACK:
			{
			sprintf( str, TEXT( "Rebut CreateCallback (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			PTData data = (PTData) msg.dwParam2;
			msg.dwParam1 = (DWORD) new CCallback( (PCMailBox) data->dwParam2, (PCObject) msg.dwParam1, (PSTR) data->dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_DESTROY_CALLBACK:
			{
			sprintf( str, TEXT( "Rebut DestroyCallback (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			delete( (PCCallback) msg.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		// Funcions sobre 'Thread'
		case SYS_CREATE_THREAD:
			{
//			sprintf( str, TEXT( "Rebut CreateThread (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
//			TRACE( str );
			PTData data = (PTData) msg.dwParam2;
			PCkeThread pThread = new CkeThread( msg.dwParam1, data->dwParam1, data->dwParam2, (((PCkeMailBox) msg.pReply)->Creator())->Process(), NULL , NULL, FALSE );
			msg.dwParam1 = (DWORD) new CThread( pThread );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_DESTROY_THREAD:
			{
			sprintf( str, TEXT( "Rebut DestroyThread (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			PCkeThread temp = (PCkeThread) ((PCThread) msg.dwParam1)->GetInternalPointer();
			delete( (PCThread) msg.dwParam1 );
			delete( temp );
//			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETNEXTINALL_THREAD:
			{
			sprintf( str, TEXT( "Rebut GetNextInAll (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCThread) msg.dwParam1)->NextInAll();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETNEXTINPROCESS_THREAD:
			{
			sprintf( str, TEXT( "Rebut GetNextInProcess (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCThread) msg.dwParam1)->NextInProc();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETERRORCODE_THREAD:
			{
			sprintf( str, TEXT( "Rebut GetErrorCode (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCThread) msg.dwParam1)->ErrorCode();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETKERNELTIME_THREAD:
			{
			sprintf( str, TEXT( "Rebut GetKernelTime (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCThread) msg.dwParam1)->KernelTime();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETUSERTIME_THREAD:
			{
			sprintf( str, TEXT( "Rebut GetUserTime (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCThread) msg.dwParam1)->UserTime();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETPRIORITY_THREAD:
			{
			sprintf( str, TEXT( "Rebut GetPriority (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCThread) msg.dwParam1)->Priority();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETPROCESS_THREAD:
			{
			sprintf( str, TEXT( "Rebut GetProcess (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCThread) msg.dwParam1)->Process();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETCREATIONTIME_THREAD:
			{
			sprintf( str, TEXT( "Rebut GetCreationTime (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCThread) msg.dwParam1)->CreationTime();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETEXITSTATUS_THREAD:
			{
			sprintf( str, TEXT( "Rebut GetExitStatus (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCThread) msg.dwParam1)->ExitStatus();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETERRORCODE_THREAD:
			{
			sprintf( str, TEXT( "Rebut SetErrorCode (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCThread) msg.dwParam1)->ErrorCode( msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETPRIORITY_THREAD:
			{
			sprintf( str, TEXT( "Rebut SetPriority (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCThread) msg.dwParam1)->Priority( (BYTE) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETEXITSTATUS_THREAD:
			{
			sprintf( str, TEXT( "Rebut SetExitStatus (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCThread) msg.dwParam1)->Exit( msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		// Funcions sobre 'MailBox' -BUG
		case SYS_CREATE_MAILBOX:
			{
			sprintf( str, TEXT( "Rebut CreateMailBox (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			}
			break;

		case SYS_DESTROY_MAILBOX:
			{
			sprintf( str, TEXT( "Rebut DestroyMailBox (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			}
			break;

		case SYS_POSTMESSAGE_MAILBOX:
			{
			sprintf( str, TEXT( "Rebut PostMessage (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			}
			break;

		case SYS_WAITMESSAGE_MAILBOX:
			{
			sprintf( str, TEXT( "Rebut WaitMessage (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			}
			break;

		case SYS_PEEKMESSAGE_MAILBOX:
			{
			sprintf( str, TEXT( "Rebut PeekMessage (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			}
			break;

		case SYS_MESSAGECOUNT_MAILBOX:
			{
			sprintf( str, TEXT( "Rebut MessageCount (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			}
			break;

		// Funcions sobre 'Mutex'
		case SYS_CREATE_MUTEX:
			{
			msg.dwParam1 = (DWORD) new CMutex( (PCObject) msg.dwParam1, (PSTR) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_DESTROY_MUTEX:
			{
			sprintf( str, TEXT( "Rebut DestroyMutex (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			delete( (PCMutex) msg.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		// Funcions sobre 'ObjectDirectory'
		case SYS_CREATE_OBJECTDIRECTORY:
			{
			sprintf( str, TEXT( "Rebut CreateObjectDirectory (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) new CObjectDirectory( (PCObject) msg.dwParam1, (PSTR) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_DESTROY_OBJECTDIRECTORY:
			{
			sprintf( str, TEXT( "Rebut DestroyObjectDirectory (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			delete( (PCObjectDirectory) msg.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_FIRSTCHILD_OBJECTDIRECTORY:
			{
			sprintf( str, TEXT( "Rebut FirstChild (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCObjectDirectory) msg.dwParam1)->FirstChild();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_ADDCHILD_OBJECTDIRECTORY:
			{
			sprintf( str, TEXT( "Rebut AddChild (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCObjectDirectory) msg.dwParam1)->AddChild( (PCObject) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_DELETECHILD_OBJECTDIRECTORY:
			{
			sprintf( str, TEXT( "Rebut DeleteChild (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCObjectDirectory) msg.dwParam1)->DeleteChild( (PCObject) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		// Funcions sobre 'Object'
		case SYS_ANALYSIS_OBJECT:
			{
			sprintf( str, TEXT( "Rebut Analysis (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCObject) msg.dwParam1)->Analysis( (PSTR) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_ENTER_OBJECT:
			{
			sprintf( str, TEXT( "Rebut Enter (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCObject) msg.dwParam1)->Enter();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_LEAVE_OBJECT:
			{
			sprintf( str, TEXT( "Rebut Leave (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCObject) msg.dwParam1)->Leave();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETCREATOR_OBJECT:
			{
			sprintf( str, TEXT( "Rebut GetCreator (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCObject) msg.dwParam1)->Creator();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETNAME_OBJECT:
			{
			sprintf( str, TEXT( "Rebut GetName (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			PTData data = (PTData) msg.dwParam2;
			((PCObject) msg.dwParam1)->Name( (PSTR) data->dwParam1, data->dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETUSECOUNT_OBJECT:
			{
			sprintf( str, TEXT( "Rebut GetUseCount (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCObject) msg.dwParam1)->UseCount();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETTEMPORAL_OBJECT:
			{
			sprintf( str, TEXT( "Rebut GetTemporal (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCObject) msg.dwParam1)->Temporal();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		// Funcions sobre 'SymbolicLink'
		case SYS_CREATE_SYMBOLICLINK:
			{
			msg.dwParam1 = (DWORD) new CkeSymbolicLink( (PCkeObject) msg.dwParam1, (PSTR) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_DESTROY_SYMBOLICLINK:
			{
			sprintf( str, TEXT( "Rebut DestroySymbolicLink (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			delete( (PCkeSymbolicLink) msg.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETNAME_SYMBOLICLINK:
			{
			sprintf( str, TEXT( "Rebut GetNameSymbolicLink (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			PTData data = (PTData) msg.dwParam2;
			strncpy( (PSTR) data->dwParam1, ((PCkeSymbolicLink) msg.dwParam1)->NewName(), data->dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETNAME_SYMBOLICLINK:
			{
			((PCkeSymbolicLink) msg.dwParam1)->NewName( (PSTR) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		// Funcions sobre 'Semaphore'
		case SYS_CREATE_SEMAPHORE:
			{
//			sprintf( str, TEXT( "Rebut CreateSemaphore (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
//			TRACE( str );
			PTData data = (PTData) msg.dwParam2;
			msg.dwParam1 = (DWORD) new CSemaphore( data->dwParam2, (PCObject) msg.dwParam1, (PSTR) data->dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_DESTROY_SEMAPHORE:
			{
			sprintf( str, TEXT( "Rebut DestroySemaphore (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			delete( (PCSemaphore) msg.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		// Funcions sobre 'Timer'
		case SYS_CREATE_TIMER:
			{
			PTData data = (PTData) msg.dwParam2;
			msg.dwParam1 = (DWORD) new CTimer( data->dwParam3, (PCMailBox) data->dwParam2, (PCObject) msg.dwParam1, (PSTR) data->dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_DESTROY_TIMER:
			{
			delete( (PCTimer) msg.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETTIME_TIMER:
			{
			sprintf( str, TEXT( "Rebut GetTimeTimer (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = ((PCTimer) msg.dwParam1)->Time();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETTIME_TIMER:
			{
			((PCTimer) msg.dwParam1)->Time( msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		// Funcions sobre 'Region' -BUG
		case SYS_CREATE_REGION:
			break;

		case SYS_DESTROY_REGION:
			break;

		case SYS_GETVIRTUALSIZE_REGION:
			break;

		case SYS_GETUSER_REGION:
			break;

		case SYS_GETWRITEABLE_REGION:
			break;

		case SYS_GETREADABLE_REGION:
			break;

		case SYS_GETEXECUTABLE_REGION:
			break;

		case SYS_ADDVAD_REGION:
			break;

		case SYS_DELETEVAD_REGION:
			break;

		// Funcions genriques
		case SYS_GETPHYSICALMEMSIZE_SYS:
			{
			sprintf( str, TEXT( "Rebut GetPhysicalMemSize (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = System->PhysicalMemory();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETRUNNING_SYS:
			{
			sprintf( str, TEXT( "Rebut GetRunning (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) System->Running();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETFIRSTTHREAD_SYS:
			{
			sprintf( str, TEXT( "Rebut GetFirstThread (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) System->FirstThread();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_FINDOBJECT_SYS:
			{
			sprintf( str, TEXT( "Rebut FindObject (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			PSTR temp = (PSTR) msg.dwParam1;
			msg.dwParam1 = (DWORD) System->FindObject( (PSTR) temp );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_PAGESIZE_SYS:
			{
			sprintf( str, TEXT( "Rebut PageSize (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = System->PageSize();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_MACHINETYPE_SYS:
			{
			sprintf( str, TEXT( "Rebut MachineType (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = System->MachineType();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_TICKTIME_SYS:
			{
			sprintf( str, TEXT( "Rebut TickTime (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = System->TickTime();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_PANIC_SYS:
			{
			sprintf( str, TEXT( "Rebut Panic (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			System->Panic( (PSTR) msg.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_REGISTERINTERRUPT_SYS:
			{
			sprintf( str, TEXT( "Rebut RegisterInterrupt (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = System->RegisterInterrupt( (BYTE) msg.dwParam1, msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_UNREGISTERINTERRUPT_SYS:
			{
			sprintf( str, TEXT( "Rebut UnregisterInterrupt (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			System->UnregisterInterrupt( (BYTE) msg.dwParam1, msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETINTERRUPT_SYS:
			{
			sprintf( str, TEXT( "Rebut GetInterrupt (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) System->Interrupt( (BYTE) msg.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_TRACE_DEBUG:
			{
			sprintf( str, TEXT( "Rebut Trace (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			TRACE( (PSTR) msg.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_MEMORYDUMP_DEBUG:
			{
			sprintf( str, TEXT( "Rebut MemoryDump (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			(System->Debug())->MemoryDump( (PBYTE) msg.dwParam1, msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		// Funcions sobre 'Process' -BUG
		case SYS_CREATE_PROCESS:
			{
			sprintf( str, TEXT( "Rebut CreateProcess (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
//			msg.dwParam1 = (DWORD) new CProcess( NULL, sName, );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_DESTROY_PROCESS:
			{
			sprintf( str, TEXT( "Rebut DestroyProcess (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			delete( (PCProcess) msg.dwParam1 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_MAPREGION_PROCESS:
			{
			sprintf( str, TEXT( "Rebut MapRegion (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			}
			break;

		case SYS_UNMAPREGION_PROCESS:
			{
			sprintf( str, TEXT( "Rebut UnmapRegion (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			}
			break;

		case SYS_TRYTOMAPREGION_PROCESS:
			{
			sprintf( str, TEXT( "Rebut TryToMap (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			}
			break;

		case SYS_COMMIT_PROCESS:
			{
			sprintf( str, TEXT( "Rebut Commit (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			}
			break;

		case SYS_GETFIRSTTHREAD_PROCESS:
			{
			sprintf( str, TEXT( "Rebut GetFirstThread (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCProcess) msg.dwParam1)->Thread();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETBASEPRIORITY_PROCESS:
			{
			sprintf( str, TEXT( "Rebut GetBasePriority (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCProcess) msg.dwParam1)->BasePriority();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETHEAPADDRESS_PROCESS:
			{
			sprintf( str, TEXT( "Rebut GetHeapAddress (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCProcess) msg.dwParam1)->Heap();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETPRIVILEGELEVEL_PROCESS:
			{
			sprintf( str, TEXT( "Rebut GetPrivilegeLevel (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCProcess) msg.dwParam1)->PrivilegeLevel();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETUSER_PROCESS:
			{
			sprintf( str, TEXT( "Rebut GetUser (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCProcess) msg.dwParam1)->User();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETBASEPRIORITY_PROCESS:
			{
			sprintf( str, TEXT( "Rebut SetBasePriority (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCProcess) msg.dwParam1)->BasePriority( (BYTE) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		// Funcions sobre 'Resource' -BUG
		case SYS_WAIT_RESOURCE:
			{
			sprintf( str, TEXT( "Rebut Wait (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCResource) msg.dwParam1)->Wait();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;
/*
		case SYS_CHECK_RESOURCE:
			{
			sprintf( str, TEXT( "Rebut Check (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCResource) msg.dwParam1)->Check();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;
*/
		case SYS_RELEASE_RESOURCE:
			{
			sprintf( str, TEXT( "Rebut Release (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCResource) msg.dwParam1)->Release();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_GETSTATUS_RESOURCE:
			{
			sprintf( str, TEXT( "Rebut GetStatus (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			msg.dwParam1 = (DWORD) ((PCResource) msg.dwParam1)->Status();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_SETSTATUS_RESOURCE:
			{
			sprintf( str, TEXT( "Rebut SetStatus (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			((PCResource) msg.dwParam1)->Status( (BYTE) msg.dwParam2 );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		// Funcions sobre 'Console'
		case SYS_CREATE_CONSOLE:
			{
			msg.dwParam1 = (DWORD) System->Console();
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_DESTROY_CONSOLE:
			{
			sprintf( str, TEXT( "Rebut DestroyConsole (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );
			if( msg.pReply )
				((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_OUTTEXT_CONSOLE:
			{
			if( pvideo )
				pvideo->OutText( (PSTR) msg.dwParam2 );
			else
				(System->Console())->OutText( (PSTR) msg.dwParam2 );

			free( (PSTR) msg.dwParam2 );
			}
			break;

		case SYS_GOTOXY_CONSOLE:
			{
			sprintf( str, TEXT( "Rebut GotoXY (%08x,%08x) des de %08x" ), msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			TRACE( str );

			if( pvideo )
				pvideo->GotoXY( (BYTE) (msg.dwParam2 & 0xff), (BYTE) ((msg.dwParam2 >> 8) & 0xff) );
			else
				((PCkeConsole) msg.dwParam1)->GotoXY( (BYTE) (msg.dwParam2 & 0xff), (BYTE) ((msg.dwParam2 >> 8) & 0xff) );

			if( msg.pReply )
				((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		case SYS_CLEAR_CONSOLE:
			{
			if( pvideo )
				pvideo->Clear();
			else
				((PCkeConsole) msg.dwParam1)->Clear();

			if( msg.pReply )
				((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			}
			break;

		default:
			sprintf( str, TEXT( "SYS.EXE - Parmetre no reconegut %08x (%08x,%08x) des de %08x\r\n" ), msg.dwMessage, msg.dwParam1, msg.dwParam2, (DWORD) msg.pReply );
			(System->Console())->OutText( str );
		}

	Kernel->UnmapSpace(); // Tornem al nostre espai d'adreces

	return FALSE;	// El sistema sempre retorna FALSE
	}

// **************************************************************************
// Atura l'ordinador de manera segura
VOID Shutdown()
	{
// Cridar les funcions registrades

// -- Cerquem el directori que cont les funcions a cridar
#ifdef _DEBUG
	{
	PCkeType pCheck = System->FindObject( SHUTDOWN_DIR );
	CHECK_CLASS( pCheck, CID_ObjectDirectory, TEXT( "Shutdown->SHUTDOW_DIR no s un ObjectDirectory" ) );
	}
#endif

	PCkeObjectDirectory pShutdown = (PCkeObjectDirectory) System->FindObject( SHUTDOWN_DIR );
// -- Obtenim la primera funci a cridar
#ifdef _DEBUG
	{
	PCkeType pCheck = pShutdown->FirstChild();

	if( pCheck )
		CHECK_CLASS( pCheck, CID_Callback, TEXT( "Shutdown->FirstChild() no s un Callback" ) );
	}
#endif

	PCkeCallback pCallback = (PCkeCallback) pShutdown->FirstChild();
// -- Cridem a totes aquestes funcions (la segent de l'ltima apunta a NULL)
	while( pCallback )
		{
		pCallback->Release();

#ifdef _DEBUG
	{
	PCkeType pCheck = pCallback->GetNext();
	CHECK_CLASS( pCheck, CID_Callback, TEXT( "CkeKernel::Shutdown->GetNext() no s un Callback" ) );
	}
#endif

		pCallback = (PCkeCallback) pCallback->GetNext();
		}
// Esperar la finalitzaci de totes les crides (es van realitzant: UnregisterShutdown)
	while( dwshutdowncount )
		{
		}

	(System->Console())->Clear();
	PSTR str = sSHUTDOWN;
	BYTE posx = 40 - strlen( str ) / 2;
	(System->Console())->GotoXY( posx, 11 );
	(System->Console())->OutText( str );

// Aturar l'ordinador
	Kernel->Shutdown();
	}

// **************************************************************************
// Registra una funci que ser cridada quan es realitzi el 'shutdown'
// Com a entrada ha de rebre:
// Callback		- Indica l'objecte de devoluci de crida adent
VOID RegisterShutdownNotification( PCkeCallback pCallback )
	{
	CHECK_CLASS( pCallback, CID_Callback, TEXT( "CkeKernel::RegisterShutdownNotification->pCallback no s de tipus Callback" ) );

// Cerquem el directori que cont les funcions a cridar
	PCkeObjectDirectory pShutdown = (PCkeObjectDirectory) System->FindObject( SHUTDOWN_DIR );
// Afegim la nova funci
	pShutdown->AddChild( pCallback );
	dwshutdowncount++;
	}

// **************************************************************************
// Desregistra una funci que havia estat registrada
// Com a entrada ha de rebre:
// Callback		- Indica l'objecte de devoluci de crida adent
VOID UnregisterShutdownNotification( PCkeCallback pCallback )
	{
	CHECK_CLASS( pCallback, CID_Callback, TEXT( "CkeKernel::UnregisterShutdownNotification->pCallback no s de tipus Callback" ) );

// Cerquem el directori que cont les funcions a cridar
	PCkeObjectDirectory pShutdown = (PCkeObjectDirectory) System->FindObject( SHUTDOWN_DIR );
// Esborrem la funci
	pShutdown->DeleteChild( pCallback );
	dwshutdowncount--;
	}

// **************************************************************************
// Retorna el nom i l'extensi del fitxer ignorant el cam
// Com a entrada ha de rebre:
// Name    		- Nom complet amb el cam
PSTR GetFilename( PSTR sName )
	{
	PCHAR slash = strchr( sName, '\\' );

	while( slash ) // Saltem de '\' a '\' fins a l'ltim
		{
		sName = slash + 1;
		slash = strchr( sName, '\\' );
		}

	// A partir d'aqu hi ha el nom
	PSTR filename = (PSTR) malloc( strlen( sName ) + 1 );
	strcpy( filename, sName );
	return filename;
	}

// **************************************************************************
// Carrega i executa un fitxer
// Com a entrada ha de rebre:
// Name    		- Nom complet del fitxer
BOOL Exec( PSTR sName )
	{
	PCExecutableFile exec;
	PCkeProcess pProcess;
	// Obrim el fitxer
	PCdrvUserFile file = new CdrvUserFile( sName, READONLY, DENYNONE );

	if( file->Status() == OK ) // Correcte?
		{
		PSTR filename = GetFilename( sName ); // Obtenim el seu nom i extensi

		exec = new CExecutableFile( file ); // Preparem el fitxer executable

		if( (System->Running())->ErrorCode() == OK ) // Si s'ha certificat corrrectament
			{
			PCSection code = new CSection( exec ); // Preparem la primera secci a carregar
			code->Initialize( ATEXT( "CODE" ) );

			if( !(System->Running())->ErrorCode() ) // Si no hi ha error
				{
//				CHAR str[ 80 ];
//				sprintf( str, TEXT( "Name: %-8s, VirtualSize: %08x, VirtualAddress: %08x\r\n" ), code->Name(), code->VirtualSize(), code->VirtualAddress() );
//				pvideo->OutText( str );
				PCkeObject pprocessdir = System->FindObject( PROCESS_DIR );
				// Preparem el procs (per sense fluxos)
				pProcess = new CkeProcess( filename, exec->ImageBase() + exec->AddressOfEntryPoint(), exec->SizeOfHeapReserve(), exec->SizeOfHeapCommit(), exec->SizeOfStackReserve(), exec->SizeOfStackCommit(), pprocessdir, MODE_USER, FALSE, FALSE );
				Kernel->UnmapSpace();
				Kernel->MapProcessSpace( pProcess ); // Mapegem l'espai del nou procs
				code->Read( pProcess ); // Llegim la primera secci
				delete code;
				PCSection data = new CSection( exec ); // Preparem la segona secci
				data->Initialize( ATEXT( "DATA" ) );

				if( !(System->Running())->ErrorCode() ) // Si no hi ha error -BUG
					{
//					sprintf( str, TEXT( "Name: %-8s, VirtualSize: %08x, VirtualAddress: %08x\r\n" ), data->Name(), data->VirtualSize(), data->VirtualAddress() );
//					pvideo->OutText( str );
					data->Read( pProcess ); // Llegim la secci
					delete data;
					}
				}
			else
				return FALSE; // Hi ha hagut algun error
			}
		else
			return FALSE;
		}
	else
		return FALSE;

	// Generem el primer flux
	new CkeThread( exec->ImageBase() + exec->AddressOfEntryPoint(), exec->SizeOfStackReserve(), exec->SizeOfStackCommit(), pProcess, NULL );
	Kernel->UnmapSpace(); // Passem al nostre espai d'adreces

	return TRUE; // No hi ha hagut cap error
	}

// **************************************************************************
// Flux inicialitzador/executor
VOID Prepare()
	{
	CkeMailBox box( NULL ); // Preparem la bstia
	pinitmb = &box; // Bstia d'inicialitzaci
	TMSG msg;

	for( BYTE level = 0; level < 32; level++ ) // Nivell dels controladors
		{
		DWORD dwcount = 0;
		PTDriver pitem = pLoadedDrivers;

		while( pitem ) // Cerquem tots els controladors d'un cert nivell
			{
			if( pitem->cLevel == level ) // N'hem trobat un
				{
				((PCkeMailBox) pitem->pReturn)->PostMessage( &msg ); // Enviem una resposta
				dwcount++; // Enviada una resposta ms
				}

			pitem = (PTDriver) pitem->pnext; // Passem al segent
			}

		while( dwcount ) // Esperem rebre 'count' missatges de preparat
			{
			box.WaitMessage( &msg );
			dwcount--;
			}
		}

	// Estan preparats tots els controladors de dispositiu
	pvideo = new CdrvVideo(); // Creem la pantalla virtual de depuraci
	pvideo->SetCaret( FALSE ); // No hi volem cursor
	PCdrvKeyboard keyb = new CdrvKeyboard( pvideo ); // Necessitem el teclat per a poder-hi entrar i surtir-ne
	keyb->Activate(); // L'activem
	pvideo->GotoXY( 0, (BYTE) (3 + dwloadeddrivers) );

	prepmb = &box; // Bstia de l'executor

	BOOL bOK = Exec( TEXT( "C:\\EROS\\BIN\\FENIX.EXE" ) ); // Executem el primer subsistema

	if( !bOK ) // Si hi ha hagut algun problema
		(System->Console())->OutText( sFIRST_SUBSYSTEM );

	// Generem el flux que presenta informaci sobre l'estat del sistema
	new CkeThread( (DWORD) Thread2, SYS_STACKRESERVE, SYS_STACKCOMMIT, (System->Running())->Process(), NULL );

	while( 1 )
		{
		box.WaitMessage( &msg ); // Esperem missatges d'execuci i parada

		if( msg.dwMessage == SYS_EXEC_MOD )
			{
			Kernel->MapThreadSpace( ((PCkeMailBox) msg.pReply)->Creator() );
			msg.dwParam1 = (DWORD) Exec( (PSTR) msg.dwParam1 );
//			Kernel->MapThreadSpace( ((PCkeMailBox) msg.pReply)->Creator() );
			((PCkeMailBox) msg.pReply)->PostMessage( &msg );
			Kernel->UnmapSpace();
			}
		else
		if( msg.dwMessage == SYS_SHUTDOWN_MOD )
			Shutdown();
		}
	}

// **************************************************************************
// Crea els processos i fluxos dels controladors de dispositiu
VOID Init()
	{
	PTModule mod = (PTModule) MODULE16_OFFSET; // Anem cap a la taula generada per DOSLoad
	DWORD index = 3; // Els tres primers sn: SYS.EXE, KERNEL.DLL i AAL.DLL

	while( index < MAX_IMAGES && mod[ index ].dwEntryPoint )
		{ // Comptem el nombre de fluxos carregats
		index++;
		dwloadeddrivers++;
		}

	index = 3; // Tornem al quart
	PCkeObject pprocessdir = System->FindObject( PROCESS_DIR );

	while( index < MAX_IMAGES && mod[ index ].dwEntryPoint )
		{
		// Crear el procs
		new CkeProcess( mod[ index ].sName, mod[ index ].dwEntryPoint, SYS_HEAPRESERVE, SYS_HEAPCOMMIT, SYS_STACKRESERVE, SYS_STACKCOMMIT, pprocessdir, MODE_KERNEL );
		index++;
		}
	}

// **************************************************************************
// Transforma un valor de milisegons en hores, minuts i segons
// Com a entrada ha de rebre:
// Time    		- Nombre de milisegons
// Hour    		- Hores
// Minute  		- Minuts
// Second  		- Segons
VOID Transform( DWORD Time, BYTE &Hour, BYTE &Minute, BYTE &Second )
	{
	DWORD second = Time / 1000;
	DWORD minute = second / 60;
	Hour = (BYTE) (minute / 60);
	Minute = (BYTE) (minute % 60); // Mxim 59
	Second = (BYTE) (second % 60); // Mxim 59
	}

// **************************************************************************
// Flux que presenta informaci sobre el sistema
VOID Thread2()
	{
	PCdrvVideo video = new CdrvVideo(); // Nova pantalla virtual
	video->SetCaret( FALSE ); // Sense cursor
	PCdrvKeyboard keyb = new CdrvKeyboard( video ); // Necessitem el teclat
//	keyb->Activate();

	CHAR str[ 100 ];
	// Presentem el tipus de processador
	CHAR sMachine[ 8 ][ 25 ] = { "error en CpuType", "error en CpuType", "error en CpuType", "Intel 386 o compatible", "Intel 486", "Intel Pentium", "Intel Pentium Pro", "Intel Merced" };
	sprintf( str, sMACHINE, sMachine[ System->MachineType() & 0x0ff ] );
	video->OutText( str );
	// Quantitat de memria fsica
	sprintf( str, sPHYS_MEM, System->PhysicalMemory() );
	video->OutText( str );
	// Taula de fluxos
	video->GotoXY( 2, 5 );
	video->OutText( sTITLE );

	for( DWORD pos = 0; pos <= 79; pos++ )
		str[ pos ] = '-';

	str[ 80 ] = 0;
	video->OutText( str );

	video->OutText( TEXT( "Idle" ) );

	PCkeMailBox preply = new CkeMailBox( NULL );

	new CkeTimer( 1000, preply, NULL ); // Actualitzarem cada segon

	TMSG msg;

	while( 1 )
		{
		preply->WaitMessage( &msg );
		Info( video ); // Presentem la informaci
		}
	}

// **************************************************************************
// Presenta informaci en una pantalla virtual
// Com a entrada ha de rebre:
// Video   		- Objecte que gestiona la pantalla virtual
VOID Info( PCdrvVideo pVideo )
	{
	CHAR str[ 100 ];

	// Memria utilitzada
	pVideo->GotoXY( 0, 2 );
	sprintf( str, sUSED_MEM, (System->PAT())->CountUsedPages() * PAGE_SIZE );
	pVideo->OutText( str );
	// 'Heap' del sistema lliure (bloc ms gran i suma de tots els blocs lliures)
	sprintf( str, sHEAP, (System->Heap())->GetMaxFree(), (System->Heap())->GetTotalFree() );
	pVideo->OutText( str );

	DWORD Total = System->TickTime(); // Temps que portem d'execuci del sistema

	DWORD stime = Kernel->IdleTime(); // Temps que portem en el flux 'Idle'
	DWORD stime2;
	pVideo->GotoXY( 23, 7 );
	BYTE hour, min, sec;
	Transform( stime, hour, min, sec );
	sprintf( str, TEXT( "%2u:%02u:%02u (%3u%%)" ), (DWORD) hour, (DWORD) min, (DWORD) sec, (DWORD) ((stime * 100) / Total) );
	pVideo->OutText( str );

	// Presentem la llista de fluxos
	BYTE y = 8;
	PCkeThread pthread;
	pthread = System->FirstThread();

	while( pthread && y < 24 )
		{
		PCkeProcess pproc = pthread->Process(); // Trobem el procs al qual pertany
		pVideo->GotoXY( 0, y );
		stime = pthread->KernelTime(); // Obtenim el temps d'execuci en mode 'Kernel'
		stime2 = pthread->UserTime(); // Obtenim el temps d'execuci en mode 'User'
		Transform( stime, hour, min, sec );
		sprintf( str, TEXT( "%-12s %08x  %2u:%02u:%02u (%3u%%)   " ), pproc->Name(), (DWORD) pthread, (DWORD) hour, (DWORD) min, (DWORD) sec, (DWORD) ((stime * 100) / Total) );
		Transform( stime2, hour, min, sec );
		CHAR str2[ 45 ];
		sprintf( str2, TEXT( "%2u:%02u:%02u (%3u%%)    %2u" ), (DWORD) hour, (DWORD) min, (DWORD) sec, (DWORD) ((stime2 * 100) / Total), (DWORD) pthread->Priority() );
		strcat( str, str2 );
		pVideo->OutText( str );
		y++;
		pthread = pthread->NextInAll(); // Passem al segent flux de tot el sistema
		}
	}

