/* **************************************************************************
*                                                                           *
*  AAL.H                                                                    *
*                                                                           *
*  10-02-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Architecture Abstraction Library - Declaracions globals                  *
*                                                                           *
************************************************************************** */

#ifndef _aalAAL_H
#define _aalAAL_H

#include "kernel\type.h"
#include "aal\dma.h"
#include "aal\pic.h"
#include "aal\cmos.h"

#define AAL_ARCH_ISA			0x00000001

_AALEXP( CaalAAL )

class CaalAAL : public CkeType
	{
	protected:
		PCDMA pdma;
		PCPIC ppic;

	public:
		CaalAAL();
		virtual ~CaalAAL();

		virtual BOOL ClassCheck( CUID );

		DWORD Version();
		DWORD Architecture();

		BOOL MathProcessor();

		BYTE TypeOfFloppy0();
		BYTE TypeOfFloppy1();

		TAAL_TIME Time();
		TAAL_DATE Date();

		VOID Time( TAAL_TIME );
		VOID Date( TAAL_DATE );

		VOID EOI( BYTE );
		VOID IRQHandler( BYTE, DWORD );
		DWORD IRQHandler( BYTE );
		VOID MaskIRQ( BYTE );
		VOID UnmaskIRQ( BYTE );

		VOID ReserveDMAChannel( BYTE );
		VOID FreeDMAChannel( BYTE );
		VOID DMATransfer( BYTE, BYTE, BYTE, DWORD, DWORD );
		DWORD DMAGetResidue( BYTE );
	};

#endif

