/* **************************************************************************
*                                                                           *
*  Cache.H                                                                  *
*                                                                           *
*  28-04-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Gestor de memria cach de l'Eros (declaracions privades)                *
*                                                                           *
************************************************************************** */

#ifndef _CACHE_H
#define _CACHE_H

#include "drivers\block\cache.h"
#include "drivers\block\blockdev.h"

typedef struct _CachedBlock *PTCachedBlock;

typedef struct _CachedBlock
	{
	PTCachedBlock pprev, pnext;
	PTCachedBlock pLRUprev, pLRUnext;
	PCdrvBlockDevice pDevice;
	DWORD dwReserved;
	DWORD dwBlock;
	DWORD dwLastUsedTick;
	DWORD dwFlags;
	DWORD dwAddress;
	} TCachedBlock;

#define BLOCK_CHANGED			0x80000000

#define HASH_LISTS				8

_CLASSDEF( CCache )

class CCache : public CkeType
	{
		CCache();

	protected:
		PCdrvBlockDevice pdev;
		DWORD dwblocksize;

		PTCachedBlock Search( DWORD );
		VOID Add( PTCachedBlock );

	public:
		CCache( PCdrvBlockDevice );
		virtual ~CCache();

		DWORD Read( PBYTE, DWORD, DWORD );
		DWORD Write( PBYTE, DWORD, DWORD );
		BOOL Verify( DWORD, DWORD );
		VOID Flush( DWORD );
	};

#endif

