/* **************************************************************************
*                                                                           *
*  KbdTable.H                                                               *
*                                                                           *
*  25-02-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Taules necessries per a la traducci d'scan codes a ASCII               *
*                                                                           *
************************************************************************** */

#ifndef _kbdTABLES_H
#define _kbdTABLES_H

// The following special keys are processed by the Keyboard Task and handled
// as follows:
// NUMLOCK  - Lights NumLock LED and processes keys accordingly
// SHIFT    - Sets shift flag and processes keys accordingly
// CTRL	   - Sets Ctrl flag
// CAPSLOCK - Lig,ts CapsLock LED and processes keys accordingly
// ALT	   - Sets Alt flag.
// SCRLLOCK - Lights ScrollLock LED and flag
//
// This table is used to translate all active editing keys from
// the raw value provided by the hardware.
//								SHIFT
//								Value
BYTE KbdTable[] =
	{
	0x00,	// 	  		00
	0x1b,	//  Esc	 	01
	0x31,	//  1		 	02		21h  !
	0x32,	//  2	 		03		40h  @
	0x33,	//  3	 		04		23h  #
	0x34, //  4		 	05		24h  $
	0x35,	//  5	 		06		25h  %
	0x36,	//  6		 	07		5Eh  ^
	0x37,	//  7		 	08		26h  &
	0x38,	//  8		 	09		2Ah  *
	0x39,	//  9	 		0A		28h  (
	0x30,	//  0	 		0B		29h  )
	0x2D,	//  -	 		0C		5Fh  _
	0x3D,	//  =		 	0D		2Bh  +
	0x08,	//  BkSpc	0E
	0x09,	//  TAB	 	0F
	0x71,	//  q		 	10		51h
	0x77,	//  w		 	11		57h
	0x65,	//  e		 	12		45h
	0x72,	//  r		 	13		52h
	0x74,	//  t		 	14		54h
	0x79,	//  y	 		15		59h
	0x75,	//  u		 	16		55h
	0x69,	//  i	 		17		49h
	0x6F,	//  o		 	18		4Fh
	0x70,	//  p		 	19		50h
	0x5B,	//  [	 		1A		7Bh
	0x5D,	//  ]		 	1B		7Dh
	0x0D,	//  CR	 	1C
	0x00,	//  LCtrl 	1D    Special handling
	0x61,	//  a		 	1E		41h
	0x73,	//  s		 	1F		53h
	0x64,	//  d		 	20		44h
	0x66,	//  f		 	21		46h
	0x67,	//  g		 	22		47h
	0x68,	//  h		 	23		48h
	0x6A,	//  j		 	24		4Ah
	0x6B,	//  k		 	25		4Bh
	0x6C,	//  l (L) 	26		4Ch
	0x3B,	//  ;	 		27		3Ah
	0x27,	//  '    	28		22h
	0x60,	//  `		 	29		7Eh
	0x00,	//  LfShf 	2A    Special handling
	0x5C,	//  \ 	 	2B		7Ch
	0x7A,	//  z		 	2C		5Ah
	0x78,	//  x	 		2D		58h
	0x63,	//  c	 		2E		43h
	0x76,	//  v		 	2F		56h
	0x62,	//  b		 	30		42h
	0x6E,	//  n		 	31		4Eh
	0x6D,	//  m	 		32		4Dh
	0x2C,	//  ,	 		33		3Ch
	0x2E,	//  .	 		34		3Eh
	0x2F,	//  /	 		35		3Fh
	0x00,	//  RtShf 	36    Special handling
	0x2A,	//  Num * 	37		Num pad
	0x00,	//  LAlt  	38    Special handling
	0x20,	//  Space 	39
	0x00,	//  CpsLk 	3A    Special handling
	0x0F,	//  F1	 	3B
	0x10,	//  F2	 	3C
	0x11,	//  F3	 	3D
	0x12,	//  F4	 	3E
	0x13,	//  F5	 	3F
	0x14,	//  F6	 	40
	0x15,	//  F7	 	41
	0x16,	//  F8	 	42
	0x17,	//  F9	 	43
	0x18,	//  F10	 	44
	0x00,	//  NumLk 	45   Special handling
	0x00,	//  ScrLk 	46   Special handling
	0x86,	//  Num 7 	47		37h		Num Home
	0x81,	//  Num 8 	48		38h		Num Up
	0x85,	//  Num 9 	49		39h		Num Pg Up
	0xAD,	//  Num - 	4A				Num Pad
	0x83,	//  Num 4 	4B		34h		Num Left
	0x9F,	//  Num 5 	4C		35h		Num (Extra code)
	0x84,	//  Num 6 	4D		36h		Num Rig,t
	0xAB,	//  Num + 	4E				Num Pad
	0x8B,	//  Num 1 	4F		31h		Num End
	0x82,	//  Num 2 	50		32h		Num Down
	0x8C,	//  Num 3 	51		33h		Num Pg Dn
	0x8E,	//  Num 0 	52		30h		Num Insert
	0xFF,	//  Num . 	53		2Eh		Num Del
	0x1C,	//  Pr Scr 	54  			SYS REQUEST
	0x00,	// 	     	55
	0x00, //       	56
	0x19, //  F11	 	57
	0x1A,	//  F12	 	58
	0x00,	//	 		 	59
	0x00,	//	 			5A
	0x00,	//	 		 	5B
	0x00,	//	 		 	5C
	0x00,	//	 		 	5D
	0x00,	//	 		 	5E
	0x00,	//	 		 	5F   The following chars are subs from table2
	0x0E,	//  Ins	 	60	Cursor pad
	0x0B,	//  End	 	61	Cursor pad
	0x02,	//  Down		62	Cursor pad
	0x0C,	//  PgDn		63	Cursor pad
	0x03,	//  Left		64	Cursor pad
	0x00,	//	     		65
	0x04,	//  Right	66	Cursor pad
	0x06,	//  Home		67	Cursor pad
	0x01,	//  Up		68	Cursor pad
	0x05,	//  PgUp		69	Cursor pad
	0x7F,	//  Delete  6A	Cursor pad
	0xAF,	//  /	 		6B  Num Pad
	0x8D,	//  ENTER	6C  Num Pad
	0x00,	//				6D
	0x00,	//	   	  	6E
	0x00,	//	 			6F
	0x00,	//	 			70
	0x00,	//	 			71
	0x00,	//	 			72
	0x00,	//	 			73
	0x00,	//	 			74
	0x00,	//		 		75
	0x00,	//		 		76
	0x00,	//		 		77
	0x00,	//		 		78
	0x00,	//		 		79
	0x00,	//		 		7A
	0x00,	//		 		7B
	0x00,	//	 			7C
	0x00,	//		 		7D
	0x00,	//	 			7E
	0x00	//	 			7F
	};

//This table does an initial character translation from the characters
//provided by the keyboard.  The Kbd translates incoming keystrokes
//from the original scan set 2 for the IBM PC.  All PCs are are set to this
//by default.  Keys on the 101 keyboard that were common to the numeric
//keypad use a two character escape sequence begining with E0 hex.
//If we see an E0 hex we scan this table and provide the translation
//to another unique character which is looked up in the primary
//table above.  This gives us unique single characters for every key.

#define nKbdTable2 	16

BYTE KbdTable2[] =
	{
	0x52,  0x60,    //Insert
	0x4F,  0x61,    //End
	0x50,  0x62,    //Down
	0x51,  0x63,    //Pg Down
	0x4B,  0x64,    //Left
	0x4D,  0x66,    //Rite
	0x47,  0x67,    //Home
	0x48,  0x68,    //Up
	0x49,  0x69,    //Pg Up
	0x53,  0x6A,    //Delete
	0x37,  0x6B,    //Num /
	0x1C,  0x6C,    //Num ENTER
	0x38,  0x70,    //Right ALT DOWN	    These are special cause we
	0x1D,  0x71,    //Right Ctrl DOWN	track UP & DOWN!!!
	0xB8,  0xF0,    //Right ALT UP
	0x9D,  0xF1,    //Right Ctrl UP
	};

//This table provides shift level values for codes from the primary KbdTable.
//In Shift-ON state, keycodes 21 - 7E hex are translated through this table.
//In CAPS LOCK state, codes 61, to 7A, are translated through this table
//In NUM LOCK state, codes wit, High Bit set are translated

BYTE KbdTableS[] =
	{
	0x00,		//	00
	0x38,		//	01  Up   8  Numeric pad
	0x32,		//	02  Dn   2  Numeric pad
	0x34,		//	03  Left 4  Numeric pad
	0x36,		//	04  Rite 6  Numeric pad
	0x39,		//	05  PgUp 9  Numeric pad
	0x37,		//	06  Home 7  Numeric pad
	0x07,		//	07
	0x08,		//	08
	0x09,		//	09
	0x0A,		//	0A
	0x31,		//	0B  End  1  Numeric Pad
	0x33,		//	0C  PgDn 3  Numeric pad
	0x0D,		//	0D
	0x30,		//	0E  Ins  0  Numeric pad
	0x0F,		//	0F
	0x10,		//	10
	0x11,		//	11
	0x12,		//	12
	0x13,		//	13
	0x14,		//	14
	0x15,		//	15
	0x16,		//	16
	0x17,		//	17
	0x18,		//	18
	0x18,		//	19
	0x1A,		//	1A
	0x1B,		//	1B
	0x1C,		//	1C
	0x1D,		//	1D
	0x1E,		//	1E
	0x35,		//	1F	Blnk 5  Numeric pad
	0x20,		//	20
	0x21,		//	21
	0x22,		//	22
	0x23,		//	23
	0x24,		//	24
	0x25,		//	25
	0x26,		//	26
	0x22,		//	27  '  "
	0x28,		//	28
	0x29,		//	29
	0x2A,		//	2A
	0x2B,		//	2B
	0x3C,		//	2C  ,  <
	0x5F,		//	2D  -  _
	0x3E,		//	2E  .  >
	0x3F,		//	2F  /  ?
	0x29,		//	30  0  )
	0x21,		//	31  1  !
	0x40,	 	//	32  2  @
	0x23,	 	//	33  3  #
	0x24,		//	34  4  $
	0x25,	 	//	35  5  %
	0x5E,	 	//	36  6  ^
	0x26,	 	//	37  7  &
	0x2A,	 	//	38  8  *
	0x28,	 	//	39  9  (
	0x3A,	 	//	3A
	0x3A,	 	//	3B  ;  :
	0x3C,	 	//	3C
	0x2B,	 	//	3D  =  +
	0x3E,	 	//	3E
	0x3F,	 	//	3F
	0x40,	 	//	40
	0x41,	 	//	41
	0x42,	 	//	42
	0x43,	 	//	43
	0x44,	 	//	44
	0x45,	 	//	45
	0x46,	 	//	46
	0x47,	 	//	47
	0x48,	 	//	48
	0x49,	 	//	49
	0x4A,	 	//	4A
	0x4B,	 	//	4B
	0x4C,	 	//	4C
	0x4D,	 	//	4D
	0x4E,	 	//	4E
	0x4F,	 	//	4F
	0x50,	 	//	50
	0x51,	 	//	51
	0x52,	 	//	52
	0x53,	 	//	53
	0x54,	 	//	54
	0x55,	 	//	55
	0x56,	 	//	56
	0x57,	 	//	57
	0x58,	 	//	58
	0x59,	 	//	59
	0x5A,	 	//	5A
	0x7B,	 	//	5B  [  {
	0x7C,	 	//	5C  \  |
	0x7D,	 	//	5D  ]  }
	0x5E,	 	//	5E
	0x5F,	 	//	5F
	0x7E,	 	//	60  `  ~
	0x41,	 	//	61  a  A
	0x42,	 	//	62	b  B
	0x43,	 	//	63	c  C
	0x44,	 	//	64	d  D
	0x45,	 	//	65	e  E
	0x46,	 	//	66	f  F
	0x47,	 	//	67	g  G
	0x48,	 	//	68	h  H
	0x49,	 	//	69	i  I
	0x4A,	 	//	6A	j  J
	0x4B,	 	//	6B	k  K
	0x4C,	 	//	6C	l  L
	0x4D,	 	//	6D	m  M
	0x4E,	 	//	6E	n  N
	0x4F,	 	//	6F	o  O
	0x50,	 	//	70	p  P
	0x51,	 	//	71	q  Q
	0x52,	 	//	72	r  R
	0x53,	 	//	73	s  S
	0x54,	 	//	74	t  T
	0x55,	 	//	75	u  U
	0x56,	 	//	76	v  V
	0x57,	 	//	77  w  W
	0x58,	 	//	78  x  X
	0x59,	 	//	79  y  Y
	0x5A,	 	//	7A  z  Z
	0x7B,	 	//	7B
	0x7C,	 	//	7C
	0x7D,	 	//	7D
	0x7E,	 	//	7E
	0x2E,	 	//	7F	Del  .  Numeric Pad
	};

#endif

