/* **************************************************************************
*                                                                           *
*  Keyb.H                                                                   *
*                                                                           *
*  13-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Controlador de teclat de l'Eros (declaracions privades)                  *
*                                                                           *
************************************************************************** */

#ifndef _KEYB_H
#define _KEYB_H

#include "drivers\char\keyb.h"
#include "kernel\list.h"
#include "kernel\mailbox.h"
#include "drivers\char\video.h"
#include "kernel\thread.h"

#define BUFFER_SIZE	64

// These "masks" are for keyboard states that change with special keys:
// They are BIT OFFSETS and NOT MASKS for logical operations!!!!!
#define CtrlLeftBit    	0
#define CtrlRiteBit    	1
#define ShftLeftBit    	2
#define ShftRiteBit    	3
#define AltLeftBit     	4
#define AltRiteBit     	5

// Mask to tell if one of the 3 states exist (Ctrl, Shift, Alt)
#define CtrlDownMask		3
#define ShftDownMask		12
#define AltDownMask		48

// Locks
//#define CpLockBit      	2
//#define NmLockBit      	1
//#define ScLockBit      	0

// MASKS
#define CpLockMask     	4
#define NmLockMask      2
#define ScLockMask      1

//=============================================================================
//The following equates are for the hardware handling code.
//8042 Status Byte, Port Hex 0064 Read
//=============================================================================

#define STATUSPORT		0x64
#define COMMANDPORT		0x64
#define DATAPORT			0x60

#define PARITYERROR		0x80
#define GENERALTIMEOUT	0x40
#define AUXOUTBUFFFULL	0x20
#define INHIBITSWITCH	0x10
#define COMMANDDATA		0x08
#define SYSTEMFLAG		0x04
#define INPUTBUFFFULL	0x02
#define OUTPUTBUFFFULL	0x01

_CLASSDEF( CKeyboard )

class CKeyboard : public CkeDblListItem
	{
		CKeyboard();

	protected:
		PCdrvVideo pvideo;
		PCkeThread pthread;
		PDWORD pbufferin;
		PDWORD pbufferout;
		DWORD buffer[ BUFFER_SIZE ];
		PCkeMailBox pmailbox;

	public:
		CKeyboard( PCdrvVideo, PCkeThread );
		virtual ~CKeyboard();

		VOID PutChar( DWORD );
		DWORD GetChar();

		VOID MailBox( PCkeMailBox );
		PCkeMailBox MailBox();

		VOID Activate();
	};

#endif

