/* **************************************************************************
*                                                                           *
*  FAT.H                                                                    *
*                                                                           *
*  25-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control del sistema de fitxers MS-DOS FAT                                *
*                                                                           *
************************************************************************** */

#ifndef _FAT_H
#define _FAT_H

#include "drivers\fs\private\fs.h"
#include "drivers\fs\private\fat\fatfcb.h"
#include "sys\mailbox.h"

#define FAT_DIRECTORY	TEXT( "\\FileSystem\\FAT" )
#define nFAT_DIRECTORY	TEXT( "FAT" )

/* Boot sector info (62 byte structure) */
#pragma option -a1
typedef struct _FATBoot
	{
	BYTE Jmp[ 3 ];
	CHAR OEMname[ 8 ];
	WORD wbps;
	BYTE cSecPerCluster;
	WORD wResSectors;
	BYTE cFATs;
	WORD wRootDirEnts;
	WORD wSectors;
	BYTE cMedia;
	WORD wSecPerFAT;
	WORD wSecPerTrack;
	WORD wHeads;
	DWORD dwHiddenSecs;
	DWORD dwHugeSecs;
	BYTE cDriveNum;
	BYTE cRsvd1;
	BYTE cBootSig;
	DWORD dwVolID;
	CHAR VolLabel[ 11 ];
	CHAR FileSysType[ 8 ];		/* 62 bytes */
	} TFATBoot, *PTFATBoot;

/* Directory Entry Record, 32 bytes */
typedef struct _DirEntry
	{
	CHAR cName[ 8 ];
	CHAR cExt[ 3 ];
	CHAR cAttr;
	CHAR cRsvd[ 10 ];
	WORD wTime;
	WORD wDate;
	WORD wStartCluster;
	DWORD dwFileSize;
	} TDirEntry, *PTDirEntry;
#pragma option -a4

_CLASSDEF( CFAT )

class CFAT : public CFileSystem
	{
		CFAT();

	protected:
		TFATBoot boot;
		DWORD dwfirstdatablock;

		DWORD SearchFAT( DWORD );
		BOOL SearchName( PSTR, DWORD, DWORD, PTDirEntry, DWORD& );

	public:
		CFAT( BYTE, PCdrvBlockDevice, PCsysMailBox, DWORD, DWORD );
		virtual ~CFAT();

		virtual PSTR Name();

		virtual PCGlobalFile OpenFile( PCkeProcess, const PSTR, BYTE, BYTE );
		virtual VOID CloseFile( PCkeProcess, PCGlobalFile );
		virtual DWORD ReadFile( PCkeProcess, PCGlobalFile, DWORD, DWORD, DWORD );
		virtual DWORD WriteFile( PCkeProcess, PCGlobalFile, DWORD, DWORD, DWORD );
		virtual VOID FlushFile( PCkeProcess, PCGlobalFile );
		virtual VOID Delete( PCkeProcess, const PSTR );
		virtual VOID Rename( PCkeProcess, const PSTR, const PSTR );
		virtual VOID SetFileSize( PCkeProcess, PCGlobalFile, DWORD );
		virtual PCGlobalFile Create( PCkeProcess, const PSTR, DWORD );
		virtual VOID SetAttributes( PCkeProcess, PCGlobalFile, DWORD );
		virtual DWORD GetAttributes( PCkeProcess, PCGlobalFile );

		VOID GetCreationTime( PCGlobalFile, PTFILETIME );
		VOID GetLastAccessTime( PCGlobalFile, PTFILETIME );
		VOID GetLastWriteTime( PCGlobalFile, PTFILETIME );
		VOID GetCreationDate( PCGlobalFile, PTFILEDATE );
		VOID GetLastAccessDate( PCGlobalFile, PTFILEDATE );
		VOID GetLastWriteDate( PCGlobalFile, PTFILEDATE );

		VOID SetCreationTime( PCGlobalFile, PTFILETIME );
		VOID SetLastAccessTime( PCGlobalFile, PTFILETIME );
		VOID SetLastWriteTime( PCGlobalFile, PTFILETIME );
		VOID SetCreationDate( PCGlobalFile, PTFILEDATE );
		VOID SetLastAccessDate( PCGlobalFile, PTFILEDATE );
		VOID SetLastWriteDate( PCGlobalFile, PTFILEDATE );

		BOOL DispatchMessage( TMSG& );
	};

#endif

