/* **************************************************************************
*                                                                           *
*  FCB.H                                                                    *
*                                                                           *
*  03-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control genric dels fitxers globals                                     *
*                                                                           *
************************************************************************** */

#ifndef _FCB_H
#define _FCB_H

#include "consts.h"
#include "kernel\list.h"
#include "kernel\pcb.h"

_CLASSDEF( CGlobalFile )

#include "drivers\fs\private\fs.h"
#include "drivers\fs\private\lock.h"

class CGlobalFile : public CkeDblListItem
	{
		CGlobalFile();

	protected:
		DWORD dwfilesize;
		DWORD dwdirblock;
		DWORD dwdirentry;
		DWORD dwfirstblock;
		PSTR sname;
		DWORD dwusecount;
		PCLock pfilelocks;
		PCFileSystem pfs;

	public:
		CGlobalFile( DWORD, DWORD, DWORD, DWORD, PCFileSystem, PSTR, BYTE );
		virtual ~CGlobalFile();

		virtual DWORD Read( PCkeProcess, DWORD, PVOID, DWORD );
		virtual DWORD Write( PCkeProcess, DWORD, PVOID, DWORD );
		virtual VOID Flush( PCkeProcess );

		virtual VOID Lock( PCkeProcess, DWORD, DWORD, DWORD );
		virtual VOID Unlock( PCkeProcess, DWORD, DWORD );

		VOID GetCreationTime( PTFILETIME );
		VOID GetLastAccessTime( PTFILETIME );
		VOID GetLastWriteTime( PTFILETIME );
		VOID GetCreationDate( PTFILEDATE );
		VOID GetLastAccessDate( PTFILEDATE );
		VOID GetLastWriteDate( PTFILEDATE );

		VOID SetCreationTime( PTFILETIME );
		VOID SetLastAccessTime( PTFILETIME );
		VOID SetLastWriteTime( PTFILETIME );
		VOID SetCreationDate( PTFILEDATE );
		VOID SetLastAccessDate( PTFILEDATE );
		VOID SetLastWriteDate( PTFILEDATE );

		DWORD GetAttributes( PCkeProcess );
		VOID SetAttributes( PCkeProcess, DWORD );

		DWORD FirstBlock();
		DWORD DirectoryBlock();
		DWORD DirectoryEntry();
		DWORD FileSize();
	};

#endif

