/* **************************************************************************
*                                                                           *
*  FS.H                                                                     *
*                                                                           *
*  21-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Sistema de fitxers genric                                               *
*                                                                           *
************************************************************************** */

#ifndef _FS_H
#define _FS_H

#include "consts.h"
#include "kernel\list.h"
#include "drivers\block\blockdev.h"
#include "drivers\block\cache.h"
#include "sys\mailbox.h"
#include "drivers\fs\filetime.h"

/* Partition Table Entry info. 16 bytes */
typedef struct _PartitionEntry
	{
	BYTE cBootable;
	BYTE cHeadStart;
	BYTE cSecStart;
	BYTE cCylStart;
	BYTE cType;
	BYTE cHeadEnd;
	BYTE cSecEnd;
	BYTE cCylEnd;
	DWORD dwFirstSector;
	DWORD dwSectorsTotal;
	} TPartitionEntry, *PTPartitionEntry;

_CLASSDEF( CFileSystem )

#include "drivers\fs\private\fcb.h"

#define MAX_FILESYSTEM_NAME		10

class CFileSystem : public CkeDblListItem
	{
	protected:
		BYTE cdrive;
		PCsysMailBox pmailbox;
		DWORD dwswapsize;
		DWORD dwfirstblock;
		DWORD dwblockcount;
		DWORD dwblocksize;
		PCdrvBlockDevice pdev;
		PCGlobalFile fcbs;
		PCdrvCache pcache;

		PCGlobalFile SearchFCB( PSTR );

	public:
		CFileSystem( BYTE, PCdrvBlockDevice, PCsysMailBox, DWORD, DWORD );
		virtual ~CFileSystem();

		virtual PSTR Name();

		virtual PCGlobalFile OpenFile( PCkeProcess, const PSTR, BYTE, BYTE ) = 0;
		virtual VOID CloseFile( PCkeProcess, PCGlobalFile ) = 0;
		virtual DWORD ReadFile( PCkeProcess, PCGlobalFile, DWORD, DWORD, DWORD ) = 0;
		virtual DWORD WriteFile( PCkeProcess, PCGlobalFile, DWORD, DWORD, DWORD ) = 0;
		virtual VOID FlushFile( PCkeProcess, PCGlobalFile ) = 0;
		virtual VOID Delete( PCkeProcess, const PSTR ) = 0;
		virtual VOID Rename( PCkeProcess, const PSTR, const PSTR ) = 0;
		virtual VOID SetFileSize( PCkeProcess, PCGlobalFile, DWORD ) = 0;
		virtual PCGlobalFile Create( PCkeProcess, const PSTR, DWORD ) = 0;
		virtual VOID SetAttributes( PCkeProcess, PCGlobalFile, DWORD ) = 0;
		virtual DWORD GetAttributes( PCkeProcess, PCGlobalFile ) = 0;

		virtual VOID GetCreationTime( PCGlobalFile, PTFILETIME ) = 0;
		virtual VOID GetLastAccessTime( PCGlobalFile, PTFILETIME ) = 0;
		virtual VOID GetLastWriteTime( PCGlobalFile, PTFILETIME ) = 0;
		virtual VOID GetCreationDate( PCGlobalFile, PTFILEDATE ) = 0;
		virtual VOID GetLastAccessDate( PCGlobalFile, PTFILEDATE ) = 0;
		virtual VOID GetLastWriteDate( PCGlobalFile, PTFILEDATE ) = 0;

		virtual VOID SetCreationTime( PCGlobalFile, PTFILETIME ) = 0;
		virtual VOID SetLastAccessTime( PCGlobalFile, PTFILETIME ) = 0;
		virtual VOID SetLastWriteTime( PCGlobalFile, PTFILETIME ) = 0;
		virtual VOID SetCreationDate( PCGlobalFile, PTFILEDATE ) = 0;
		virtual VOID SetLastAccessDate( PCGlobalFile, PTFILEDATE ) = 0;
		virtual VOID SetLastWriteDate( PCGlobalFile, PTFILEDATE ) = 0;

		virtual VOID GrowPageFile( DWORD );
		virtual VOID ShrinkPageFile( DWORD );
		virtual VOID ReadPageFile( DWORD, DWORD );
		virtual VOID WritePageFile( DWORD, DWORD );
		virtual DWORD PageFileSize();
	};

#endif

