/* **************************************************************************
*                                                                           *
*  Driver.H                                                                 *
*                                                                           *
*  12-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Base genrica per a qualsevol controlador de dispositiu                  *
*                                                                           *
************************************************************************** */

#ifndef _fnxDRIVER_H
#define _fnxDRIVER_H

#include "consts.h"
#include "fenix\type.h"
#include "fenix\mailbox.h"

_CLASSDEF( CfnxDriver )

#define MAX_DRIVER_NAME					64
#define MAX_DEVICE_NAME					64

class CfnxDriver : public CfnxType
	{
		CfnxDriver();

	protected:
		PVOID pobject;

	public:
		CfnxDriver( PSTR );
		virtual ~CfnxDriver();

		VOID DriverName( PSTR, DWORD );
		VOID DeviceName( PSTR, DWORD );
		BYTE Version();
		BYTE Level();

		PVOID MailBox();

		virtual VOID IOCtl( DWORD, DWORD );

		BOOL IsLocal();
		BOOL IsRemovable();
		BOOL HasMedia();
		DWORD CheckMedia();
		BOOL IsExclusive();

		VOID Lock();
		VOID Unlock();

		DWORD Read( DWORD, DWORD );
		DWORD Write( DWORD, DWORD );

		DWORD Status();
	};

#endif

