/* **************************************************************************
*                                                                           *
*  FUB.H                                                                    *
*                                                                           *
*  03-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control genric dels fitxers d'usuari                                    *
*                                                                           *
************************************************************************** */

#ifndef _fnxFUB_H
#define _fnxFUB_H

#include "consts.h"
#include "fenix\type.h"
#include "fenix\mailbox.h"
#include "drivers\fs\filetime.h"

_CLASSDEF( CfnxUserFile )

#include "sys\grantedr.h"

#define PROTECTION_ANY	0

#define READONLY			1
#define WRITEONLY			2
#define READWRITE			3

#define DENYALL			0
#define DENYWRITE			1
#define DENYREAD			2
#define DENYNONE			3

#define SEEK_SET		0
#define SEEK_CUR		1
#define SEEK_END		2

class CfnxUserFile : public CfnxType
	{
		CfnxUserFile();

	protected:
		PVOID pobject;
		PVOID pfsmail;
		DWORD dwstatus;

	public:
		CfnxUserFile( PSTR, BYTE, BYTE );
		virtual ~CfnxUserFile();

		DWORD Status();
		virtual DWORD Read( PVOID, DWORD );
		virtual DWORD Write( PVOID, DWORD );
		virtual DWORD Seek( LONG, BYTE );
		virtual VOID Flush();

		VOID Lock( DWORD, DWORD, DWORD );
		VOID Unlock( DWORD, DWORD );

		VOID GetCreationTime( PTFILETIME );
		VOID GetLastAccessTime( PTFILETIME );
		VOID GetLastWriteTime( PTFILETIME );
		VOID GetCreationDate( PTFILEDATE );
		VOID GetLastAccessDate( PTFILEDATE );
		VOID GetLastWriteDate( PTFILEDATE );

		VOID SetCreationTime( PTFILETIME );
		VOID SetLastAccessTime( PTFILETIME );
		VOID SetLastWriteTime( PTFILETIME );
		VOID SetCreationDate( PTFILEDATE );
		VOID SetLastAccessDate( PTFILEDATE );
		VOID SetLastWriteDate( PTFILEDATE );

		DWORD GetAttributes();
		VOID SetAttributes( DWORD );

		PVOID GetInternalPointer();
	};

#endif

