/* **************************************************************************
*                                                                           *
*  EFlags.H                                                                 *
*                                                                           *
*  21-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control dels EFlags                                                      *
*                                                                           *
************************************************************************** */

#ifndef _EFLAGS_H
#define _EFLAGS_H

#include "kernel\type.h"
#include "types.h"

#define NORMAL_FLAGS		0x202

typedef struct _TEFLAGS
	{
	union
		{
		DWORD Flags;
		struct
			{
			BYTE CF : 1;
			BYTE Reserved1_1 : 1;
			BYTE PF : 1;
			BYTE Reserved2_0 : 1;
			BYTE AF : 1;
			BYTE Reserved3_0 : 1;
			BYTE ZF : 1;
			BYTE SF : 1;
			BYTE TF : 1;
			BYTE IF : 1;
			BYTE DF : 1;
			BYTE OF : 1;
			BYTE IOPL : 2;
			BYTE NT : 1;
			BYTE Reserved4_0 : 1;
			BYTE RF : 1;
			BYTE VM : 1;
			WORD Reserved5_0 : 14;
			} Bits;
		} DWord;
	} TEFLAGS, *PTEFLAGS;

_CLASSDEF( CEFLAGS )

class CEFLAGS : public CkeType
	{
	protected:
		TEFLAGS flags;

	public:
		CEFLAGS( DWORD = 0L );
		virtual ~CEFLAGS();

		virtual BOOL ClassCheck( CUID Cuid );

		VOID Flags( DWORD );
		DWORD Flags();

		VOID GetHard();
      VOID SetHard();
      
		VOID Clear();

		BOOL CF();
		BOOL PF();
		BOOL AF();
		BOOL ZF();
		BOOL SF();
		BOOL TF();
		BOOL IF();
		BOOL DF();
		BOOL OF();
		BYTE IOPL();
		BOOL NT();
		BOOL RF();
		BOOL VM();

		VOID CF( BOOL );
		VOID PF( BOOL );
		VOID AF( BOOL );
		VOID ZF( BOOL );
		VOID SF( BOOL );
		VOID TF( BOOL );
		VOID IF( BOOL );
		VOID DF( BOOL );
		VOID OF( BOOL );
		VOID IOPL( BYTE );
		VOID NT( BOOL );
		VOID RF( BOOL );
		VOID VM( BOOL );
	};

#endif

