/* **************************************************************************
*                                                                           *
*  Heap.H                                                                   *
*                                                                           *
*  06-03-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control dels heaps local i global de l'aplicaci                         *
*                                                                           *
************************************************************************** */

#ifndef _keHEAP_H
#define _keHEAP_H

#include "kernel\type.h"

_KERNELEXP( CkeHeap )

#include "kernel\list.h"
#include "kernel\pcb.h"

#define HEAP_FREE			0L
#define HEAP_USER			1L

typedef struct _HeapItem *PTHeapItem;

typedef struct _HeapItem
	{
	CUID Type;
	DWORD dwSize;
	PTHeapItem pPrev, pNext;
	} THeapItem;

class CkeHeap : public CkeType
	{
	protected:
		DWORD dwsize;
		PTHeapItem pfirst;

	public:
		CkeHeap( PTHeapItem = NULL, DWORD = 0L );
		virtual ~CkeHeap();

		DWORD GetSize();
		VOID SetSize( DWORD = 0L );

		PTHeapItem GetFirstItem();
		VOID SetFirstItem( PTHeapItem );

		DWORD GetTotalFree();
		DWORD GetMaxFree();
		DWORD GetItemCount();
	};

#endif

