/* **************************************************************************
*                                                                           *
*  Interrup.H                                                               *
*                                                                           *
*  31-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Rutines de servei d'interrupci (del kernel)                             *
*                                                                           *
************************************************************************** */

#ifndef _INTERRUPT_H
#define _INTERRUPT_H

#include "consts.h"

#define SYSINT_DIVISION				0
#define SYSINT_TRAP					1
#define SYSINT_NMI					2
#define SYSINT_DEBUG					3
#define SYSINT_OVERFLOW				4
#define SYSINT_BOUND					5
#define SYSINT_OPCODE				6
#define SYSINT_MATHPROCESSOR		7
#define SYSINT_DOUBLEFAULT			8
#define SYSINT_MATHPROCSEGMENT	9
#define SYSINT_BADTSS			  	10
#define SYSINT_SEGMENT				11
#define SYSINT_STACK					12
#define SYSINT_GENERALPROT			13
#define SYSINT_PAGE					14
#define SYSINT_MATHPROCERROR		16
#define SYSINT_UNALIGNMENT			17

#define SYSINT_SYSCALL				0x30

VOID Reserved( BYTE );
VOID Division();
VOID Trap();
VOID NMI();
VOID DebugInt();
VOID Overflow();
VOID Bound();
VOID Opcode();
VOID MathProcessor();
VOID DoubleFault();
VOID MathProcSegment();
VOID BadTSS( DWORD );
VOID Segment( DWORD );
VOID StackException( DWORD );
VOID GPFault( DWORD );
VOID PageFault( DWORD );
VOID MathProcError();
VOID Unalignment();
DWORD SystemCall( DWORD, DWORD, DWORD );

#endif

