/* **************************************************************************
*                                                                           *
*  Kernel.H                                                                 *
*                                                                           *
*  29-04-97                                                    BUILD:0007   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Kernel del sistema Eros ver 0.0.1 - Declaracions globals                 *
*                                                                           *
************************************************************************** */

#ifndef _keKERNEL_H
#define _keKERNEL_H

#include "kernel\type.h"
#include "kernel\eflags.h"
#include "kernel\callback.h"
#include "kernel\region.h"
#include "kernel\timer.h"
#include "kernel\vad.h"
#include "kernel\boxdef.h"

#define KERNEL_ARCH_INTEL386				0x00000001
#define KERNEL_ARCH_INTEL486				0x00000002
#define KERNEL_ARCH_INTELPENTIUM			0x00000003
#define KERNEL_ARCH_INTELPENTIUMPRO		0x00000004

#define KERNEL_TIMERS			32

typedef struct _Timer
	{
	PCkeTimer pTimer;
	LONG lMillisecs;
	} TTimer, *PTTimer;

_KERNELEXP( CkeKernel )

#include "aal\aal.h"

class CkeKernel : public CkeType
	{
	protected:
		TTimer timer[ KERNEL_TIMERS ];
		BYTE cquantum;
		PCkeVAD pvad;

	public:
		CkeKernel();
		virtual ~CkeKernel();

		virtual BOOL ClassCheck( CUID Cuid );

		DWORD Version();
		DWORD Architecture();

		virtual BOOL Scheduler( BOOL = FALSE );

		VOID ExcludePhysicalMemoryRegion( PVOID, PCkeRegion );
		VOID IncludePhysicalMemoryRegion( PVOID, DWORD );

		VOID Shutdown();

		VOID EOIHelper( BYTE );

		VOID MemCopy( PBYTE, PBYTE, DWORD );
		VOID MemMove( PBYTE, PBYTE, DWORD );
		VOID MemSet( PBYTE, DWORD, BYTE );
		LONG MemCompare( PBYTE, PBYTE, DWORD );

		BYTE InByte( WORD );
		WORD InWord( WORD );
		DWORD InDWord( WORD );
		VOID InWords( WORD, PBYTE, DWORD );
		VOID OutByte( WORD, BYTE );
		VOID OutWord( WORD, WORD );
		VOID OutDWord( WORD, DWORD );
		VOID OutWords( WORD, PBYTE, DWORD );

		VOID AddTimer( PCkeTimer );
		VOID DestroyTimer( PCkeTimer );
		VOID TimerTick( LONG, BOOL );

		VOID Idle();
		DWORD IdleTime();

		VOID MapThreadSpace( PCkeThread );
		VOID MapProcessSpace( PCkeProcess );
		VOID UnmapSpace();

		PCkeVAD VAD();
	};

#endif

