/* **************************************************************************
*                                                                           *
*  Page.H                                                                   *
*                                                                           *
*  10-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control de les pgines de memoria                                        *
*                                                                           *
************************************************************************** */

#ifndef _PAGE_H
#define _PAGE_H

#include "kernel\type.h"

typedef struct _Page
	{
	union
		{
		struct
			{
			BYTE Flags1;
			BYTE Flags2;
			} Bytes;
		struct
			{
			BYTE Pres : 1;
			BYTE ReadWrite : 1;
			BYTE UserSuper : 1;
			BYTE Reserved1_0 : 1;
			BYTE PCD : 1;
			BYTE Accessed : 1;
			BYTE Dirty : 1;
			BYTE P4MB : 1;			// Pentium+
			BYTE Reserved2_0 : 1;
			BYTE System0 : 1;
			BYTE System1 : 1;
			BYTE System2 : 1;
			BYTE PageDirLo : 4;
			} Bits;
		} LoWord;
	WORD PageDirHi;
	} TPage, *PTPage;

_CLASSDEF( CPage )

class CPage : public CkeType
	{
	protected:
		PTPage ppag;

	public:
		CPage( PTPage = NULL );
		virtual ~CPage();

		virtual BOOL ClassCheck( CUID Cuid );

		PTPage Page();
		VOID Page( PTPage );

		VOID Clear();

		BOOL Present();
		BOOL Writeable();
		BOOL User();
		BOOL Accessed();
		BOOL Dirty();
		BOOL Readable();
		BOOL Executable();
		BOOL COW();
		DWORD PageAddress();

		BOOL PCD();
		BOOL Page4MB();

		VOID Present( BOOL );
		VOID Writeable( BOOL );
		VOID User( BOOL );
		VOID Accessed( BOOL );
		VOID Dirty( BOOL );
		VOID COW( BOOL );
		VOID Readable( BOOL );
		VOID Executable( BOOL );
		VOID PageAddress( DWORD );

		VOID Page4MB( BOOL );
		VOID PCD( BOOL );
	};

#endif
