/* **************************************************************************
*                                                                           *
*  PageDir.H                                                                *
*                                                                           *
*  21-01-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control de la memria (proporciona independncia del proc.)*
*                                                                           *
************************************************************************** */

#ifndef _kePAGEDIR_H
#define _kePAGEDIR_H

#include "kernel\type.h"

_KERNELEXP( CkePageDirectory )

#include "kernel\tpags.h"
#include "kernel\region.h"
#include "kernel\pcb.h"
#include "kernel\vad.h"

#define VA_NONE		0x00000000L		// !!!
#define VA_READ		0x00000001L
#define VA_WRITE		0x00000002L
#define VA_EXEC		0x00000004L
#define VA_ALL			0x00000007L
#define VA_USER		0x20000000L
#define VA_DMA			0x40000000L		// ??
#define VA_COW			0x80000000L

class CkePageDirectory : public CkeType
	{
		CkePageDirectory();

	protected:
		DWORD dwpdbr, dwlogpdbr;
		PCTPage pphyspagedir;
		PCTPage plogpagedir;
		PCkeProcess pproc;
		PCkeVAD pvad;

	public:
		CkePageDirectory( PCkeProcess );
		virtual ~CkePageDirectory();

		virtual BOOL ClassCheck( CUID Cuid );

		DWORD PDBR();

		virtual BOOL TryToMapRegion( PCkeRegion, PVOID, DWORD = NULL );
		virtual PVOID MapRegion( PCkeRegion, DWORD = NULL );
		virtual VOID UnmapRegion( PCkeRegion );
		virtual VOID Commit( PVOID, DWORD );
	};

#endif

