/* **************************************************************************
*                                                                           *
*  PAT.H                                                                    *
*                                                                           *
*  15-03-97                                                    BUILD:0004   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control de la memria fsica                                             *
*                                                                           *
************************************************************************** */

#ifndef _kePAT_H
#define _kePAT_H

#include "kernel\type.h"
#include "kernel\page.h"
#include "kernel\pcb.h"
#include "kernel\nfuhelp.h"

#define PAGE_SIZE			4096
#define PAGE_BITS			12

#define AGE_BITS			7
#define MIN_AGE			255
#define MAX_USAGE			255

// Definicions per a la variable cOwner
#define FREE_PAGE				0
#define SYSTEM_PAGE			1
#define CACHE_PAGE			2
#define USER_PAGE				3
#define DMA_PAGE				4
#define RESERVED_PAGE		5

// Definicions per a la variable cFlags
#define INITIALIZED_PAGE	0x80
#define LOCKED_PAGE			0x40

// Aquesta es l'estructura d'una entrada a la taula de pgines fsiques
// No volem que ocups molta memria i tambe la volem aliniada
// a 4 bytes o millor a 8.
typedef struct _PAT
	{
	PCkeRegion pRegion;
	DWORD dwOffset;	// offset de la pgina fsica dins la regi
	PCNFUHelper pHelper;
	BYTE dwAge;	// s poc? -BUG
	BYTE wUsageCount;	// s poc! -BUG
	BYTE cFlags;
	BYTE cOwner;
	} TPAT, *PTPAT;

#ifdef __WIN32__
_KERNELEXP( CkePAT )

class CkePAT : public CkeType
	{
		CkePAT();

	protected:
		PTPAT ptable;
		DWORD dwsize;
		BOOL bspecial;

	public:
		CkePAT( DWORD, DWORD, BOOL = FALSE );
		virtual ~CkePAT();

		virtual BOOL ClassCheck( CUID );

		VOID Clear();

		VOID ClearPage( DWORD, PDWORD );
		DWORD AllocPage( BYTE, PTPage = NULL, DWORD = NULL, PCkeRegion = NULL, DWORD = NULL, BOOL = FALSE );
		VOID FreePage( DWORD );

		VOID MakePage( DWORD, PCkeRegion, DWORD, BYTE = RESERVED_PAGE );

		BOOL IsRegionFree( DWORD, DWORD );
		BOOL IsRegionReserved( DWORD, DWORD );

		PCkeRegion Region( DWORD );
		DWORD Offset( DWORD );
		DWORD Age( DWORD );
		WORD UsageCount( DWORD );
		BYTE Owner( DWORD );
		BYTE Flags( DWORD );

		BOOL IsFreePage( DWORD );
		BOOL IsSystemPage( DWORD );
		BOOL IsCachePage( DWORD );
		BOOL IsUserPage( DWORD );
		BOOL IsDMAPage( DWORD );
		BOOL IsReservedPage( DWORD );

		VOID Region( DWORD, PCkeRegion );
		VOID Offset( DWORD, DWORD );
		VOID Age( DWORD, BYTE );
		VOID UsageCount( DWORD, WORD );
		VOID Owner( DWORD, BYTE );
		VOID Flags( DWORD, BYTE );

		VOID UsePage( DWORD );
		VOID LetPage( DWORD );

		VOID SetSystemPage( DWORD );
		VOID SetCachePage( DWORD );
		VOID SetUserPage( DWORD );
		VOID SetDMAPage( DWORD );
		VOID SetReservedPage( DWORD );

		VOID MakeOld( DWORD );
		VOID MakeYoung( DWORD );

		VOID AddAge( DWORD, BOOL );

		DWORD CountFreePages();
		DWORD CountUsedPages();
	};
#endif // __WIN32__

#endif

