/* **************************************************************************
*                                                                           *
*  Resource.H                                                               *
*                                                                           *
*  08-01-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica per a tots els recursos                                  *
*                                                                           *
************************************************************************** */

#ifndef _keRESOURCE_H
#define _keRESOURCE_H

#include "kernel\type.h"

_KERNELEXP( CkeResource )
_KERNELEXP( CkeThread )	/* Ho necessitem aqu */
_KERNELEXP( CkeThreadList ) /* Ho necessitem aqu */

#include "kernel\object.h"
#include "kernel\list.h"

#define STATUS_UNREADY 		0x01	/* El recurs s'est preparant */
#define STATUS_READY			0x02	/* El recurs est preparat */
#define STATUS_BLOCKED		0x04	/* El recurs est esperant */
#define STATUS_ZOMBIE 		0x08	/* El recurs s'est destrunt */
#define STATUS_RUNNING		0x10	/* El recurs (flux/procs) s'est executant */

class CkeResource : public CkeObject
	{
		CkeResource();

	protected:
		BYTE cstatus;
		LONG lwaitcalls;
		PCkeThread pthread;
		PCkeThreadList pwaiting;

	public:
		CkeResource( PCkeObject, PSTR = NULL, BOOL = FALSE );
		virtual ~CkeResource();

		virtual BOOL ClassCheck( CUID Cuid );

		virtual BYTE Status();

		virtual VOID Status( BYTE );

		virtual VOID Release();
		virtual VOID Wait();
	};

#endif

