/* **************************************************************************
*                                                                           *
*  System.H                                                                 *
*                                                                           *
*  15-03-97                                                    BUILD:0004   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe que controla la informaci principal del sistema                  *
*                                                                           *
************************************************************************** */

#ifndef _keSYSTEM_H
#define _keSYSTEM_H

#include "kernel\thread.h"
#include "kernel\gdt.h"
#include "kernel\idt.h"
#include "kernel\pat.h"
#include "kernel\objdir.h"
#include "aal\aal.h"
#include "kernel\heap.h"
#include "kernel\debug.h"
#include "kernel\intnum.h"

#define MACHINE_TYPE_i386				0x00000003L
#define MACHINE_TYPE_i486				0x00000004L
#define MACHINE_TYPE_iPENTIUM			0x00000005L
#define MACHINE_TYPE_iPENTIUMPRO		0x00000006L

#define FIRSTMEG_REGION_NAME	TEXT( "FirstMeg" )
#define KERNEL_REGION_NAME		TEXT( "Kernel" )
#define AAL_REGION_NAME			TEXT( "AAL" )
#define SYS_REGION_NAME			TEXT( "Sys" )
#define SYSSTACK_REGION_NAME	TEXT( "SysStack" )
#define SYSHEAP_REGION_NAME	TEXT( "SysHeap" )
#define PAGE_REGION_NAME		TEXT( "Page" )
#define PAT_REGION_NAME			TEXT( "PAT" )

#define FIRSTMEG_REGION_ADDR	0x00000000
#define KERNEL_REGION_ADDR		0x80000000
#define AAL_REGION_ADDR			0x80100000
#define SYS_REGION_ADDR			0x80200000
#define SYSSTACK_REGION_ADDR	0x80300000
#define SYSHEAP_REGION_ADDR	0x80400000
#define PAGE_REGION_ADDR		0xc0000000
#define PAT_REGION_ADDR			0xff000000

#define FIRSTMEG_REGION_SIZE	0x00100000
#define KERNEL_REGION_SIZE		0x00100000
#define AAL_REGION_SIZE			0x00100000
#define SYS_REGION_SIZE			0x00100000
#define SYSSTACK_REGION_SIZE	0x00100000
#define SYSHEAP_REGION_SIZE	0x00100000
#define PAGE_REGION_SIZE		0x3f000000
#define PAT_REGION_SIZE			0x01000000

_KERNELEXP( CkeSystem )

class CkeSystem : public CkeType
	{
		static BOOL bmade;
		DWORD dwerror;

		VOID initPAT();
		VOID initHEAP();
		VOID initIDT();
		VOID RegisterDump( CkeConsole& );

	protected:
		PCGDT pgdt;
		PCIDT pidt;
		PCkePAT ppat;
		PCaalAAL paal;
		DWORD dwphysicalmem;
		DWORD dwmachinetype;
		DWORD dwtimertick;
		DWORD dwvinttable[ MAX_VIRTUAL_INT ];
		PCkeThread prun;
		PCkeThreadList pready;
		PCkeThread pall;
		PCkeObjectDirectory pobjdir;
		PCkeHeap psysheap;
		CkeConsole syscon;
		CkeDebug debugger;

	public:
		CkeSystem();
		virtual ~CkeSystem();

		virtual BOOL ClassCheck( CUID Cuid );

		DWORD PhysicalMemory();
		PCkeThread Running();
		PCkeThread Ready();
		PCkeThread FirstThread();
		PCGDT GDT();
		PCkeDebug Debug();

		virtual VOID Running( PCkeThread, BOOL = FALSE );
		virtual VOID Ready( PCkeThread );
		virtual VOID AddThread( PCkeThread );

		virtual PCkeObject FindObject( PSTR );

		DWORD PageSize();

		DWORD MachineType();

		DWORD TickTime();
		VOID AddTickTime( DWORD );

		PCkePAT PAT();
		PCkeHeap Heap();

		VOID Error( DWORD );
		DWORD Error();

		PCaalAAL AAL();

		VOID Panic( PSTR );

		DWORD RegisterInterrupt( BYTE, DWORD );
		VOID UnregisterInterrupt( BYTE, DWORD );
		DWORD Interrupt( BYTE );

		VOID CopyPageDirectory( PVOID );

		PCkeConsole Console();

		DWORD MapPT( DWORD, PCkePAT = NULL );
		VOID UnmapPT( DWORD );

		PCkeThreadList ReadyList();
	};

#endif

