/* **************************************************************************
*                                                                           *
*  Thread.H                                                                 *
*                                                                           *
*  14-01-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe CThread per al control dels fluxos de cada procs                 *
*                                                                           *
************************************************************************** */

#ifndef _keTHREAD_H
#define _keTHREAD_H

#include "kernel\type.h"

_KERNELEXP( CkeThread )
_KERNELEXP( CkeThreadList )

#include "kernel\resource.h"
#include "kernel\pcb.h"
#include "kernel\tss.h"

class CkeThreadList : public CkeLIFOList
	{
	protected:
	public:
		CkeThreadList();
		virtual ~CkeThreadList();

		virtual VOID Add( PCkeListItem );
	};

class CkeThread : public CkeResource
	{
		CkeThread();

	protected:
		PCkeThread psameprocnext, psameprocprev;
		PCkeThread pallnext, pallprev;
		PCkeProcess pproc;
		PCTSS ptss;
		DWORD dwusertime;
		DWORD dwkerneltime;
		DWORD dwcreationtime;
		BYTE ccurrentpriority;
		DWORD dwexitstatus;
		DWORD dwerrorcode;
		BYTE clastquantum;

	public:
		CkeThread( DWORD, DWORD, DWORD, PCkeProcess, PCkeObject, PSTR = NULL, BOOL = FALSE );
		virtual ~CkeThread();

		virtual BOOL ClassCheck( CUID Cuid );

		DWORD ErrorCode();

		VOID AddUserTime( DWORD = 1L );
		VOID AddKernelTime( DWORD = 1L );

		DWORD KernelTime();
		DWORD UserTime();
		
		VOID ErrorCode( DWORD );

		PCkeThread NextInProc();
		PCkeThread PrevInProc();
		PCkeThread NextInAll();
		PCkeThread PrevInAll();

		VOID NextInProc( PCkeThread );
		VOID PrevInProc( PCkeThread );
		VOID NextInAll( PCkeThread );
		VOID PrevInAll( PCkeThread );

		BYTE Priority();
		VOID Priority( BYTE );

		PCkeProcess Process();
		DWORD CreationTime();

		DWORD ExitStatus();
		VOID Exit( DWORD );

		BYTE LastQuantum();
		VOID LastQuantum( BYTE );

		PCTSS TSS();
	};

#endif

