/* **************************************************************************
*                                                                           *
*  TSS.H                                                                    *
*                                                                           *
*  14-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control dels TSSs                                                        *
*                                                                           *
************************************************************************** */

#ifndef _TSS_H
#define _TSS_H

#include "kernel\type.h"
#include "kernel\descr.h"
#include "kernel\ldt.h"

typedef struct _TTSS
	{
	WORD	BackLink;
	WORD	Reserved1_0;
	DWORD	ESP0;
	WORD	SS0;
	WORD	Reserved2_0;
	DWORD	ESP1;
	WORD	SS1;
	WORD	Reserved3_0;
	DWORD	ESP2;
	WORD	SS2;
	WORD	Reserved4_0;
	DWORD PDBR;				// CR3
	DWORD EIP;
	DWORD EFLAGS;
	DWORD EAX;
	DWORD ECX;
	DWORD EDX;
	DWORD EBX;
	DWORD ESP;
	DWORD EBP;
	DWORD ESI;
	DWORD EDI;
	WORD	ES;
	WORD	Reserved5_0;
	WORD	CS;
	WORD	Reserved6_0;
	WORD	SS;
	WORD	Reserved7_0;
	WORD	DS;
	WORD	Reserved8_0;
	WORD	FS;
	WORD	Reserved9_0;
	WORD	GS;
	WORD	Reserved10_0;
	WORD	LDT;
	WORD	Reserved11_0;
	union
		{
		struct
			{
			WORD Reserved_0;
			} Bytes;
		struct
			{
			BYTE T : 1;
			} Bits;
		} Flags;
	WORD	IOMap;
	} TTSS, *PTTSS;

#define TSS_FREE		0
#define TSS_BUSY		1

_CLASSDEF( CTSS )

class CTSS : public CkeType
	{
	protected:
		PTTSS ptss;
		PTDescriptor pgdt;
		BOOL binitialized;

	public:
		CTSS( PTDescriptor = NULL );
		virtual ~CTSS();

		virtual BOOL ClassCheck( CUID Cuid );

		VOID GDT( PTDescriptor );
		PTDescriptor GDT();

		VOID SetHard();
		VOID GetHard();

		VOID Clear();

		BOOL	Busy();

		VOID	Set( BOOL );		// Free-Busy

		WORD	BackLink();
		VOID	GetStack( BYTE, WORD&, DWORD& );
		DWORD	PDBR();
		VOID	GetCSEIP( WORD&, DWORD& );
		DWORD EFLAGS();
		DWORD EAX();
		DWORD EBX();
		DWORD ECX();
		DWORD EDX();
		DWORD ESP();
		DWORD EBP();
		DWORD EDI();
		DWORD ESI();
		WORD	ES();
		WORD	SS();
		WORD	DS();
		WORD	FS();
		WORD	GS();
		WORD	LDT();
		BOOL	T();
		WORD	IOMap();

		VOID	BackLink( WORD );
		VOID	SetStack( BYTE, WORD, DWORD );
		VOID	PDBR( DWORD );
		VOID	SetCSEIP( WORD, DWORD );
      VOID	SetSSESP( WORD, DWORD );
		VOID	EFLAGS( DWORD );
		VOID	EAX( DWORD );
		VOID	EBX( DWORD );
		VOID	ECX( DWORD );
		VOID	EDX( DWORD );
		VOID	ESP( DWORD );
		VOID	EBP( DWORD );
		VOID	EDI( DWORD );
		VOID	ESI( DWORD );
		VOID	ES( WORD );
		VOID	SS( WORD );
		VOID	DS( WORD );
		VOID	FS( WORD );
		VOID	GS( WORD );
		VOID	LDT( WORD );
		VOID	T( BOOL );
      VOID	IOMap( WORD );
	};

#endif

