/* **************************************************************************
*                                                                           *
*  String.CPP                                                               *
*                                                                           *
*  14-03-97                                                    BUILD:0005   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Manipulaci de cadenes de carcters                                      *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "string.h"
#include <stdarg.h>

// *********************************** DEFINES
#define S_SIZE		  255			/* llargada mxima d'una cadena */

CHAR UpperTable[] =	// Taula de conversi de minscules a majscules
	{
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
	0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
	0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
	0x60, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
	0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
	0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
	0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
	0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
	0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
	0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
	0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
	0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
	0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
	0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
	0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff
	};

long _ffmt( PSTR, PSTR, PLONG );

// Aquestes funcions sn ben conegudes per tots els programadors de C/C++

PCHAR strchr( PSTR str, CHAR chr )
	{
	while( *str && *str != chr )
		str++;

	if( *str == chr )
		return str;
	else
		return NULL;
	}

DWORD strlen( PSTR str )
	{
	DWORD count = 0L;

	while( *str )
		{
		count++;
		str++;
		}

	return count;
	}

LONG strcmp( PSTR str1, PSTR str2 )
	{
	while( *str1 && *str2 && *str1 == *str2 )
		{
		str1++;
		str2++;
		}

	if( *str1 == *str2 )
		return 0;

	if( *str1 < *str2 )
		return -1;
	else
		return 1;
	}

LONG strncmp( PSTR str1, PSTR str2, DWORD dwSize )
	{
	while( dwSize && *str1 && *str2 && *str1 == *str2 )
		{
		str1++;
		str2++;
		dwSize--;
		}

	if( dwSize == 0 )
		return 0;

	if( *str1 < *str2 )
		return -1;
	else
		return 1;
	}

DWORD strcpy( PSTR str1, PSTR str2 )
	{
	DWORD dwcount = 0;

	while( *str2 )
		{
		*str1 = *str2;
		str1++;
		str2++;
		}

	*str1 = 0;

	return dwcount;
	}

DWORD strncpy( PSTR str1, PSTR str2, DWORD dwSize )
	{
	DWORD dwcount = 0;

	while( dwSize && *str2 )
		{
		*str1 = *str2;
		str1++;
		str2++;
		dwSize--;
		dwcount++;
		}

	*str1 = 0;
	
	return dwcount;
	}

void ltoa( PSTR sString, DWORD dwValue, BYTE /* cBase */ )
	{
	CHAR table[] = "0123456789ABCDEF";

	for( WORD pos = 0; pos < 9; pos++ )
		sString[ pos ] = 0;

	LONG count = 32;

	while( count )
		{
		count = count - 4;
		DWORD dwdigit = dwValue & (0xf << count);

		if( count )
			*(sString+7-count/4) = table[ dwdigit >> count ];
		else
			*(sString+7) = table[ dwValue & 0xf ];
		}
	}

/*********************************************
* Determine if a character is a numeric digit
**********************************************/
BOOL isdigit( CHAR chr )
	{
	if( chr >= '0' && chr <= '9' )
		return 1;

	return 0;
	}

BOOL isalpha( CHAR chr )
	{
	if( chr >= ' ' && chr <= 128 )
		return 1;

	return 0;
	}

/*************************************************************
 This does the actual parsing of the format and also moves to
 the next arg(s) in the list from the passed in arg pointer.
 The number of chars written is returned (not incl \0).
**************************************************************/
long _ffmt( PSTR outptr, PSTR fmt, PLONG argptr )
{
CHAR numstk[33], *ptr, zero, chr;
LONG justify, minus;
unsigned long width, value, i, total;

	total = 0;
	while((chr = *fmt++) != 0 )
	{
		if(chr == '%')
		{					/* format code */
			chr = *fmt++;
				ptr = &numstk[32];
			*ptr = 0;
			justify = minus = 0;
			width = value = i = 0;
			zero = ' ';
			if(chr == '-')
			{				/* left justify */
				--justify;
				chr = *fmt++;
			}
			if(chr == '0')					/* leading zeros */
				zero = '0';
			while(isdigit(chr))
			{			/* field width specifier */
				width = (width * 10) + (chr - '0');
				chr = *fmt++;
			}

//			value = *--argptr;				/* get parameter value */
			value = *argptr;				/* get parameter value */
			argptr++;

			switch(chr)
			{
				case 'd' :					/* decimal number */
					if(value & 0x80000000L)
					{
						value = -value;
						++minus;
					}
				case 'u' :					/* unsigned number */
					i = 10;
					break;
				case 'x' :					/* hexidecimal number */
				case 'X' :
					i = 16;
					break;
				case 'o' :					/* octal number */
					i = 8;
					break;
				case 'b' :					/* binary number */
					i = 2;
					break;
				case 'c' :					/* character data */
					*--ptr = (char) value;
					break;
				case 's' :					/* string */
					ptr = (PSTR) value;			/* value is ptr to string */
					break;
				default:					/* all others */
					*--ptr = chr;
//					++argptr;				/* backup to last arg */
					--argptr;				/* backup to last arg */
			}

			if(i)		/* for all numbers, generate the ASCII string */
				do
				{
					if((chr = (char) ((value % i) + '0')) > '9')
						chr += (CHAR) 7;
					*--ptr = chr;
				}
				while(value /= i);

			/* output sign if any */

			if(minus)
			{
				*outptr++ = '-';
				++total;
				if(width)
					--width;
			}

			/* pad with 'zero' value if right justify enabled  */

			if(width && !justify)
			{
				for(i = strlen(ptr); i < width; ++i)
					*outptr++ = zero;
					++total;
			}

			/* move in data */

			i = 0;
			value = width - 1;

			while((*ptr) && (i <= value))
			{
				*outptr++ = *ptr++;
				++total;
				++i;
			}

			/* pad with 'zero' value if left justify enabled */

			if(width && justify)
			{
				while(i < width)
				{
					*outptr++ = zero;
					++total;
					++i;
				}
			}
		}
		else
		{
			/* not format char, just move into string  */
			*outptr++ = chr;
			++total;
		}
	}

	*outptr = 0;
	return total;
}

/************************************
	 Formatted print to string s
*************************************/

long sprintf( PSTR s, PSTR fmt, ...)
	{
	va_list ap;

	va_start( ap, fmt );			/* set up ap pointer */

	long total = _ffmt( s, fmt, (PLONG) ap );

	va_end( ap );

	return total;
	}

VOID strcat( PSTR dest, PSTR source )
	{
	while( *dest )
		dest++;

	while( *source )
		{
		*dest = *source;
		dest++;
		source++;
		}

	*dest = 0;
	}

VOID toupper( PSTR str )
	{
	while( *str )
		{
		*str = UpperTable[ *str ];
		str++;
		}
	}

