/* **************************************************************************
*                                                                           *
*  List.H                                                                   *
*                                                                           *
*  30-01-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classes genriques per a llistes i llistes doblement encadenades         *
*                                                                           *
************************************************************************** */

#ifndef _sysLIST_H
#define _sysLIST_H

#include "sys\type.h"

_KERNELEXP( CsysFIFOList )
_KERNELEXP( CsysLIFOList )
_KERNELEXP( CsysListItem )
_KERNELEXP( CsysDblListItem )

class CsysListItem : virtual public CsysType
	{
	protected:
		PCsysListItem pnext;

	public:
		CsysListItem( PCsysListItem = NULL );
		virtual ~CsysListItem();

		virtual BOOL ClassCheck( CUID Cuid );

		virtual PCsysListItem GetNext();
		virtual VOID SetNext( PCsysListItem = NULL );
	};

class CsysDblListItem : public CsysListItem
	{
	protected:
		PCsysDblListItem pprev;

	public:
		CsysDblListItem( PCsysDblListItem = NULL, PCsysDblListItem = NULL );
		virtual ~CsysDblListItem();

		virtual BOOL ClassCheck( CUID Cuid );

		virtual PCsysDblListItem GetPrev();
		virtual VOID SetPrev( PCsysDblListItem = NULL );
	};

class CsysLIFOList : public CsysType
	{
	protected:
		PCsysListItem pfirst;
		DWORD dwelements;

	public:
		CsysLIFOList();
		virtual ~CsysLIFOList();

		virtual PCsysListItem Get();
		virtual VOID Add( PCsysListItem );
		virtual VOID Delete( PCsysListItem );
	};

class CsysFIFOList : public CsysLIFOList
	{
	protected:
		PCsysListItem plast;

	public:
		CsysFIFOList();
		virtual ~CsysFIFOList();

		virtual PCsysListItem Get();
		virtual VOID Add( PCsysListItem );
		virtual VOID Delete( PCsysListItem );
	};

#endif
