/* **************************************************************************
*                                                                           *
*  AcToken.H                                                                *
*                                                                           *
*  03-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica de seguretat per a usuaris i grups                       *
*                                                                           *
************************************************************************** */

#ifndef _ACTOKEN_H
#define _ACTOKEN_H

#include "kernel\type.h"

_CLASSDEF( CAccessToken )

#define MAX_LONG_NAME			128
#define MAX_CALL_NAME			20

#define PRIVILEGE_NONE							0x00000000L
#define PRIVILEGE_LOCK_MEMORY					0x00000004L
#define PRIVILEGE_INCREASE_QUOTA				0x00000008L
#define PRIVILEGE_LOAD_DRIVER					0x00000200L
#define PRIVILEGE_SYSTEMTIME					0x00000800L
#define PRIVILEGE_INCREASE_BASE_PRIORITY	0x00002000L
#define PRIVILEGE_CREATE_PAGEFILE			0x00004000L
#define PRIVILEGE_BACKUP						0x00010000L
#define PRIVILEGE_RESTORE						0x00020000L
#define PRIVILEGE_SHUTDOWN						0x00040000L
#define PRIVILEGE_DEBUG							0x00080000L
#define PRIVILEGE_AUDIT							0x00100000L

class CAccessToken : public CkeType
	{
	protected:
		CHAR slongname[ MAX_LONG_NAME ];
		CHAR scallname[ MAX_CALL_NAME ];
		DWORD dwprivileges;
		DWORD dwnotprivileges;

	public:
		CAccessToken( PSTR = NULL, PSTR = NULL, DWORD = NULL, DWORD = NULL );
		virtual ~CAccessToken();

		virtual BOOL ClassCheck( CUID );

		PSTR LongName();
		PSTR Name();

		BOOL None();
		BOOL LockMemory();
		BOOL IncreaseQuota();
		BOOL LoadDriver();
		BOOL SystemTime();
		BOOL IncreaseBasePriority();
		BOOL CreatePageFile();
		BOOL Backup();
		BOOL Restore();
		BOOL Shutdown();
		BOOL Debug();
		BOOL Audit();

		VOID LongName( PSTR );
		VOID Name( PSTR );

		VOID None( BOOL );
		VOID LockMemory( BOOL );
		VOID IncreaseQuota( BOOL );
		VOID LoadDriver( BOOL );
		VOID SystemTime( BOOL );
		VOID IncreaseBasePriority( BOOL );
		VOID CreatePageFile( BOOL );
		VOID Backup( BOOL );
		VOID Restore( BOOL );
		VOID Shutdown( BOOL );
		VOID Debug( BOOL );
		VOID Audit( BOOL );
	};

#endif

