.386p

  INCLUDE EXTENSOR.INC

    EXTRN SELECTOR_CS:ABS,SELECTOR_DS:ABS,SELECTOR_SS:ABS
    EXTRN SELECTOR_VIDEO:ABS,FIN_PILA:DWORD
    EXTRN SELECTOR_CS32:ABS,SELECTOR_GDT:ABS,SELECTOR_IDT:ABS
    EXTRN SELECTORES_SISTEMA:ABS
    EXTRN _Ext_EXCEPCION_0_PROC:QWORD,_Ext_EXCEPCION_1_PROC:QWORD
    EXTRN _Ext_EXCEPCION_2_PROC:QWORD,_Ext_EXCEPCION_3_PROC:QWORD
    EXTRN _Ext_EXCEPCION_4_PROC:QWORD,_Ext_EXCEPCION_5_PROC:QWORD
    EXTRN _Ext_EXCEPCION_6_PROC:QWORD,_Ext_EXCEPCION_7_PROC:QWORD
    EXTRN _Ext_EXCEPCION_8_PROC:QWORD,_Ext_EXCEPCION_9_PROC:QWORD
    EXTRN _Ext_EXCEPCION_10_PROC:QWORD,_Ext_EXCEPCION_11_PROC:QWORD
    EXTRN _Ext_EXCEPCION_12_PROC:QWORD,_Ext_EXCEPCION_13_PROC:QWORD
    EXTRN _Ext_EXCEPCION_14_PROC:QWORD,_Ext_EXCEPCION_15_PROC:QWORD
    EXTRN _Ext_EXCEPCION_16_PROC:QWORD,_Ext_EXCEPCION_17_PROC:QWORD
    EXTRN _Ext_TIMER_COUNT:DWORD,_Ext_TIMER_OVERFLOW:DWORD
    EXTRN _Ext_TIMER_ERROR:QWORD,_Ext_TIMER_ACTUAL:WORD
    EXTRN _Ext_KEYBOARD_HIT:BYTE,_Ext_KEYBOARD_SPEC:BYTE
    EXTRN _Ext_KEYBOARD_KEY:BYTE,_Ext_KEYBOARD_BUFF:BYTE
    EXTRN _Ext_KEYBOARD_WRITE:WORD,_Ext_KEYBOARD_LEDS:BYTE
    EXTRN _Ext_KEYBOARD_OVERFLOW:BYTE,_Ext_KEYBOARD_CAPS:BYTE
    EXTRN _Ext_KEYBOARD_NUM:BYTE,_Ext_KEYBOARD_BLOQ:BYTE
    EXTRN _Ext_KEYBOARD_READ:WORD
    EXTRN _Ext_CTRL_ALT_DEL:BYTE,_Ext_CTRL_ALT_DEL_PROC:QWORD
    EXTRN _Ext_KEYBOARD_MAP:QWORD,_KEYBOARD_CERO:BYTE,KEYBOARD_MAP_SP:BYTE
    EXTRN ERROR_EAX:DWORD,ERROR_EBX:DWORD,ERROR_ECX:DWORD
    EXTRN ERROR_EDX:DWORD,ERROR_ESI:DWORD,ERROR_EDI:DWORD,ERROR_ESP:DWORD
    EXTRN ERROR_EBP:DWORD,ERROR_CR0:DWORD,ERROR_CR2:DWORD,ERROR_CR3:DWORD
    EXTRN ERROR_EFLAGS:DWORD,ERROR_EIP:DWORD,ERROR_CS:WORD,ERROR_SS:WORD
    EXTRN ERROR_DS:WORD,ERROR_ES:WORD,ERROR_FS:WORD,ERROR_GS:WORD
    EXTRN Error_Salida:BYTE,RetornoReal:PROC ,SELECTOR_START32_TSS:ABS
    EXTRN SELECTOR_MEMBASE:ABS,SELECTOR_DPMI:ABS,SELECTOR_CAMBIO:ABS
    EXTRN _Ext_DSP:WORD,_Ext_DSP_DS:WORD,_Ext_MEM:DWORD,SELECTOR_TIMER:ABS
    EXTRN main_:PROC,_Ext_MemoriaVideo:QWORD,SELECTOR_REAL_DS:ABS
    EXTRN _Ext_TASK:WORD,_Ext_END_TASKS:DWORD,_Ext_TASK_BUFFER:QWORD
    EXTRN ADD_DATA_PAGE:DWORD,_Ext_INT_INVALIDA_PROC:QWORD
    EXTRN _Ext_IRQ0_PROC:QWORD,_Ext_IRQ1_PROC:QWORD,_Ext_IRQ1_PROC:QWORD
    EXTRN _Ext_IRQ2_PROC:QWORD,_Ext_IRQ3_PROC:QWORD,_Ext_IRQ4_PROC:QWORD
    EXTRN _Ext_IRQ5_PROC:QWORD,_Ext_IRQ6_PROC:QWORD,_Ext_IRQ7_PROC:QWORD
    EXTRN _Ext_IRQ8_PROC:QWORD,_Ext_IRQ9_PROC:QWORD,_Ext_IRQA_PROC:QWORD
    EXTRN _Ext_IRQB_PROC:QWORD,_Ext_IRQC_PROC:QWORD,_Ext_IRQD_PROC:QWORD
    EXTRN _Ext_IRQE_PROC:QWORD,_Ext_IRQF_PROC:QWORD,_Ext_TRAP32_PROC:QWORD
    EXTRN _Ext_TRAP33_PROC:QWORD,_Ext_TRAP34_PROC:QWORD,_Ext_TRAP35_PROC:QWORD
    EXTRN _Ext_TRAP36_PROC:QWORD,_Ext_TRAP37_PROC:QWORD,_Ext_TRAP38_PROC:QWORD
    EXTRN _Ext_TRAP39_PROC:QWORD,_Ext_TRAP3A_PROC:QWORD,_Ext_TRAP3B_PROC:QWORD
    EXTRN _Ext_TRAP3C_PROC:QWORD,_Ext_TRAP3D_PROC:QWORD,_Ext_TRAP3E_PROC:QWORD
    EXTRN _Ext_TRAP3F_PROC:QWORD,_Ext_FDC_UNIDAD:BYTE,_Ext_FDC_VELOCIDAD:BYTE
    EXTRN FDC_OPERACION:BYTE,_Ext_FDC_CILINDRO:BYTE,_Ext_FDC_CABEZAL:BYTE
    EXTRN SELECTOR_DMA:ABS,_Ext_FDC_DMA:QWORD

    PUBLIC Excepcion_Division,Excepcion_Paso_A_Paso,Excepcion_NMI
    PUBLIC Excepcion_Ruptura,Excepcion_Desbordamiento,Excepcion_Limites
    PUBLIC Excepcion_Invalido,Excepcion_No_Coprocesador,Excepcion_Fallo_Doble
    PUBLIC Excepcion_Overrun,Excepcion_Segmento_Invalido
    PUBLIC Excepcion_Segmento_Ausente,Excepcion_Pila,Excepcion_General
    PUBLIC Excepcion_Fallo_Pagina,Excepcion_General2,Excepcion_Coprocesador
    PUBLIC Timer_ISR,Keyboard_ISR,DPMI_trap,INICIO_CODIGO32
    PUBLIC _cstart_,Ext_settimer_,Ext_readtimer_,Ext_keyboardleds_
    PUBLIC Ext_keypressed_,Ext_map_,Ext_getch_,Ext_keyhit_,Ext_ExclusionMutua_
    PUBLIC Task_Trap,Ext_CopiarMemoria_,Ext_BorrarMemoria_,Ext_NextTask_
    PUBLIC Ext_LongitudCadena_,Ext_RellenarMemoria_,Ext_CrearSelector_
    PUBLIC Ext_DestruirSelector_,Ext_ReservarMemoriaDPMI_,Ext_getkey_
    PUBLIC Ext_LiberarMemoriaDPMI_,Ext_HacerPuntero_,Ext_Segmento_
    PUBLIC Ext_Desplazamiento_,Ext_CrearAcceso_,Ext_HacerSelector_
    PUBLIC Ext_InicTask_,Ext_DescriptorLDT_,Ext_Copy2LDT_,Ext_FreeTask_
    PUBLIC Ext_NewTask_,Ext_malloc_,_nmalloc_,Ext_free_,_nfree_
    PUBLIC Ext_strlen_,Ext_strcpy_,Ext_strncpy_,Ext_strset_,Ext_strnset_
    PUBLIC Ext_strcmp_,Ext_strncmp_,Ext_memset_,Ext_memcpy_,Ext_calloc_
    PUBLIC Int_Invalida,IRQ2_ISR,IRQ3_ISR,IRQ4_ISR,IRQ5_ISR,IRQ6_ISR
    PUBLIC IRQ7_ISR,IRQ8_ISR,IRQ9_ISR,IRQA_ISR,IRQB_ISR,IRQC_ISR
    PUBLIC IRQD_ISR,IRQE_ISR,IRQF_ISR,TRAP_32,TRAP_33,TRAP_34,TRAP_35
    PUBLIC TRAP_36,TRAP_37,TRAP_38,TRAP_39,TRAP_3A,TRAP_3B,TRAP_3C,TRAP_3D
    PUBLIC TRAP_3E,TRAP_3F
    PUBLIC Ext_FDC_MotorON_,Ext_FDC_MotorOFF_,Ext_FDC_Select_
    PUBLIC Ext_FDC_Recalibrate_,Ext_FDC_Seek_,Ext_FDC_Read_,Ext_FDC_Write_
    PUBLIC Ext_FDC_Format_,Ext_WaitTicks_

        ASSUME CS:_TEXT

RecojerRejistros MACRO
        push        ds
        push        eax
        mov         ax,offset SELECTOR_DS
        mov         ds,ax
        pop         eax
        mov         ERROR_EAX,eax
        pop         ax
        mov         ERROR_EBX,ebx
        mov         ERROR_ECX,ecx
        mov         ERROR_EDX,edx
        mov         ERROR_ESI,esi
        mov         ERROR_EDI,edi
        mov         ERROR_EBP,ebp
        mov         ebx,esp
        add         ebx,14
        mov         ERROR_ESP,ebx
        mov         ERROR_SS,ss
        mov         ERROR_DS,ax
        mov         ERROR_ES,es
        mov         ERROR_FS,fs
        mov         ERROR_GS,gs
        mov         ebx,ss:[esp+10]
        mov         ecx,ss:[esp+6]
        mov         edx,ss:[esp+2]
        mov         ERROR_CS,cx
        mov         ERROR_EIP,edx
        mov         ERROR_EFLAGS,ebx
        mov         edx,cr0
        mov         ERROR_CR0,edx
        mov         edx,cr2
        mov         ERROR_CR2,edx
        mov         edx,cr3
        mov         ERROR_CR3,edx
        mov         ds,ax
       ENDM

_TEXT SEGMENT PARA PUBLIC USE32 'CODE'

 INICIO_CODIGO32 LABEL WORD

_cstart_ PROC FAR
        mov     eax,-1                 ; Iniciar Timer
        Llamada32_32 SELECTOR_CS32,Ext_settimer_
        xor     edx,edx
        mov     dx,offset SELECTOR_DS         ; Poner Tabla de Teclado
        mov     eax,offset KEYBOARD_MAP_SP
        Llamada32_32 SELECTOR_CS32,Ext_map_
        mov     eax,offset Keyboard_Ctrl_Alt_Del_Proc ; Poner procedimiento
        mov     dword ptr ds:[_Ext_CTRL_ALT_DEL_PROC],eax ; CTRL+ALT+DEL
        xor     eax,eax
        mov     ax,offset SELECTOR_CS32               ; Por defecto salida
        mov     dword ptr ds:4[_Ext_CTRL_ALT_DEL_PROC],eax ; del extensor
        mov     _Ext_CTRL_ALT_DEL,-1                  ; Activar procedimiento
        push    es
        mov     ax,offset SELECTOR_CAMBIO
        mov     es,ax
        mov     ax,offset SELECTOR_START32_TSS   ; Poner tarea padre
        mov     es:[0],ax
        pop     es
        mov     eax,offset Timer_Error_Proc ; Poner procedimiento
        mov     dword ptr ds:[_Ext_TIMER_ERROR],eax     ; Error en tareas
        xor     eax,eax
        mov     ax,offset SELECTOR_CS32               ; Por defecto salida
        mov     dword ptr ds:4[_Ext_TIMER_ERROR],eax ; del extensor
        mov     eax,-1          ; Ponemos exclusion mutua en ON
        Llamada32_32 SELECTOR_CS32,Ext_ExclusionMutua_
        cli
        in      al,PICA01               ; Permitir IRQs 0,1,6
        and     al,10111100b
        out     PICA01,al
        mov     _Ext_TIMER_COUNT,0      ; Contador del Timer a cero
        sti
        Llamada32_32 SELECTOR_CS32,Ext_keyboardleds_  ; Poner LEDS
 Esperar_Teclado:        ; Esperar 5 Ticks para el teclado
        cmp     _Ext_TIMER_COUNT,5
        jl      Esperar_Teclado
        cli
        mov    _Ext_KEYBOARD_HIT,0    ; Inicia Teclado
        mov    _Ext_KEYBOARD_READ,0
        mov    _Ext_KEYBOARD_WRITE,0
        sti
        mov     edi,offset _Ext_MemoriaVideo
        xor     eax,eax
        mov     ds:[edi],eax          ; Hacer puntero a la memoria Video
        mov     ax,offset SELECTOR_VIDEO
        mov     ds:[edi+4],eax

        mov     edi,offset _Ext_TASK_BUFFER
        xor     eax,eax
        mov     ds:[edi],eax         ; Hacer puntero al buffer de tareas
        mov     ax,offset SELECTOR_CAMBIO
        mov     ds:[edi+4],eax

        mov     edi,offset _Ext_FDC_DMA
        xor     eax,eax
        mov     ds:[edi],eax         ; Hacer puntero a la pagina DMA
        mov     ax,offset SELECTOR_DMA
        mov     ds:[edi+4],eax

        call    main_                ; Ejecutar el main de C/C++

        Salto32_16 SELECTOR_CS,RetornoReal      ; Volver al modo real
_cstart_ ENDP
                                            
Excepcion_Division PROC                ; Excepcion 0
        RecojerRejistros
        mov        ax,offset SELECTOR_DS      ; Division por 0
        mov        ds,ax
        mov        ax,offset SELECTOR_SS
        mov        ss,ax
        mov        esp,offset FIN_PILA
        mov        eax,DWORD PTR ds:[_Ext_EXCEPCION_0_PROC]
        or         eax,DWORD PTR ds:2[_Ext_EXCEPCION_0_PROC]
        jz         Excepcion_No_Proc_0
        Llamada_DS _Ext_EXCEPCION_0_PROC
 Excepcion_No_Proc_0:
        mov        ax,5                ; Salir del extensor con error 5
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Excepcion_Division ENDP

Excepcion_Paso_A_Paso PROC             ; Excepcion 1
        RecojerRejistros
        mov        ax,offset SELECTOR_DS      ; Depuracion paso a paso
        mov        ds,ax
        mov        ax,offset SELECTOR_SS
        mov        ss,ax
        mov        esp,offset FIN_PILA
        mov        eax,DWORD PTR ds:[_Ext_EXCEPCION_1_PROC]
        or         eax,DWORD PTR ds:2[_Ext_EXCEPCION_1_PROC]
        jz         Excepcion_No_Proc_1
        Llamada_DS _Ext_EXCEPCION_1_PROC
 Excepcion_No_Proc_1:
        mov        ax,6                ; Salir del extensor con error 6
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Excepcion_Paso_A_Paso ENDP

Excepcion_NMI PROC                     ; Excepcion 2
        RecojerRejistros
        mov        ax,offset SELECTOR_DS      ; NMI, depuracion
        mov        ds,ax
        mov        ax,offset SELECTOR_SS
        mov        ss,ax
        mov        esp,offset FIN_PILA
        mov        eax,DWORD PTR ds:[_Ext_EXCEPCION_2_PROC]
        or         eax,DWORD PTR ds:2[_Ext_EXCEPCION_2_PROC]
        jz         Excepcion_No_Proc_2
        Llamada_DS _Ext_EXCEPCION_2_PROC
 Excepcion_No_Proc_2:
        mov        ax,6                ; Salir del extensor con error 6
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Excepcion_NMI ENDP

Excepcion_Ruptura PROC                 ; Excepcion 3
        RecojerRejistros
        mov        ax,offset SELECTOR_DS      ; Punto de Ruptura en depuracion
        mov        ds,ax
        mov        ax,offset SELECTOR_SS
        mov        ss,ax
        mov        esp,offset FIN_PILA
        mov        eax,DWORD PTR ds:[_Ext_EXCEPCION_3_PROC]
        or         eax,DWORD PTR ds:2[_Ext_EXCEPCION_3_PROC]
        jz         Excepcion_No_Proc_3
        Llamada_DS _Ext_EXCEPCION_3_PROC
 Excepcion_No_Proc_3:
        mov        ax,6                ; Salir del extensor con error 6
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Excepcion_Ruptura ENDP

Excepcion_Desbordamiento PROC          ; Excepcion 4
        RecojerRejistros
        mov        ax,offset SELECTOR_DS      ; Desbordamiento
        mov        ds,ax
        mov        ax,offset SELECTOR_SS
        mov        ss,ax
        mov        esp,offset FIN_PILA
        mov        eax,DWORD PTR ds:[_Ext_EXCEPCION_4_PROC]
        or         eax,DWORD PTR ds:2[_Ext_EXCEPCION_4_PROC]
        jz         Excepcion_No_Proc_4
        Llamada_DS _Ext_EXCEPCION_4_PROC
 Excepcion_No_Proc_4:
        mov        ax,7                ; Salir del extensor con error 7
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Excepcion_Desbordamiento ENDP

Excepcion_Limites PROC                 ; Excepcion 5
        RecojerRejistros
        mov        ax,offset SELECTOR_DS      ; Comprobacion de limites
        mov        ds,ax
        mov        ax,offset SELECTOR_SS
        mov        ss,ax
        mov        esp,offset FIN_PILA
        mov        eax,DWORD PTR ds:[_Ext_EXCEPCION_5_PROC]
        or         eax,DWORD PTR ds:2[_Ext_EXCEPCION_5_PROC]
        jz         Excepcion_No_Proc_5
        Llamada_DS _Ext_EXCEPCION_5_PROC
 Excepcion_No_Proc_5:
        mov        ax,8                ; Salir del extensor con error 8
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Excepcion_Limites ENDP

Excepcion_Invalido PROC                ; Excepcion 6
        RecojerRejistros               
        mov        ax,offset SELECTOR_DS      ; Comprobacion de limites
        mov        ds,ax
        mov        ax,offset SELECTOR_SS
        mov        ss,ax
        mov        esp,offset FIN_PILA
        mov        eax,DWORD PTR ds:[_Ext_EXCEPCION_6_PROC]
        or         eax,DWORD PTR ds:2[_Ext_EXCEPCION_6_PROC]
        jz         Excepcion_No_Proc_6
        Llamada_DS _Ext_EXCEPCION_6_PROC
 Excepcion_No_Proc_6:
        mov        ax,9                ; Salir del extensor con error 9
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Excepcion_Invalido ENDP

Excepcion_No_Coprocesador PROC         ; Excepcion 7
        RecojerRejistros               
        mov        ax,offset SELECTOR_DS      ; Coprocesador no disponible
        mov        ds,ax
        mov        ax,offset SELECTOR_SS
        mov        ss,ax
        mov        esp,offset FIN_PILA
        mov        eax,DWORD PTR ds:[_Ext_EXCEPCION_7_PROC]
        or         eax,DWORD PTR ds:2[_Ext_EXCEPCION_7_PROC]
        jz         Excepcion_No_Proc_7
        Llamada_DS _Ext_EXCEPCION_7_PROC
 Excepcion_No_Proc_7:
        mov        ax,10               ; Salir del extensor con error 10
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Excepcion_No_Coprocesador ENDP

Excepcion_Fallo_Doble PROC             ; Excepcion 8
        RecojerRejistros               
        mov        ax,offset SELECTOR_DS      ; Fallo en otra excepcion
        mov        ds,ax
        mov        ax,offset SELECTOR_SS
        mov        ss,ax
        mov        esp,offset FIN_PILA
        mov        eax,DWORD PTR ds:[_Ext_EXCEPCION_8_PROC]
        or         eax,DWORD PTR ds:2[_Ext_EXCEPCION_8_PROC]
        jz         Excepcion_No_Proc_8
        Llamada_DS _Ext_EXCEPCION_8_PROC
 Excepcion_No_Proc_8:
        mov        ax,11               ; Salir del extensor con error 11
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Excepcion_Fallo_Doble ENDP

Excepcion_Overrun PROC                 ; Excepcion 9
        RecojerRejistros               
        mov        ax,offset SELECTOR_DS      ; Sobrepaso de un segmento
        mov        ds,ax
        mov        ax,offset SELECTOR_SS
        mov        ss,ax
        mov        esp,offset FIN_PILA
        mov        eax,DWORD PTR ds:[_Ext_EXCEPCION_9_PROC]
        or         eax,DWORD PTR ds:2[_Ext_EXCEPCION_9_PROC]
        jz         Excepcion_No_Proc_9
        Llamada_DS _Ext_EXCEPCION_9_PROC
 Excepcion_No_Proc_9:
        mov        ax,12               ; Salir del extensor con error 12
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Excepcion_Overrun ENDP

Excepcion_Segmento_Invalido PROC       ; Excepcion 10
        RecojerRejistros               
        mov        ax,offset SELECTOR_DS     ; Segmento de estado de tarea invalido
        mov        ds,ax
        mov        ax,offset SELECTOR_SS
        mov        ss,ax
        mov        esp,offset FIN_PILA
        mov        eax,DWORD PTR ds:[_Ext_EXCEPCION_10_PROC]
        or         eax,DWORD PTR ds:2[_Ext_EXCEPCION_10_PROC]
        jz         Excepcion_No_Proc_10
        Llamada_DS _Ext_EXCEPCION_10_PROC
 Excepcion_No_Proc_10:
        mov        ax,12               ; Salir del extensor con error 12
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Excepcion_Segmento_Invalido ENDP

Excepcion_Segmento_Ausente PROC        ; Excepcion 11
        RecojerRejistros               
        mov        ax,offset SELECTOR_DS      ; Segmento no presente
        mov        ds,ax
        mov        ax,offset SELECTOR_SS
        mov        ss,ax
        mov        esp,offset FIN_PILA
        mov        eax,DWORD PTR ds:[_Ext_EXCEPCION_11_PROC]
        or         eax,DWORD PTR ds:2[_Ext_EXCEPCION_11_PROC]
        jz         Excepcion_No_Proc_11
        Llamada_DS _Ext_EXCEPCION_11_PROC
 Excepcion_No_Proc_11:
        mov        ax,12               ; Salir del extensor con error 12
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Excepcion_Segmento_Ausente ENDP

Excepcion_Pila PROC                    ; Excepcion 12
        RecojerRejistros               
        mov        ax,offset SELECTOR_DS      ; Referencia a la pila invalida
        mov        ds,ax
        mov        ax,offset SELECTOR_SS
        mov        ss,ax
        mov        esp,offset FIN_PILA
        mov        eax,DWORD PTR ds:[_Ext_EXCEPCION_12_PROC]
        or         eax,DWORD PTR ds:2[_Ext_EXCEPCION_12_PROC]
        jz         Excepcion_No_Proc_12
        Llamada_DS _Ext_EXCEPCION_12_PROC
 Excepcion_No_Proc_12:
        mov        ax,13               ; Salir del extensor con error 13
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Excepcion_Pila ENDP

Excepcion_General PROC                 ; Excepcion 13
        RecojerRejistros               
        mov        ax,offset SELECTOR_DS      ; Excepcion de proteccion general
        mov        ds,ax
        mov        ax,offset SELECTOR_SS
        mov        ss,ax
        mov        esp,offset FIN_PILA
        mov        eax,DWORD PTR ds:[_Ext_EXCEPCION_13_PROC]
        or         eax,DWORD PTR ds:2[_Ext_EXCEPCION_13_PROC]
        jz         Excepcion_No_Proc_13
        Llamada_DS _Ext_EXCEPCION_13_PROC
 Excepcion_No_Proc_13:
        mov        ax,11               ; Salir del extensor con error 11
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Excepcion_General ENDP

Excepcion_Fallo_Pagina PROC            ; Excepcion 14
        RecojerRejistros               
        mov        ax,offset SELECTOR_DS      ; Referencia a memoria no fisica
        mov        ds,ax
        mov        ax,offset SELECTOR_SS
        mov        ss,ax
        mov        esp,offset FIN_PILA
        mov        eax,DWORD PTR ds:[_Ext_EXCEPCION_14_PROC]
        or         eax,DWORD PTR ds:2[_Ext_EXCEPCION_14_PROC]
        jz         Excepcion_No_Proc_14
        Llamada_DS _Ext_EXCEPCION_14_PROC
 Excepcion_No_Proc_14:
        mov        ax,14               ; Salir del extensor con error 14
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Excepcion_Fallo_Pagina ENDP

Excepcion_General2 PROC                ; Excepcion 15
        RecojerRejistros               
        mov        ax,offset SELECTOR_DS      ; Excepcion de proteccion general ?
        mov        ds,ax
        mov        ax,offset SELECTOR_SS
        mov        ss,ax
        mov        esp,offset FIN_PILA
        mov        eax,DWORD PTR ds:[_Ext_EXCEPCION_15_PROC]
        or         eax,DWORD PTR ds:2[_Ext_EXCEPCION_15_PROC]
        jz         Excepcion_No_Proc_15
        Llamada_DS _Ext_EXCEPCION_15_PROC
 Excepcion_No_Proc_15:
        mov        ax,11               ; Salir del extensor con error 11
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Excepcion_General2 ENDP

Excepcion_Coprocesador PROC            ; Excepcion 16
        RecojerRejistros               
        mov        ax,offset SELECTOR_DS      ; Error de coprocesador
        mov        ds,ax
        mov        ax,offset SELECTOR_SS
        mov        ss,ax
        mov        esp,offset FIN_PILA
        mov        eax,DWORD PTR ds:[_Ext_EXCEPCION_16_PROC]
        or         eax,DWORD PTR ds:2[_Ext_EXCEPCION_16_PROC]
        jz         Excepcion_No_Proc_16
        Llamada_DS _Ext_EXCEPCION_16_PROC
 Excepcion_No_Proc_16:
        mov        ax,10               ; Salir del extensor con error 10
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Excepcion_Coprocesador ENDP

Int_Invalida PROC FAR
        RecojerRejistros               
        mov        ax,offset SELECTOR_DS      ; Interrupcion no valida
        mov        ds,ax
        mov        ax,offset SELECTOR_SS
        mov        ss,ax
        mov        esp,offset FIN_PILA
        mov        eax,DWORD PTR ds:[_Ext_INT_INVALIDA_PROC]
        or         eax,DWORD PTR ds:2[_Ext_INT_INVALIDA_PROC]
        jz         Int_Invalida_No_Proc
        Llamada_DS _Ext_INT_INVALIDA_PROC
 Int_Invalida_No_Proc:
        mov        ax,13h
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Int_Invalida ENDP

CambioTarea PROC FAR
        mov         dx,gs
        xor         ebx,ebx
        mov         bx,_Ext_TIMER_ACTUAL
        shl         ebx,1
        mov         ax,fs:[ebx]
        cmp         ax,es:[00h]
        je          CambioTarea_NoErrorCritico
 CambioTarea_ErrorCritico:
        mov         eax,DWORD PTR ds:[_Ext_TIMER_ERROR]
        mov         eax,DWORD PTR ds:[_Ext_TIMER_ERROR]
        pushad
        push        ds
        push        es
        push        fs
        push        gs
        pushfd
        Llamada_DS  _Ext_TIMER_ERROR
        popfd
        pop         gs
        pop         fs
        pop         es
        pop         ds
        popad
        jmp short CambioTarea_NoCambio
 CambioTarea_NoErrorCritico:
        mov         ecx,ebx
 CambioTarea_OtraTarea:
        add         ebx,2
        mov         ax,fs:[ebx]
        test        ax,ax
        jnz         CambioTarea_TareaSiguiente
        xor         ebx,ebx
        mov         ax,fs:[ebx]
        mov         _Ext_TIMER_ACTUAL,-1
 CambioTarea_TareaSiguiente:
        inc         _Ext_TIMER_ACTUAL
        add         ax,8
        mov         gs,ax
        sub         ax,8
        test byte ptr gs:[6Ah],1
        jz          CambioTarea_NoOtraTarea
        cmp         ecx,ebx
        je          CambioTarea_ErrorCritico
        jmp short   CambioTarea_OtraTarea
 CambioTarea_NoOtraTarea:
        mov         _Ext_TASK,ax
        mov         es:[00h],ax
        mov         ax,gs:[68h]
        mov         gs,dx
        mov         gs:[68h],ax
CambioTarea_NoCambio:
        mov         gs,dx
        retf
CambioTarea ENDP

Task_TRAP PROC
        Llamada32_32 SELECTOR_CS32,CambioTarea
        iretd
        jmp short Task_TRAP
Task_TRAP ENDP

Timer_ISR  PROC
        cli
        add         [_Ext_TIMER_COUNT],1
        jnc         Timer_ISR_NoOverflow
        inc         [_Ext_TIMER_OVERFLOW]
 Timer_ISR_NoOverflow:
        mov         al,20h
        out         20h,al
        mov         al,es:[6Ah]
        test        al,al
        jnz         Timer_NoCambio
        dec word ptr es:[68h]
        jnz         Timer_NoCambio
        Llamada32_32 SELECTOR_CS32,CambioTarea
 Timer_NoCambio:
        mov         eax,DWORD PTR ds:[_Ext_IRQ0_PROC]
        or          eax,DWORD PTR ds:2[_Ext_IRQ0_PROC]
        jz          Timer_NoProc
        push    ds
        push    es
        push    fs
        push    gs
        pushfd
        sti
        Llamada_DS  _Ext_IRQ0_PROC
        popfd
        pop     gs
        pop     fs
        pop     es
        pop     ds
 Timer_NoProc:
        iretd
        jmp short Timer_ISR
Timer_ISR  ENDP

Timer_Error_Proc PROC
        cli
        mov        ax,offset SELECTOR_REAL_DS ; Procedimiento TIMER-ERROR
        mov        ds,ax
        mov        ax,12h              ; Salir del extensor con error 12h
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Timer_Error_Proc ENDP

Ext_ExclusionMutua_ PROC FAR
        or         eax,eax              ;EAX = Booleano Exclusion
        jz         Ext_ExclusionMutua_OFF
        mov        al,-1
        ror        eax,16
 Ext_ExclusionMutua_OFF:
        push       es
        mov        ax,offset SELECTOR_TIMER
        mov        es,ax
        rol        eax,16
        mov        es:[6Ah],al
        pop        es
        retf
Ext_ExclusionMutua_ ENDP

Ext_NextTask_ PROC FAR
        push       ecx
        mov        ecx,eax
 Ext_NextTask_Otra:
        int        30h
        loop       Ext_NextTask_Otra
        pop        ecx
        retf
Ext_NextTask_ ENDP

Ext_settimer_ PROC FAR
        push        ebx                ; AX = Timer
        push        eax
        pushfd
        mov         ebx,eax
        cli
        mov         al,36h
        out         43h,al
        jmp short Ext_SetTimer_1
 Ext_SetTimer_1:
        mov         eax,ebx
        out         40h,al
        jmp short Ext_SetTimer_2
 Ext_SetTimer_2:
        mov         al,ah
        out         40h,al
        jmp short Ext_SetTimer_3
 Ext_SetTimer_3:
        popfd
        pop         eax
        pop         ebx
        retf
Ext_settimer_ ENDP

Ext_readtimer_ PROC FAR
        pushf
        cli
        xor        al,al
        out        43h,al
        in         al,40h
        mov        ah,al
        in         al,40h
        xchg       al,ah
        neg        ax
        popf
        retf                ; AX = Timer
Ext_readtimer_ ENDP

Keyboard_ISR PROC FAR
        cli
        push       ds
        push       eax
        push       ebx
        in         al,60h
        mov        ah,al
        in         al,61h
        or         al,80h
        out        61h,al
        and        al,7fh
        out        61h,al
        mov        al,ah
        xor        ah,ah
        push       ax
        mov        ax,offset SELECTOR_REAL_DS
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_IRQ1_PROC]
        or         eax,DWORD PTR ds:2[_Ext_IRQ1_PROC]
        jz         Keyboard_No_Proc
        mov        ax,ss:[esp]
        pushad
        push    es
        push    fs
        push    gs
        sti
        Llamada_DS _Ext_IRQ1_PROC
        cli
        pop     gs
        pop     fs
        pop     es
        popad
        mov        ax,offset SELECTOR_REAL_DS
        mov        ds,ax
 Keyboard_No_Proc:
        pop        ax
        mov        bl,_Ext_CTRL_ALT_DEL
        or         bl,bl
        jz         Keyboard_No_Ctrl_Alt_Del
        mov        bl,al
        and        bl,7Fh
        cmp        bl,053h
        jnz        Keyboard_No_Ctrl_Alt_Del
        mov        bl,ds:1Dh[_Ext_KEYBOARD_KEY] ; Ctrl. Izq.
        or         bl,bl
        jnz        Keyboard_Ctrl_Alt_Del_Ctrl
        mov        bl,ds:9Dh[_Ext_KEYBOARD_KEY] ; Ctrl. Der.
        or         bl,bl
        jz         Keyboard_No_Ctrl_Alt_Del
 Keyboard_Ctrl_Alt_Del_Ctrl:
        mov        bl,ds:38h[_Ext_KEYBOARD_KEY] ; Alt. Izq.
        or         bl,bl
        jnz        Keyboard_Ctrl_Alt_Del
        mov        bl,ds:0B8h[_Ext_KEYBOARD_KEY] ; Alt. Der.
        or         bl,bl
        jz         Keyboard_No_Ctrl_Alt_Del
 Keyboard_Ctrl_Alt_Del:
        push       ax
        mov        al,20h
        out        20h,al
        pushad
        push    es
        push    fs
        push    gs
        sti
        Llamada_DS _Ext_CTRL_ALT_DEL_PROC
        cli
        pop     gs
        pop     fs
        pop     es
        popad
        mov        ax,offset SELECTOR_REAL_DS
        mov        ds,ax
        pop        ax 
 Keyboard_No_Ctrl_Alt_Del:        
        mov        bl,_Ext_KEYBOARD_LEDS
        or         bl,bl
        jz         Keyboard_No_Caps        ; Funcionan los LEDs ?
        cmp        al,0C6h        ; Bloq. Despl.
        jne        Keyboard_No_Scroll
        not        _Ext_KEYBOARD_BLOQ
        Llamada32_32 SELECTOR_CS32,Ext_keyboardleds_
        jmp short   Keyboard_NoE1
 Keyboard_No_Scroll:      
        cmp        al,0C5h        ; Bloq. Num.
        jne        Keyboard_No_Num
        not        _Ext_KEYBOARD_NUM
        Llamada32_32 SELECTOR_CS32,Ext_keyboardleds_
        jmp short  Keyboard_NoE1
 Keyboard_No_Num:
        cmp        al,0BAh        ; Bloq. May
        jne        Keyboard_No_Caps
        not        _Ext_KEYBOARD_CAPS
        Llamada32_32 SELECTOR_CS32,Ext_keyboardleds_
        jmp short  Keyboard_NoE1
 Keyboard_No_Caps:
        cmp        al,0E0h        
        jne        Keyboard_noE0
        inc        _Ext_KEYBOARD_SPEC
        jmp short  Keyboard_Salida2
 Keyboard_NoE0:
        cmp        al,0E1h
        jne        Keyboard_NoE1
        add        _Ext_KEYBOARD_SPEC,2
 Keyboard_Salida2:
        jmp short Keyboard_Salida
 Keyboard_NoE1:  
        cmp        _Ext_KEYBOARD_SPEC,0
        jz         KEYBOARD_No_Especial
        dec        _Ext_KEYBOARD_SPEC
        not        ah
 Keyboard_No_Especial:
        mov        bl,al
        and        ebx,7Fh
        cmp        bl,110
        ja         Keyboard_Salida
        add        ebx,offset _Ext_KEYBOARD_KEY
        or         ah,ah
        jz         Keyboard_No_Suma
        add        ebx,128
 Keyboard_No_Suma:        
        and        al,al
        jns        Keyboard_Pulsando
        mov        byte ptr ds:[ebx],0
        or         ah,ah
        jnz        Keyboard_Signo
        and        al,01111111b
 Keyboard_Signo:        
        mov        _Ext_KEYBOARD_HIT,al
        xor        ebx,ebx
        mov        bx,_Ext_KEYBOARD_WRITE
        cmp        bx,1024
        jl         Keyboard_Buffer
        mov        bx,-1
 Keyboard_Buffer:
        inc        bx
        cmp        bx,_Ext_KEYBOARD_READ
        jne        Keyboard_Buffer_Bien
        mov        _Ext_KEYBOARD_OVERFLOW,-1
        jmp short      Keyboard_Salida
 Keyboard_Buffer_Bien:
        mov        _Ext_KEYBOARD_OVERFLOW,0
        mov        _Ext_KEYBOARD_WRITE,bx
        dec        bx
        add        ebx,offset _Ext_KEYBOARD_BUFF
        mov        ds:[ebx],al
        jmp short Keyboard_Salida
 Keyboard_Pulsando:        
        mov        byte ptr ds:[ebx],0FFh
 Keyboard_Salida:
        mov        al,20h
        out        20h,al
        pop        ebx
        pop        eax
        pop        ds
        iretd
Keyboard_ISR ENDP



Keyboard_Ctrl_Alt_Del_Proc PROC
        cli
        mov        ax,offset SELECTOR_REAL_DS ; Procedimiento CONTROL+ALT+DEL
        mov        ds,ax
        mov        ax,11h              ; Salir del extensor con error 11h
        mov        Error_Salida,al
        Salto32_16 SELECTOR_CS,RetornoReal
Keyboard_Ctrl_Alt_Del_Proc ENDP

Ext_keyboardleds_ PROC
        push       eax
        push       ds
        mov        ax,offset SELECTOR_REAL_DS
        mov        ds,ax
        xor        eax,eax
        test       _Ext_KEYBOARD_LEDS,0ffh
        jz         Ext_keyboardleds_No         ; Funcionan los LEDs ?
        mov        al,_Ext_KEYBOARD_BLOQ
        ror        eax,1
        mov        al,_Ext_KEYBOARD_NUM
        ror        eax,1
        mov        al,_Ext_KEYBOARD_CAPS
        rol        eax,2
        and        eax,7
        ror        eax,8
        push       dx
        pushfd
        cli
        in      al,PICA01
        mov     dl,al
        or      al,2
        out     PICA01,al
 Ext_keyboardleds_onStart:
        in         al,64h
        and        al,02h
        jnz        Ext_keyboardleds_onStart
        mov        al,0EDh
        out        60h,al
 Ext_keyboardleds_onReply:
        in         al,64h
        and        al,01h
        jnz        Ext_keyboardleds_onReply
        in         al,60h
 Ext_keyboardleds_wait:
        in         al,64h
        and        al,02h
        jnz        Ext_keyboardleds_wait
        rol        eax,8
        out        60h,al
 Ext_keyboardleds_answer:
        in         al,64
        and        al,01h
        jnz        Ext_keyboardleds_answer
        in         al,60h
        mov        al,dl
        out        PICA01,al
        popfd
        pop        dx
 Ext_keyboardleds_No:
        pop        ds
        pop        eax
        retf
Ext_keyboardleds_ ENDP

Ext_keypressed_ PROC
        push        ds
        push        ebx
        mov         ax,offset SELECTOR_REAL_DS
        mov         ds,ax
        xor         eax,eax
        mov         bx,_Ext_KEYBOARD_READ
        cmp         bx,_Ext_KEYBOARD_WRITE
        je          Ext_keypressed_no
        xor         ebx,ebx
        mov         eax,offset _Ext_KEYBOARD_BUFF
        mov         bx,_Ext_KEYBOARD_READ
        add         ebx,eax
        xor         eax,eax
        mov         al,ds:[ebx]
        mov         bl,_Ext_KEYBOARD_NUM
        or          bl,bl
        jnz         Ext_keypressed_num
        cmp         al,47h        ; 7 Numerico
        jl          Ext_keypressed_num
        cmp         al,53h        ; . Numerico
        jg          Ext_keypressed_num
        cmp         al,4Ah        ; - Numerico
        je          Ext_keypressed_num
        cmp         al,4Eh        ; + Numerico
        je          Ext_keypressed_num
        add         al,80h
 Ext_keypressed_num:        
        shl         eax,2
        mov         ebx,dword ptr ds:[_Ext_KEYBOARD_MAP]
        add         ebx,eax
        mov         eax,dword ptr ds:4[_Ext_KEYBOARD_MAP]
        mov         ds,ax
        mov         eax,ds:[ebx]
        cmp         eax,-1
        jne         Ext_keypressed_si
        mov         bx,offset SELECTOR_REAL_DS
        mov         ds,bx
        mov         bx,_Ext_KEYBOARD_READ
        cmp         bx,1024
        jl          Ext_keypressed_suma_buffer
        mov         bx,-1
 Ext_keypressed_suma_buffer:
        inc         bx
        mov         _Ext_KEYBOARD_READ,bx
        xor         eax,eax
        jmp short       Ext_keypressed_no
 Ext_keypressed_si:
        mov         bx,offset SELECTOR_REAL_DS
        mov         ds,bx
        mov         bl,al
        cmp         bl,''
        je          Ext_keypressed_CAPS
        cmp         bl,'a'
        jl          Ext_keypressed_CAPS_suma
        sub         bl,20h
 Ext_keypressed_CAPS_suma:
        cmp         bl,'Z'
        jg          Ext_keypressed_no_CAPS
        cmp         bl,'A'
        jl          Ext_keypressed_no_CAPS
 Ext_keypressed_CAPS:        
        mov         bl,_Ext_KEYBOARD_CAPS
        or          bl,bl
        jz          Ext_Keypressed_no_CAPS        
        xchg        al,ah        
 Ext_Keypressed_no_CAPS:
        mov         bl,ds:2Ah[_Ext_KEYBOARD_KEY] ; May Izq ?
        mov         bh,ds:36h[_Ext_KEYBOARD_KEY] ; May Der ?
        or          bl,bh
        jz          Ext_keypressed_no_Mayusculas
        xchg        al,ah
 Ext_Keypressed_no_Mayusculas:
        mov         bl,ds:38h[_Ext_KEYBOARD_KEY] ; Alt Izq ?
        mov         bh,ds:0B8h[_Ext_KEYBOARD_KEY] ; Alt Der ?
        or          bl,bh
        jz          Ext_keypressed_no_Alt
        ror         eax,16
 Ext_keypressed_no_Alt:
        mov         bl,ds:1Dh[_Ext_KEYBOARD_KEY] ; Crtl Izq ?
        mov         bh,ds:9Dh[_Ext_KEYBOARD_KEY] ; Crtl Der ?
        or          bl,bh
        jz          Ext_keypressed_no_Crtl
        rol         eax,8
 Ext_keypressed_no_Crtl:        
        or          al,al
        jnz         Ext_keypressed_no
        mov         eax,-1
        jmp short       Ext_keypressed_salida
 Ext_keypressed_no:
        mov         bl,al
        xor         eax,eax
        mov         al,bl
 Ext_keypressed_salida:        
        pop         ebx
        pop         ds
        retf
Ext_keypressed_ ENDP


Ext_map_ PROC
        push        ds
        push        eax
        mov         ax,offset SELECTOR_REAL_DS
        mov         ds,ax
        mov         eax,ss:[esp]
        mov         dword ptr ds:[_Ext_KEYBOARD_MAP],eax
        xor         eax,eax
        mov         ax,dx
        mov         dword ptr ds:4[_Ext_KEYBOARD_MAP],eax
        pop         eax
        pop         ds
        retf
Ext_map_ ENDP  

Ext_getch_ PROC
        push       ds
        push       ebx
        mov        bx,offset SELECTOR_REAL_DS
        mov        ds,bx
 Ext_getch_otra:
        Llamada32_32 SELECTOR_CS32, Ext_keypressed_
        or         eax,eax
        jz         Ext_getch_otra
        cmp        eax,-1
        jnz        Ext_getch_no_cero
        mov        bl,_KEYBOARD_CERO
        or         bl,bl
        jnz        Ext_getch_cero
        mov        _KEYBOARD_CERO,-1   
        xor        eax,eax
        jmp short      Ext_getch_no_sumar
 Ext_getch_cero:        
        mov        _KEYBOARD_CERO,0
        xor        ebx,ebx
        mov        bx,_Ext_KEYBOARD_READ
        add        ebx,offset _EXT_KEYBOARD_BUFF
        xor        eax,eax
        mov        al,ds:[ebx]
        mov        bl,_Ext_KEYBOARD_NUM
        or         bl,bl
        jnz        Ext_getch_no_cero
        cmp        al,47h        ; 7 Numerico
        jl         Ext_getch_no_cero
        cmp        al,53h        ; . Numerico
        jg         Ext_getch_no_cero
        cmp        al,4Ah        ; - Numerico
        je         Ext_getch_no_cero
        cmp        al,4Eh        ; + Numerico
        je         Ext_getch_no_cero
        add        al,80h
 Ext_getch_no_cero:
        mov        bx,_Ext_KEYBOARD_READ
        cmp        bx,1024
        jne        Ext_getch_suma
        mov        bx,-1
 Ext_getch_suma:
        inc        bx
        mov        _Ext_KEYBOARD_READ,bx
 Ext_getch_no_sumar:
        pop        ebx
        pop        ds
        retf
Ext_getch_ ENDP

Ext_keyhit_ PROC
        push        ds
        push        ebx
        mov         ax,offset SELECTOR_REAL_DS
        mov         ds,ax
        xor         eax,eax
        xor         ebx,ebx
        mov         bx,_Ext_KEYBOARD_READ
        cmp         bx,_Ext_KEYBOARD_WRITE
        je          Ext_keyhit_no
        add         ebx,offset _Ext_KEYBOARD_BUFF
        mov         al,ds:[ebx]
        or          al,al
        je          Ext_keyhit_cero
        mov         ah,al
        mov         bx,ax
        shl         eax,16
        mov         ax,bx
        jmp short       Ext_keyhit_no
 Ext_keyhit_cero:        
        mov         eax,-1
 Ext_keyhit_no:                
        pop         ebx
        pop         ds
        retf
Ext_keyhit_ ENDP

Ext_getkey_ PROC
        push       ds
        push       ebx
        mov        bx,offset SELECTOR_REAL_DS
        mov        ds,bx
 Ext_getkey_otra:
        Llamada32_32 SELECTOR_CS32, Ext_keyhit_
        or         eax,eax
        jz         Ext_getkey_otra
        cmp        eax,-1
        jnz        Ext_getkey_no_cero
        xor        eax,eax
 Ext_getkey_no_cero:
        mov        bx,_Ext_KEYBOARD_READ
        cmp        bx,1024
        jne        Ext_getkey_suma
        mov        bx,-1
 Ext_getkey_suma:
        inc        bx
        mov        _Ext_KEYBOARD_READ,bx        
        pop        ebx
        pop        ds
        retf
Ext_getkey_ ENDP

IRQ2_ISR PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; IRQ2
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_IRQ2_PROC]
        or         eax,DWORD PTR ds:2[_Ext_IRQ2_PROC]
        jz         IRQ2_No_Proc
        pushad
        pushfd
        push       ds
        push       es
        push       fs
        push       gs
        Llamada_DS _Ext_IRQ2_PROC
        pop        gs
        pop        fs
        pop        es
        pop        ds
        popfd
        popad
 IRQ2_No_Proc:
        mov        al,20h
        out        20h,al
        pop        eax
        pop        ds
        iretd
IRQ2_ISR ENDP

IRQ3_ISR PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; IRQ3
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_IRQ3_PROC]
        or         eax,DWORD PTR ds:2[_Ext_IRQ3_PROC]
        jz         IRQ3_No_Proc
        pushad
        pushfd
        push       ds
        push       es
        push       fs
        push       gs
        Llamada_DS _Ext_IRQ3_PROC
        pop        gs
        pop        fs
        pop        es
        pop        ds
        popfd
        popad
 IRQ3_No_Proc:
        mov        al,20h
        out        20h,al
        pop        eax
        pop        ds
        iretd
IRQ3_ISR ENDP

IRQ4_ISR PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; IRQ4
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_IRQ4_PROC]
        or         eax,DWORD PTR ds:2[_Ext_IRQ4_PROC]
        jz         IRQ4_No_Proc
        pushad
        pushfd
        push       ds
        push       es
        push       fs
        push       gs
        Llamada_DS _Ext_IRQ4_PROC
        pop        gs
        pop        fs
        pop        es
        pop        ds
        popfd
        popad
 IRQ4_No_Proc:
        mov        al,20h
        out        20h,al
        pop        eax
        pop        ds
        iretd
IRQ4_ISR ENDP

IRQ5_ISR PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; IRQ5
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_IRQ5_PROC]
        or         eax,DWORD PTR ds:2[_Ext_IRQ5_PROC]
        jz         IRQ5_No_Proc
        pushad
        pushfd
        push       ds
        push       es
        push       fs
        push       gs
        Llamada_DS _Ext_IRQ5_PROC
        pop        gs
        pop        fs
        pop        es
        pop        ds
        popfd
        popad
 IRQ5_No_Proc:
        mov        al,20h
        out        20h,al
        pop        eax
        pop        ds
        iretd
IRQ5_ISR ENDP

IRQ6_ISR PROC FAR               ; Disco flexible
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; IRQ6
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_IRQ6_PROC]
        or         eax,DWORD PTR ds:2[_Ext_IRQ6_PROC]
        jz         IRQ6_No_Proc
        pushad
        pushfd
        push       ds
        push       es
        push       fs
        push       gs
        Llamada_DS _Ext_IRQ6_PROC
        pop        gs
        pop        fs
        pop        es
        pop        ds
        popfd
        popad
 IRQ6_No_Proc:
        mov        al,20h
        out        20h,al
        mov        al,FDC_OPERACION
        or         al,al
        jz         IRQ6_Salida
        mov        FDC_OPERACION,-1
 IRQ6_Salida:
        pop        eax
        pop        ds
        iretd
IRQ6_ISR ENDP

FDC_Out PROC FAR             ; AL = Dato a mandar
        push      dx
        push      ecx
        rol       eax,16
        xor       ecx,ecx
 FDC_Out_Otra:
        mov       dx,PFDC_STATUS
        in        al,dx
        test      al,128
        jnz       FDC_Out_Hacer
        loop      FDC_Out_Otra
        mov       eax,-1
        jmp short     FDC_Out_Error
 FDC_Out_Hacer:
        ror       eax,16
        mov       dx,PFDC_DATA
        out       dx,al
        xor       eax,eax
 FDC_Out_Error:                 ; EAX = 0 Bien , -1 Error
        pop       ecx
        pop       dx
        retf
FDC_Out ENDP

FDC_In PROC FAR
        push      dx
        push      ecx
        xor       ecx,ecx
 FDC_In_Otra:
        mov       dx,PFDC_STATUS
        in        al,dx
        test      al,128
        jnz       FDC_In_Hacer
        loop      FDC_In_Otra
        mov       eax,-1
        jmp short     FDC_In_Error
 FDC_In_Hacer:
        xor       eax,eax
        mov       dx,PFDC_DATA
        in        al,dx
 FDC_In_Error:                 ; EAX = -1 Error
        pop       ecx
        pop       dx
        retf
FDC_In ENDP

Ext_FDC_MotorON_ PROC FAR    ; EAX = Unidad ( 0 .. 3 )
        push     eax
        push     ebx
        push     ecx
        push     edx
        and      eax,3
        mov      ecx,eax
        inc      ecx
        mov      ebx,8
 Ext_FDC_MotorON__otra:
        shl      ebx,1
        loop     Ext_FDC_MotorON__otra
        add      eax,4+8
        or       eax,ebx
        mov      dx,PFDC_DIGITAL
        out      dx,al
        pop      edx
        pop      ecx
        pop      ebx
        pop      eax
        retf
Ext_FDC_MotorON_ ENDP

Ext_FDC_MotorOFF_ PROC FAR   ; EAX = Unidad ( 0 .. 3 )
        push     eax
        push     edx
        and      eax,3
        add      eax,4+8
        mov      dx,PFDC_DIGITAL
        out      dx,al
        pop      edx
        pop      eax
        retf
Ext_FDC_MotorOFF_ ENDP

FDC_DMA PROC FAR     ;EAX = Modo , EDX = Bytes , EBX = Offset
        pushad
        mov      ecx,edx
        dec      ecx
        mov      esi,eax
        mov      al,9
        mov      dx,81h
        out      dx,al
        mov      dx,0bh
        mov      eax,esi
        out      dx,al
        mov      dx,0ch
        xor      eax,eax
        out      dx,al
        mov      dx,4
        mov      al,bl
        out      dx,al
        mov      al,bh
        out      dx,al
        mov      dx,5
        mov      al,cl
        out      dx,al
        mov      al,ch
        out      dx,al
        mov      dx,0ah
        mov      al,2
        out      dx,al
        popad
        retf
FDC_DMA ENDP

FDC_DisableInt PROC FAR
        push   eax
        in     al,PICA01
        or     al,01000000b
        out    PICA01,al
        pop    eax
        retf
FDC_DisableInt ENDP

FDC_EnableInt PROC FAR
        push   eax
        in     al,PICA01
        and    al,10111111b
        out    PICA01,al
        pop    eax
        retf
FDC_EnableInt ENDP

FDC_WaitInt PROC FAR
        push    ds
        push    ecx
        push    edx
        pushfd
        Llamada32_32 SELECTOR_CS32,FDC_EnableInt
        sti
        mov      ecx,eax
        mov      ax,offset SELECTOR_DS
        mov      ds,ax
 FDC_WaitInt_Otra2:
        mov      edx,_Ext_TIMER_COUNT
 FDC_WaitInt_Otra:
        xor      eax,eax
        cmp      FDC_OPERACION,-1
        je       FDC_WaitInt_Salir
        cmp      edx,_Ext_TIMER_COUNT
        je       FDC_WaitInt_Otra
        int      30h
        loop     FDC_WaitInt_Otra2
        mov      eax,-1
 FDC_WaitInt_Salir:
        popfd
        pop      edx
        pop      ecx
        pop      ds
        retf
FDC_WaitInt ENDP


Ext_FDC_Select_ PROC FAR  ; EAX = Unidad , EDX = Velocidad
        push     ds
        push     ebx
        push     ecx
        push     edx
        mov      cx,offset SELECTOR_DS
        mov      ds,cx
        mov      cl,FDC_OPERACION
        or       cl,cl
        jnz      Ext_FDC_Select__Error2
        cli
        mov      FDC_OPERACION,1
        mov      _Ext_FDC_UNIDAD,al
        mov      _Ext_FDC_VELOCIDAD,dl
        Llamada32_32 SELECTOR_CS32,FDC_EnableInt
        sti
        mov      ecx,eax
        mov      eax,edx
        mov      dx,PFDC_CONTROL
        out      dx,al
        push     ecx
        push     ecx
        inc      ecx
        mov      dx,8
 Ext_FDC_Select__Otra:
        shl      dx,1
        loop     Ext_FDC_Select__Otra
        pop      ecx
        add      cx,dx
        mov      ax,8
        add      ax,cx
        mov      dx,PFDC_DIGITAL
        out      dx,al
        pop      ecx
        push     ecx
        inc      ecx
        mov      dx,8
 Ext_FDC_Select__Otra2:
        shl      dx,1
        loop     Ext_FDC_Select__Otra
        pop      ecx
        add      dx,cx
        mov      eax,8+4
        add      ax,dx
        mov      dx,PFDC_DIGITAL
        out      dx,al
        mov      eax,36
        Llamada32_32 SELECTOR_CS32,FDC_WaitInt
        or       eax,eax
        jnz      Ext_FDC_Select__Error
        mov      eax,8
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or       eax,eax
        jnz      Ext_FDC_Select__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        Llamada32_32 SELECTOR_CS32,FDC_In
        mov      eax,3
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or       eax,eax
        jnz      Ext_FDC_Select__Error
        mov      al,_Ext_FDC_VELOCIDAD
        or       al,al
        jnz      Ext_FDC_Select__No0
        mov      eax,0BFh
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or       al,al
        jnz      Ext_FDC_Select__Error
        jmp short    Ext_FDC_Select__Ok
 Ext_FDC_Select__No0:
        cmp      al,3
        jne      Ext_FDC_Select__Else
        mov      eax,0AFh
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or       al,al
        jnz      Ext_FDC_Select__Error
        jmp short    Ext_FDC_Select__Ok
 Ext_FDC_Select__Else:
        mov      eax,0DFh
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or       al,al
        jnz      Ext_FDC_Select__Error
 Ext_FDC_Select__Ok:
        mov      eax,2
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or       al,al
        jnz      Ext_FDC_Select__Error
        xor      eax,eax
 Ext_FDC_Select__Salir:
        mov      FDC_OPERACION,0
        mov      _Ext_FDC_CABEZAL,0
        mov      _Ext_FDC_CILINDRO,0
 Ext_FDC_Select__Salir2:
        pop      edx
        pop      ecx
        pop      ebx
        pop      ds
        retf
 Ext_FDC_Select__Error:
        mov      eax,-1
        jmp short    Ext_FDC_Select__Salir
 Ext_FDC_Select__Error2:
        mov      eax,-1
        jmp short    Ext_FDC_Select__Salir2
Ext_FDC_Select_ ENDP

Ext_FDC_Recalibrate_ PROC FAR        ; EAX= CABEZAL
        push     ds
        push     ebx
        push     ecx
        push     edx
        xor      ebx,ebx
        mov      bl,al
        shl      bl,2
        mov      ax,offset SELECTOR_DS
        mov      ds,ax
        cmp      FDC_OPERACION,0
        jne      Ext_FDC_Recalibrate__Error2
        xor      eax,eax
        mov      al,_Ext_FDC_UNIDAD
        or       bl,al
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorON_
        mov      ecx,5
 Ext_FDC_Recalibrate__Otra:
        cli
        mov      FDC_OPERACION,1
        Llamada32_32 SELECTOR_CS32,FDC_EnableInt
        sti
        mov      eax,7
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or       eax,eax
        jnz      Ext_FDC_Recalibrate__Error
        mov      eax,ebx
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or       eax,eax
        jnz      Ext_FDC_Recalibrate__Error
        mov      eax,37
        Llamada32_32 SELECTOR_CS32,FDC_WaitInt
        or       eax,eax
        jnz      Ext_FDC_Recalibrate__Error
        mov      eax,8
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or       eax,eax
        jnz      Ext_FDC_Recalibrate__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or       eax,eax
        js       Ext_FDC_Recalibrate__Error
        mov      dl,32
        xor      dl,al
        and      dl,0F0h
        Llamada32_32 SELECTOR_CS32,FDC_In
        or       eax,eax
        js       Ext_FDC_Recalibrate__Error
        or       dl,dl
        jz       Ext_FDC_Recalibrate__Ok
        loop     Ext_FDC_Recalibrate__Otra
 Ext_FDC_Recalibrate__Error:
        mov      FDC_OPERACION,0
        mov      al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
 Ext_FDC_Recalibrate__Error2:
        mov      eax,-1
 Ext_FDC_Recalibrate__Salir:
        pop      edx
        pop      ecx
        pop      ebx
        pop      ds
        retf
 Ext_FDC_Recalibrate__Ok:
        mov      _Ext_FDC_CILINDRO,0
        mov      FDC_OPERACION,0
        mov      al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
        xor      eax,eax
        jmp short    Ext_FDC_Recalibrate__Salir
Ext_FDC_Recalibrate_ ENDP

Ext_FDC_Seek_ PROC FAR       ; EAX = Cabezal , EDX = Cilindro
        push    ds
        push    ebx
        push    edx
        mov     bx,offset SELECTOR_DS
        mov     ds,bx
        cmp     FDC_OPERACION,0
        jnz     Ext_FDC_Seek__Error2
        cli
        mov     FDC_OPERACION,1
        mov     _Ext_FDC_CABEZAL,al
        mov     _Ext_FDC_CILINDRO,dl
        Llamada32_32 SELECTOR_CS32,FDC_EnableInt
        sti
        xor     ebx,ebx
        mov     bl,al
        shl     bl,2
        xor     eax,eax
        mov     al,_Ext_FDC_UNIDAD
        or      bl,al
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorON_
        mov     eax,0Fh
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Seek__Error
        mov     al,bl
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Seek__Error
        mov     al,_Ext_FDC_CILINDRO
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Seek__Error
        mov     eax,37
        Llamada32_32 SELECTOR_CS32,FDC_WaitInt
        or      eax,eax
        jnz     Ext_FDC_Seek__Error
        mov     eax,8
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Seek__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Seek__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Seek__Error
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
        xor     eax,eax
 Ext_FDC_Seek__Salir:
        mov     FDC_OPERACION,0
        pop     edx
        pop     ebx
        pop     ds
        retf
 Ext_FDC_Seek__Error:
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
 Ext_FDC_Seek__Error2:
        mov     eax,-1
        jmp short Ext_FDC_Seek__Salir
Ext_FDC_Seek_ ENDP

Ext_FDC_Read_ PROC FAR       ; EAX = CABEZAL , EDX = CILINDRO , EBX = OFFSET
        push    ebp          ; ECX = TAMAO , SS: SECTOR , nSECTORES
        mov     ebp,esp
        push    ds
        pushad
        push    bx
        mov     bx,offset SELECTOR_DS
        mov     ds,bx
        pop     bx
        cmp     FDC_OPERACION,0
        jnz     Ext_FDC_Read__Error2
        cmp     _Ext_FDC_CABEZAL,al
        jne     Ext_FDC_Read__HacerSeek
        cmp     _Ext_FDC_CILINDRO,dl
        je      Ext_FDC_Read__NoHacerSeek
 Ext_FDC_Read__HacerSeek:
        Llamada32_32 SELECTOR_CS32,Ext_FDC_Seek_
        or      eax,eax
        jnz     Ext_FDC_Read__Error2
 Ext_FDC_Read__NoHacerSeek:
        cli
        mov     FDC_OPERACION,1
        Llamada32_32 SELECTOR_CS32,FDC_EnableInt
        sti
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorON_
        push    ebx
        xor     edx,edx
        mov     eax,ecx
        mov     ebx,ss:[ebp+16]
        or      ebx,ebx
        jz      Ext_FDC_ReadZero
        mul     ebx
Ext_FDC_ReadZero:
        mov     edx,eax
        pop     ebx
        mov     eax,46h
        Llamada32_32 SELECTOR_CS32,FDC_DMA
        mov     eax,70
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        mov     al,_Ext_FDC_CABEZAL
        shl     eax,2
        add     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        mov     al,_Ext_FDC_CILINDRO
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        mov     al,_Ext_FDC_CABEZAL
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        mov     ax,ss:[ebp+12]
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        mov     ax,cx
        shr     ax,8
        mov     di,ax
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        mov     eax,ss:[ebp+12]
        add     eax,ss:[ebp+16]
        dec     eax
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        mov     eax,1
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        mov     eax,edx
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        mov     eax,50
        Llamada32_32 SELECTOR_CS32,FDC_WaitInt
        or      eax,eax
        jnz     Ext_FDC_Read__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Read__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Read__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Read__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Read__Error
        mov     edx,eax                 ; Cilindro
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Read__Error
        mov     ebx,eax                 ; Cabezal
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Read__Error
        mov     ecx,eax                 ; Sector
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Read__Error
        push    eax
        mov     FDC_OPERACION,0
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
        pop     eax
        dec     edx
        cmp     ax,di
        jne     Ext_FDC_Read__Error
        cmp     cx,1
        jne     Ext_FDC_Read__Error
        cmp     bl,_Ext_FDC_CABEZAL
        jne     Ext_FDC_Read__Error
        cmp     dl,_Ext_FDC_CILINDRO
        jne     Ext_FDC_Read__Error
        popad
        pop     ds
        pop     ebp
        xor     eax,eax
        retf    8
 Ext_FDC_Read__Error:
        mov     FDC_OPERACION,0
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
 Ext_FDC_Read__Error2:
        popad
        pop     ds
        pop     ebp
        mov     eax,-1
        retf    8
Ext_FDC_Read_ ENDP

Ext_FDC_Write_ PROC FAR  ; EAX = CABEZAL , EDX = CILINDRO , EBX = OFFSET
        push    ebp      ; ECX = TAMAO , SS: SECTOR,numSectores,GAP
        mov     ebp,esp
        push    ds
        pushad
        push    bx
        mov     bx,offset SELECTOR_DS
        mov     ds,bx
        pop     bx
        cmp     FDC_OPERACION,0
        jnz     Ext_FDC_Write__Error2
        cmp     _Ext_FDC_CABEZAL,al
        jne     Ext_FDC_Write__HacerSeek
        cmp     _Ext_FDC_CILINDRO,dl
        je      Ext_FDC_Write__NoHacerSeek
 Ext_FDC_Write__HacerSeek:
        Llamada32_32 SELECTOR_CS32,Ext_FDC_Seek_
        or      eax,eax
        jnz     Ext_FDC_Write__Error2
 Ext_FDC_Write__NoHacerSeek:
        cli
        mov     FDC_OPERACION,1
        Llamada32_32 SELECTOR_CS32,FDC_EnableInt
        sti
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorON_
        push    ebx
        xor     edx,edx
        mov     eax,ecx
        mov     ebx,ss:[ebp+16]
        or      ebx,ebx
        jz      Ext_FDC_WriteZero
        mul     ebx
 Ext_FDC_WriteZero:
        mov     edx,eax
        pop     ebx
        mov     eax,4Ah
        Llamada32_32 SELECTOR_CS32,FDC_DMA
        mov     eax,69
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        mov     al,_Ext_FDC_CABEZAL
        shl     eax,2
        add     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        mov     al,_Ext_FDC_CILINDRO
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        mov     al,_Ext_FDC_CABEZAL
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        mov     eax,ss:[ebp+12]
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        mov     ax,cx
        shr     ax,8
        mov     di,ax
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        mov     eax,ss:[ebp+12]
        add     eax,ss:[ebp+16]
        dec     eax
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        mov     eax,ss:[ebp+20]
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        mov     eax,edx
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        mov     eax,50
        Llamada32_32 SELECTOR_CS32,FDC_WaitInt
        or      eax,eax
        jnz     Ext_FDC_Write__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Write__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Write__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Write__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Write__Error
        mov     edx,eax                 ; Cilindro
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Write__Error
        mov     ebx,eax                 ; Cabezal
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Write__Error
        mov     ecx,eax                 ; Sector
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Write__Error
        push    eax
        mov     FDC_OPERACION,0
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
        pop     eax
        dec     edx
        cmp     ax,di
        jne     Ext_FDC_Write__Error2
        cmp     cx,1
        jne     Ext_FDC_Write__Error2
        cmp     bl,_Ext_FDC_CABEZAL
        jne     Ext_FDC_Write__Error2
        cmp     dl,_Ext_FDC_CILINDRO
        jne     Ext_FDC_Write__Error2
        popad
        pop     ds
        pop     ebp
        xor     eax,eax
        retf    12
 Ext_FDC_Write__Error:
        mov     FDC_OPERACION,0
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
 Ext_FDC_Write__Error2:
        popad
        pop     ds
        pop     ebp
        mov     eax,-1
        retf    12
Ext_FDC_Write_ ENDP

Ext_FDC_Format_ PROC FAR       ; EAX = TAMAO , EDX = GAP , EBX = OFFSET
        push    ebp      ; ECX = TAMAO , SS: GAP,nSectores,ByteINIT
        mov     ebp,esp
        push    ds
        pushad
        push    bx
        mov     bx,offset SELECTOR_DS
        mov     ds,bx
        pop     bx
        cmp     FDC_OPERACION,0
        jnz     Ext_FDC_Format__Error2
        cli
        mov     FDC_OPERACION,1
        mov     _Ext_FDC_CABEZAL,al
        mov     _Ext_FDC_CILINDRO,dl
        Llamada32_32 SELECTOR_CS32,FDC_EnableInt
        sti
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorON_
        push    es
        push    ecx
        mov     ax,offset SELECTOR_DMA
        mov     es,ax
        mov     eax,ecx
        mov     al,1
        shl     eax,8
        mov     al,_Ext_FDC_CABEZAL
        shl     eax,8
        mov     al,_Ext_FDC_CILINDRO
        mov     ecx,ss:[ebp+16]
        mov     edi,ebx
        cld
 Ext_FDC_Format__Otra:
        stosd
        add     eax,10000h
        loop    Ext_FDC_Format__Otra
        pop     ecx
        pop     es
        mov     edx,ss:[ebp+16]
        shl     edx,2
        mov     eax,4Ah
        Llamada32_32 SELECTOR_CS32,FDC_DMA
        mov     eax,77
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Format__Error
        mov     al,_Ext_FDC_CABEZAL
        shl     eax,2
        add     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Format__Error
        mov     eax,ecx
        shr     eax,8
        mov     edi,eax
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Format__Error
        mov     eax,ss:[ebp+16]
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Format__Error
        mov     eax,ss:[ebp+12]
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Format__Error
        mov     eax,ss:[ebp+20]
        Llamada32_32 SELECTOR_CS32,FDC_Out
        or      eax,eax
        jnz     Ext_FDC_Format__Error
        mov     eax,50
        Llamada32_32 SELECTOR_CS32,FDC_WaitInt
        or      eax,eax
        jnz     Ext_FDC_Format__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Format__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Format__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Format__Error
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Format__Error
        mov     edx,eax                 ; Cilindro
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Format__Error
        mov     ebx,eax                 ; Cabezal
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Format__Error
        mov     ecx,eax                 ; Sector
        Llamada32_32 SELECTOR_CS32,FDC_In
        or      eax,eax
        js      Ext_FDC_Format__Error
        push    eax
        mov     FDC_OPERACION,0
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
        pop     eax
        cmp     ax,di
        jne     Ext_FDC_Format__Error2
        mov     esi,ss:[ebp+16]
        cmp     cx,si
        jne     Ext_FDC_Format__Error2
        cmp     bl,_Ext_FDC_CABEZAL
        jne     Ext_FDC_Format__Error2
        cmp     dl,_Ext_FDC_CILINDRO
        jne     Ext_FDC_Format__Error2
        popad
        pop     ds
        pop     ebp
        xor     eax,eax
        retf    12
 Ext_FDC_Format__Error:
        mov     FDC_OPERACION,0
        mov     al,_Ext_FDC_UNIDAD
        Llamada32_32 SELECTOR_CS32,Ext_FDC_MotorOFF_
 Ext_FDC_Format__Error2:
        popad
        pop     ds
        pop     ebp
        mov     eax,-1
        retf    12
Ext_FDC_Format_ ENDP

IRQ7_ISR PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; IRQ7
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_IRQ7_PROC]
        or         eax,DWORD PTR ds:2[_Ext_IRQ7_PROC]
        jz         IRQ7_No_Proc
        pushad
        pushfd
        push       ds
        push       es
        push       fs
        push       gs
        Llamada_DS _Ext_IRQ7_PROC
        pop        gs
        pop        fs
        pop        es
        pop        ds
        popfd
        popad
 IRQ7_No_Proc:
        mov        al,20h
        out        20h,al
        pop        eax
        pop        ds
        iretd
IRQ7_ISR ENDP

IRQ8_ISR PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; IRQ8
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_IRQ8_PROC]
        or         eax,DWORD PTR ds:2[_Ext_IRQ8_PROC]
        jz         IRQ8_No_Proc
        pushad
        pushfd
        push       ds
        push       es
        push       fs
        push       gs
        Llamada_DS _Ext_IRQ8_PROC
        pop        gs
        pop        fs
        pop        es
        pop        ds
        popfd
        popad
 IRQ8_No_Proc:
        push       edx
        mov        dx,0A0h
        mov        al,20h
        out        dx,al
        pop        edx
        pop        eax
        pop        ds
        iretd
IRQ8_ISR ENDP

IRQ9_ISR PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; IRQ9
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_IRQ9_PROC]
        or         eax,DWORD PTR ds:2[_Ext_IRQ9_PROC]
        jz         IRQ9_No_Proc
        pushad
        pushfd
        push       ds
        push       es
        push       fs
        push       gs
        Llamada_DS _Ext_IRQ9_PROC
        pop        gs
        pop        fs
        pop        es
        pop        ds
        popfd
        popad
 IRQ9_No_Proc:
        push       edx
        mov        dx,0A0h
        mov        al,20h
        out        dx,al
        pop        edx
        pop        eax
        pop        ds
        iretd
IRQ9_ISR ENDP

IRQA_ISR PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; IRQA
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_IRQA_PROC]
        or         eax,DWORD PTR ds:2[_Ext_IRQA_PROC]
        jz         IRQA_No_Proc
        pushad
        pushfd
        push       ds
        push       es
        push       fs
        push       gs
        Llamada_DS _Ext_IRQA_PROC
        pop        gs
        pop        fs
        pop        es
        pop        ds
        popfd
        popad
 IRQA_No_Proc:
        push       edx
        mov        dx,0A0h
        mov        al,20h
        out        dx,al
        pop        edx
        pop        eax
        pop        ds
        iretd
IRQA_ISR ENDP

IRQB_ISR PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; IRQB
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_IRQB_PROC]
        or         eax,DWORD PTR ds:2[_Ext_IRQB_PROC]
        jz         IRQB_No_Proc
        pushad
        pushfd
        push       ds
        push       es
        push       fs
        push       gs
        Llamada_DS _Ext_IRQB_PROC
        pop        gs
        pop        fs
        pop        es
        pop        ds
        popfd
        popad
 IRQB_No_Proc:
        push       edx
        mov        dx,0A0h
        mov        al,20h
        out        dx,al
        pop        edx
        pop        eax
        pop        ds
        iretd
IRQB_ISR ENDP

IRQC_ISR PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; IRQC
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_IRQC_PROC]
        or         eax,DWORD PTR ds:2[_Ext_IRQC_PROC]
        jz         IRQC_No_Proc
        pushad
        pushfd
        push       ds
        push       es
        push       fs
        push       gs
        Llamada_DS _Ext_IRQC_PROC
        pop        gs
        pop        fs
        pop        es
        pop        ds
        popfd
        popad
 IRQC_No_Proc:
        push       edx
        mov        dx,0A0h
        mov        al,20h
        out        dx,al
        pop        edx
        pop        eax
        pop        ds
        iretd
IRQC_ISR ENDP

IRQD_ISR PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; IRQD
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_IRQD_PROC]
        or         eax,DWORD PTR ds:2[_Ext_IRQD_PROC]
        jz         IRQD_No_Proc
        pushad
        pushfd
        push       ds
        push       es
        push       fs
        push       gs
        Llamada_DS _Ext_IRQD_PROC
        pop        gs
        pop        fs
        pop        es
        pop        ds
        popfd
        popad
 IRQD_No_Proc:
        push       edx
        mov        dx,0A0h
        mov        al,20h
        out        dx,al
        pop        edx
        pop        eax
        pop        ds
        iretd
IRQD_ISR ENDP

IRQE_ISR PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; IRQE
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_IRQE_PROC]
        or         eax,DWORD PTR ds:2[_Ext_IRQE_PROC]
        jz         IRQE_No_Proc
        pushad
        pushfd
        push       ds
        push       es
        push       fs
        push       gs
        Llamada_DS _Ext_IRQE_PROC
        pop        gs
        pop        fs
        pop        es
        pop        ds
        popfd
        popad
 IRQE_No_Proc:
        push       edx
        mov        dx,0A0h
        mov        al,20h
        out        dx,al
        pop        edx
        pop        eax
        pop        ds
        iretd
IRQE_ISR ENDP

IRQF_ISR PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; IRQF
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_IRQF_PROC]
        or         eax,DWORD PTR ds:2[_Ext_IRQF_PROC]
        jz         IRQF_No_Proc
        pushad
        pushfd
        push       ds
        push       es
        push       fs
        push       gs
        Llamada_DS _Ext_IRQF_PROC
        pop        gs
        pop        fs
        pop        es
        pop        ds
        popfd
        popad
 IRQF_No_Proc:
        push       edx
        mov        dx,0A0h
        mov        al,20h
        out        dx,al
        pop        edx
        pop        eax
        pop        ds
        iretd
IRQF_ISR ENDP

TRAP_32 PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; TRAP 32h
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_TRAP32_PROC]
        or         eax,DWORD PTR ds:2[_Ext_TRAP32_PROC]
        jnz        TRAP32_Proc
        pop        eax
 TRAP32_No_Proc:
        pop        ds
        iretd
 TRAP32_Proc:
        pop        eax
        Llamada_DS _Ext_TRAP32_PROC
        jmp short TRAP32_No_Proc
TRAP_32 ENDP

TRAP_33 PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; TRAP 33h
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_TRAP33_PROC]
        or         eax,DWORD PTR ds:2[_Ext_TRAP33_PROC]
        jnz        TRAP33_Proc
        pop        eax
 TRAP33_No_Proc:
        pop        ds
        iretd
 TRAP33_Proc:
        pop        eax
        Llamada_DS _Ext_TRAP33_PROC
        jmp short TRAP33_No_Proc
TRAP_33 ENDP

TRAP_34 PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; TRAP 34h
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_TRAP34_PROC]
        or         eax,DWORD PTR ds:2[_Ext_TRAP34_PROC]
        jnz        TRAP34_Proc
        pop        eax
 TRAP34_No_Proc:
        pop        ds
        iretd
 TRAP34_Proc:
        pop        eax
        Llamada_DS _Ext_TRAP34_PROC
        jmp short TRAP34_No_Proc
TRAP_34 ENDP

TRAP_35 PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; TRAP 35h
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_TRAP35_PROC]
        or         eax,DWORD PTR ds:2[_Ext_TRAP35_PROC]
        jnz        TRAP35_Proc
        pop        eax
 TRAP35_No_Proc:
        pop        ds
        iretd
 TRAP35_Proc:
        pop        eax
        Llamada_DS _Ext_TRAP35_PROC
        jmp short TRAP35_No_Proc
TRAP_35 ENDP

TRAP_36 PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; TRAP 36h
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_TRAP36_PROC]
        or         eax,DWORD PTR ds:2[_Ext_TRAP36_PROC]
        jnz        TRAP36_Proc
        pop        eax
 TRAP36_No_Proc:
        pop        ds
        iretd
 TRAP36_Proc:
        pop        eax
        Llamada_DS _Ext_TRAP36_PROC
        jmp short TRAP36_No_Proc
TRAP_36 ENDP

TRAP_37 PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; TRAP 37h
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_TRAP37_PROC]
        or         eax,DWORD PTR ds:2[_Ext_TRAP37_PROC]
        jnz        TRAP37_Proc
        pop        eax
 TRAP37_No_Proc:
        pop        ds
        iretd
 TRAP37_Proc:
        pop        eax
        Llamada_DS _Ext_TRAP37_PROC
        jmp short TRAP37_No_Proc
TRAP_37 ENDP

TRAP_38 PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; TRAP 38h
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_TRAP38_PROC]
        or         eax,DWORD PTR ds:2[_Ext_TRAP38_PROC]
        jnz        TRAP38_Proc
        pop        eax
 TRAP38_No_Proc:
        pop        ds
        iretd
 TRAP38_Proc:
        pop        eax
        Llamada_DS _Ext_TRAP38_PROC
        jmp short TRAP38_No_Proc
TRAP_38 ENDP

TRAP_39 PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; TRAP 39h
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_TRAP39_PROC]
        or         eax,DWORD PTR ds:2[_Ext_TRAP39_PROC]
        jnz        TRAP39_Proc
        pop        eax
 TRAP39_No_Proc:
        pop        ds
        iretd
 TRAP39_Proc:
        pop        eax
        Llamada_DS _Ext_TRAP39_PROC
        jmp short TRAP39_No_Proc
TRAP_39 ENDP

TRAP_3A PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; TRAP 3Ah
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_TRAP3A_PROC]
        or         eax,DWORD PTR ds:2[_Ext_TRAP3A_PROC]
        jnz        TRAP3A_Proc
        pop        eax
 TRAP3A_No_Proc:
        pop        ds
        iretd
 TRAP3A_Proc:
        pop        eax
        Llamada_DS _Ext_TRAP3A_PROC
        jmp short TRAP3A_No_Proc
TRAP_3A ENDP

TRAP_3B PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; TRAP 3Bh
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_TRAP3B_PROC]
        or         eax,DWORD PTR ds:2[_Ext_TRAP3B_PROC]
        jnz        TRAP3B_Proc
        pop        eax
 TRAP3B_No_Proc:
        pop        ds
        iretd
 TRAP3B_Proc:
        pop        eax
        Llamada_DS _Ext_TRAP3B_PROC
        jmp short TRAP3B_No_Proc
TRAP_3B ENDP

TRAP_3C PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; TRAP 3Ch
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_TRAP3C_PROC]
        or         eax,DWORD PTR ds:2[_Ext_TRAP3C_PROC]
        jnz        TRAP3C_Proc
        pop        eax
 TRAP3C_No_Proc:
        pop        ds
        iretd
 TRAP3C_Proc:
        pop        eax
        Llamada_DS _Ext_TRAP3C_PROC
        jmp short TRAP3C_No_Proc
TRAP_3C ENDP

TRAP_3D PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; TRAP 3Dh
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_TRAP3D_PROC]
        or         eax,DWORD PTR ds:2[_Ext_TRAP3D_PROC]
        jnz        TRAP3D_Proc
        pop        eax
 TRAP3D_No_Proc:
        pop        ds
        iretd
 TRAP3D_Proc:
        pop        eax
        Llamada_DS _Ext_TRAP3D_PROC
        jmp short TRAP3D_No_Proc
TRAP_3D ENDP

TRAP_3E PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; TRAP 3Eh
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_TRAP3E_PROC]
        or         eax,DWORD PTR ds:2[_Ext_TRAP3E_PROC]
        jnz        TRAP3E_Proc
        pop        eax
 TRAP3E_No_Proc:
        pop        ds
        iretd
 TRAP3E_Proc:
        pop        eax
        Llamada_DS _Ext_TRAP3E_PROC
        jmp short TRAP3E_No_Proc
TRAP_3E ENDP

TRAP_3F PROC FAR
        push       ds
        push       eax
        mov        ax,offset SELECTOR_DS      ; TRAP 3Fh
        mov        ds,ax
        mov        eax,DWORD PTR ds:[_Ext_TRAP3F_PROC]
        or         eax,DWORD PTR ds:2[_Ext_TRAP3F_PROC]
        jnz        TRAP3F_Proc
        pop        eax
 TRAP3F_No_Proc:
        pop        ds
        iretd
 TRAP3F_Proc:
        pop        eax
        Llamada_DS _Ext_TRAP3F_PROC
        jmp short TRAP3F_No_Proc
TRAP_3F ENDP

DPMI_trap PROC FAR
        cli
        cld
        push       ds
        push       es
        push       fs
        push       gs
        pushad
        or         ax,ax
        jne short DPMI_No0000
        Salto32_32 SELECTOR_CS32,DPMI_AllocateDescriptors
 DPMI_No0000:
        cmp        ax,1
        jne short DPMI_No0001
        Salto32_32 SELECTOR_CS32,DPMI_FreeDescriptors
 DPMI_No0001:                
        cmp        ax,3
        jne short DPMI_No0003
        Salto32_32 SELECTOR_CS32,DPMI_Increment
 DPMI_No0003:
        cmp        ax,6
        jne short DPMI_No0006
        Salto32_32 SELECTOR_CS32,DPMI_GetBase
 DPMI_No0006: 
        cmp        ax,7
        jne short DPMI_No0007
        Salto32_32 SELECTOR_CS32,DPMI_SetBase
 DPMI_No0007: 
        cmp        ax,8
        jne short DPMI_No0008
        Salto32_32 SELECTOR_CS32,DPMI_SetLimit
 DPMI_No0008: 
        cmp        ax,9
        jne short DPMI_No0009
        Salto32_32 SELECTOR_CS32,DPMI_SetAccess
 DPMI_No0009: 
        cmp        ax,500h
        jne short DPMI_No0500
        Salto32_32 SELECTOR_CS32,DPMI_FreeMem
 DPMI_No0500:        
        cmp        ax,501h
        jne short DPMI_No0501
        Salto32_32 SELECTOR_CS32,DPMI_AllocateMem
 DPMI_No0501:        
        cmp        ax,502h
        jne short DPMI_No0502
        Salto32_32 SELECTOR_CS32,DPMI_FreeMemBlock
 DPMI_No0502:
 
DPMI_Fail8001:
        mov word ptr [esp+28],8001h
        jmp short DPMI_Fail
DPMI_Fail8024:
        mov word ptr [esp+28],8024h
        jmp short DPMI_Fail
DPMI_Fail8023:
        mov word ptr [esp+28],8023h
        jmp short DPMI_Fail
DPMI_Fail8022:
        mov word ptr [esp+28],8022h
        jmp short DPMI_Fail
DPMI_Fail8021:
        mov word ptr [esp+28],8021h
        jmp short DPMI_Fail
DPMI_Fail8016:
        mov word ptr [esp+28],8016h
        jmp short DPMI_Fail
DPMI_Fail8015:
        mov word ptr [esp+28],8015h
        jmp short DPMI_Fail
DPMI_Fail8013:
        mov word ptr [esp+28],8013h
        jmp short DPMI_Fail
DPMI_Fail8012:
        mov word ptr [esp+28],8012h
        jmp short DPMI_Fail
DPMI_Fail8011:
        mov word ptr [esp+28],8011h
        jmp short DPMI_Fail
DPMI_Fail8010:
        mov word ptr [esp+28],8010h
        jmp short DPMI_Fail
DPMI_Fail8021_0:
        jmp short DPMI_Fail8021
DPMI_FailCX:
        mov word ptr [esp+24],cx
        jmp short DPMI_Fail
DPMI_FailAX:
        mov word ptr [esp+28],ax
DPMI_Fail:
        popad
        pop         gs
        pop         fs
        pop         es
        pop         ds
DPMI_FailNoPop:        
        or byte ptr [esp+8],1
        iretd        
DPMI_OkEDX:
        mov        [esp+20],edx
        jmp short DPMI_OkCX
DPMI_OkDX:
        mov        [esp+20],dx
        jmp short DPMI_OkCX
DPMI_Fail8023_0:
        jmp short DPMI_Fail8023
DPMI_OkECX:
        mov        [esp+24],ecx        
DPMI_OkEAX:
        mov        [esp+28],eax
        jmp short DPMI_Ok        
DPMI_OkSINoAX:
        mov        eax,[esp+28]
DPMI_OkSI:
        mov        [esp+4],si
        mov        [esp],di
        mov        [esp+16],bx
DPMI_OkCX:
        mov        [esp+24],cx
DPMI_OkAX:
        mov        [esp+28],ax
DPMI_Ok:
        popad
        pop         gs
        pop         fs
        pop         es
        pop         ds
DPMI_OkNoPop:        
        and byte ptr [esp+8],0feh
        iretd
DPMI_trap ENDP

DPMI_Fail8021_2:
        jmp short DPMI_Fail8021_0

DPMI_Fail8011_2:
        jmp short DPMI_Fail8011

DPMI_OkDX2:
        jmp short DPMI_OkDX
DPMI_Ok2:
        jmp short DPMI_Ok
DPMI_OkSI_2:
        jmp short DPMI_OkSI
DPMI_Fail8010_2:
        jmp short DPMI_Fail8010
DPMI_OkECX_2:
        jmp short DPMI_OkECX
DPMI_Fail8023_2:
        jmp short DPMI_Fail8023_0

DPMI_AllocateDescriptors PROC FAR
        or         cx,cx
        jz         DPMI_Fail8021
        cmp        cx,MAX_SEL*8
        jge        DPMI_Fail8021
        mov        bx,offset SELECTOR_GDT
        mov        ds,bx
        mov        ebx,offset SELECTORES_SISTEMA
        mov        eax,ebx
        movzx      edx,cx
        mov        ecx,edx
 DPMI_AllocateDescriptors_otro:
        test byte ptr ds:6[ebx],10h
        jnz DPMI_AllocateDescriptors_aumentar
        add        ebx,8
        loop DPMI_AllocateDescriptors_otro
        mov        ebx,eax
        mov        ecx,edx
 DPMI_AllocateDescriptors_otro2:
        mov dword ptr ds:[ebx],0
        mov dword ptr ds:4[ebx],109200h
        add        ebx,8
        loop DPMI_AllocateDescriptors_otro2
        jmp short DPMI_OkAx
 DPMI_AllocateDescriptors_aumentar:
        add        ebx,8
        mov        ecx,edx
        mov        eax,ebx
        cmp        ebx,MAX_SEL*8
        jl DPMI_AllocateDescriptors_otro
        jmp short DPMI_Fail8011_2
DPMI_AllocateDescriptors ENDP

DPMI_OkDX3:
        jmp short DPMI_OkDX2

DPMI_Ok3:
        jmp short DPMI_Ok2

DPMI_OkECX_2_1:
        jmp short DPMI_OkECX_2
DPMI_OkSI_2_1:
        jmp short DPMI_OkSI_2
DPMI_Fail8010_2_1:
        jmp short DPMI_Fail8010_2
DPMI_Fail8023_2_1:
        jmp short DPMI_Fail8023_2
DPMI_Fail8021_3:
        jmp short DPMI_Fail8021_2

DPMI_FreeDescriptors PROC
        Llamada32_32 SELECTOR_CS32,DPMI_TestSelector
        and byte ptr ds:[ebx+6],0efh
        mov     ecx,4
        lea     ebp,[esp+32]
 DPMI_FreeDescriptors_loop:
        cmp word ptr ss:[ebp],bx
        jne  short DPMI_FreeDescriptors_NoCero
        mov word ptr [ebp],0
 DPMI_FreeDescriptors_NoCero:
        add     ebp,2
        loop    DPMI_FreeDescriptors_loop
 DPMI_Ok4:
        jmp short DPMI_Ok3
DPMI_FreeDescriptors ENDP

DPMI_Increment PROC
        mov     ax,8
 DPMI_OkDx4:
        jmp short   DPMI_OkDX3
DPMI_Increment ENDP

DPMI_GetBase PROC
        Llamada32_32 SELECTOR_CS32,DPMI_TestSelector
        mov     dx,word ptr ds:[ebx+2]
        mov     cl,byte ptr ds:[ebx+4]
        mov     ch,byte ptr ds:[ebx+7]
        jmp short   DPMI_OkDX4
DPMI_GetBase ENDP        

DPMI_SetBase PROC
        Llamada32_32 SELECTOR_CS32,DPMI_TestSelector
        mov     word ptr ds:[ebx+2],dx
        mov     byte ptr ds:[ebx+4],cl
        mov     byte ptr ds:[ebx+7],ch
 DPMI_Ok5:
        jmp short   DPMI_Ok4
DPMI_SetBase ENDP

DPMI_OkECX_3:
        jmp short DPMI_OkECX_2_1

DPMI_Fail8010_3:
        jmp short DPMI_Fail8010_2_1
DPMI_OkSI_3:
        jmp short DPMI_OkSI_2_1
DPMI_Fail8023_3:
        jmp short DPMI_Fail8023_2_1
DPMI_SetLimit PROC
        Llamada32_32 SELECTOR_CS32,DPMI_TestSelector
        cmp     cx,0fh
        jbe     DPMI_SetLimit_Menor1M
        mov     ax,dx
        and     ax,0fffh
        cmp     ax,0fffh
        jne     DPMI_Fail8021_3
        shrd    dx,cx,12
        shr     cx,12
        or      cl,80h
 DPMI_SetLimit_Menor1M:
        mov     word ptr ds:[ebx],dx
        and     byte ptr ds:[ebx+6],70h
        or      byte ptr ds:[ebx+6],cl
        jmp short DPMI_Ok5
DPMI_SetLimit ENDP

DPMI_SetAccess PROC
        Llamada32_32 SELECTOR_CS32,DPMI_TestSelector
;        Llamada32_32 SELECTOR_CS32,DPMI_TestAccess
        or      ch,10h
        and     ch,0f0h
        and     byte ptr ds:[ebx+6],0fh
        or      byte ptr ds:[ebx+6],ch
        mov     byte ptr ds:[ebx+5],cl
DPMI_Ok_3:
        jmp short DPMI_Ok5
DPMI_SetAccess ENDP

DPMI_GetMem PROC
        push       ebx
        push       ds
        mov        bx,offset SELECTOR_DPMI
        mov        ds,bx
        mov        ebx,ecx
        dec        ebx
        shl        ebx,3
        mov        esi,ds:[ebx]
        mov        edi,ds:[ebx+4]
        pop        ds
        pop        ebx
        retf
DPMI_GetMem ENDP

DPMI_Fail8010_3_1:
        jmp short DPMI_Fail8010_3
DPMI_Fail8023_3_1:
        jmp short DPMI_Fail8023_3
DPMI_OkSI_3_1:
        jmp short DPMI_OkSI_3
DPMI_OkECX_4:
        jmp short DPMI_OkECX_3
DPMI_Ok_3_1:
        jmp short DPMI_Ok_3
DPMI_SetMem PROC
        push       ebx
        push       ds
        mov        bx,offset SELECTOR_DPMI
        mov        ds,bx
        mov        ebx,ecx
        dec        ebx
        shl        ebx,3
        mov        ds:[ebx],esi
        mov        ds:[ebx+4],edi
        pop        ds
        pop        ebx
        retf
DPMI_SetMem ENDP

DPMI_Fail8010_4:
       jmp short DPMI_Fail8010_3_1
DPMI_OkSI_4:
       jmp short DPMI_OkSI_3_1
DPMI_Fail8023_4:
       jmp short DPMI_Fail8023_3_1
DPMI_Ok_4:
       jmp short DPMI_Ok_3_1
DPMI_FreeMem PROC
        mov        ax,offset SELECTOR_DS
        mov        ds,ax
        xor        edx,edx
        xor        ecx,ecx
        mov        ebx,00100000h
 DPMI_FreeMem_mas:
        push       ecx
        xor        edi,edi
        mov        eax,_Ext_MEM
        mov        ecx,LONG_TABLA_MEM
 DPMI_FreeMem_otra:
        push       edi
        Llamada32_32 SELECTOR_CS32,DPMI_GetMem
        cmp        esi,ebx
        jl         DPMI_FreeMem_noVale
        cmp        esi,eax
        jge        DPMI_FreeMem_noVale
        mov        eax,esi
        add        esp,4
        push       edi
 DPMI_FreeMem_noVale:
        pop        edi
        loop       DPMI_FreeMem_otra
        pop        ecx
        cmp        ebx,eax
        jne        DPMI_FreeMem_libre
        add        ebx,edi
        jmp short      DMPI_FreeMem_salto
 DPMI_FreeMem_libre:
        sub        eax,ebx
        cmp        eax,ecx
        jl         DPMI_FreeMem_Bloque
        mov        ecx,eax
 DPMI_FreeMem_Bloque:        
        add        edx,eax
        test       edi,edi
        jz         DPMI_FreeMem_salir
        add        ebx,eax
        add        ebx,edi
 DMPI_FreeMem_salto:
        cmp        ebx,_Ext_MEM
        jl         DPMI_FreeMem_mas
 DPMI_FreeMem_salir:
        mov        eax,ecx
        mov        ecx,edx
        jmp short DPMI_OkECX_4
DPMI_FreeMem ENDP

DPMI_Fail8010_4_1:
        jmp short DPMI_Fail8010_4
DPMI_OkSI_4_1:
        jmp short DPMI_OkSI_4
DPMI_Fail8023_4_1:
        jmp short DPMI_Fail8023_4
DPMI_Ok_4_1:
        jmp short DPMI_Ok_4
DPMI_CheckMem PROC
        push       ecx
        mov        ecx,LONG_TABLA_MEM
 DPMI_CheckMem_otra:
        Llamada32_32 SELECTOR_CS32,DPMI_GetMem
        test       edi,edi
        jz         DPMI_CheckMem_noVale
        add        edi,esi
        push       ebx
        sub        ebx,edx
        add        ebx,edi
        cmp        ebx,_Ext_MEM
        jle        DPMI_CheckMem_noChoca
        pop        ebx
        pop        ecx
        retf
 DPMI_CheckMem_noChoca:
        pop        ebx
        cmp        esi,edx
        jg         DPMI_CheckMem_otroCaso
        je         DPMI_CheckMem_choca
        cmp        edi,edx
        jle        DPMI_CheckMem_noVale
 DPMI_CheckMem_choca:
        pop        ecx
        retf
 DPMI_CheckMem_otroCaso:
        cmp        esi,ebx
        jl         DPMI_CheckMem_choca        
 DPMI_CheckMem_noVale:
        loop       DPMI_CheckMem_otra
        xor        edi,edi
        mov        esi,edx
        pop        ecx
        retf
DPMI_CheckMem ENDP

DPMI_Fail8010_5:
        jmp short DPMI_Fail8010_4_1
DPMI_OkSI_5_1:
        jmp short DPMI_OkSI_4_1
DPMI_Fail8023_5:
        jmp short DPMI_Fail8023_4_1
DPMI_Ok_5:
        jmp short DPMI_Ok_4_1
DPMI_FreeHandle PROC
        push       ds
        push       ebx
        mov        cx,offset SELECTOR_DPMI
        mov        ds,cx
        mov        ecx,LONG_TABLA_MEM
        mov        ebx,LONG_TABLA_MEM-1
        shl        ebx,3
 DPMI_FreeHandle_otra:
        test dword ptr ds:[ebx+4],0FFFFFFFFh
        jz         DPMI_FreeHandle_sal
        sub        ebx,8
        loop       DPMI_FreeHandle_otra
 DPMI_FreeHandle_sal:        
        pop        ebx
        pop        ds
        retf
DPMI_FreeHandle ENDP

DPMI_OkSI_5:
        jmp short DPMI_OkSI_5_1
DPMI_Fail8023_6:
        jmp short DPMI_Fail8023_5
DPMI_Ok_6:
        jmp short DPMI_Ok_5
DPMI_AllocateMem PROC
        mov        ax,offset SELECTOR_DS
        mov        ds,ax
        shl        ebx,16
        mov        bx,cx
        push       ebx
        mov        edx,00100000h
        mov        eax,_Ext_MEM
        add        ebx,edx
        cmp        ebx,eax
        jg         DPMI_AllocateMem_mal
        mov        ecx,LONG_TABLA_MEM
 DPMI_AllocateMem_otra:
        Llamada32_32 SELECTOR_CS32,DPMI_CheckMem
        test       edi,edi
        jz         DPMI_AllocateMem_bien
        cmp        edi,eax
        jge        DPMI_AllocateMem_mal
        push       ecx
        mov        ecx,edx
        mov        edx,edi
        sub        edi,ecx
        pop        ecx
        add        ebx,edi
        cmp        ebx,_Ext_MEM
        jg         DPMI_AllocateMem_mal
        loop       DPMI_AllocateMem_otra
 DPMI_AllocateMem_mal:
        pop        ebx
        jmp short  DPMI_Fail8010_5
 DPMI_AllocateMem_bien:
        Llamada32_32 SELECTOR_CS32,DPMI_FreeHandle
        test       ecx,ecx
        jz         DPMI_AllocateMem_mal
        pop        edi
        Llamada32_32 SELECTOR_CS32,DPMI_SetMem
        mov        di,cx
        mov        cx,si
        shr        esi,16
        mov        bx,si
        xor        si,si
        jmp short DPMI_OkSI_5
DPMI_AllocateMem ENDP

DPMI_Fail8023_6_1:
        jmp short DPMI_Fail8023_6
DPMI_Ok_6_1:
        jmp short DPMI_Ok_6
DPMI_FreeMemBlock PROC
        test       si,si
        jnz        DPMI_FreeMemBlock_mal
        test       di,di
        jz         DPMI_FreeMemBlock_mal
        cmp        di,LONG_TABLA_MEM
        jg         DPMI_FreeMemBlock_mal
        mov        bx,offset SELECTOR_DPMI
        mov        ds,bx
        xor        ebx,ebx
        mov        bx,di
        dec        ebx
        shl        ebx,3
        test dword ptr ds:[ebx+4],0FFFFFFFFh
        jnz        DPMI_FreeMemBlock_bien
 DPMI_FreeMemBlock_mal:
        jmp short  DPMI_Fail8023_6_1
 DPMI_FreeMemBlock_bien:
        mov dword ptr ds:[ebx],0
        mov dword ptr ds:[ebx+4],0
 DPMI_FreeMemBlock_salir:        
        jmp short DPMI_Ok_6_1
DPMI_FreeMemBlock ENDP

DPMI_TestSelector PROC FAR
        pop        ebp
        add        esp,4
        cmp        bx,MAX_SEL*8
        jge        DPMI_Fail8022
        push       bx
        mov        bx,offset SELECTOR_GDT
        mov        ds,bx
        pop        bx
        and        bl,0f8h
        movzx      ebx,bx
        test byte ptr ds:6[ebx],10h
        jz         DPMI_Fail8022
        push dword ptr offset SELECTOR_CS32
        push       ebp
        retf
DPMI_TestSelector ENDP

;DPMI_TestAccess PROC FAR
;        pop        ebp
;        add        esp,4
;        test       ch,20h
;        jnz        DPMI_Fail8021
;        test       cl,90h
;        jz         DPMI_Fail8021
;        jpo        DPMI_Fail8021
;        test       cl,60h
;        jnz        DPMI_Fail8021
;        test       cl,08h
;        jz         DPMI_TestAccess_Ok        
;        test       cl,6
;        jz         DPMI_Fail8021
;        jpe        DPMI_Fail8021
;DPMI_TestAccess_Ok:
;        push dword ptr offset SELECTOR_CS32
;        push       ebp
;        retf
;DPMI_TestAccess ENDP


Ext_CopiarMemoria_ PROC FAR
       push    ebp
       mov     ebp,esp
       pushad
       push    ds
       push    es
       mov     esi,eax
       mov     ds,dx
       mov     edi,ebx
       mov     es,cx
       mov     ecx,ss:[ebp+12]
       cld
       shr     ecx,1
       jnc     Copy_1
       movsb
 Copy_1:
       shr     ecx,1
       jnc     Copy_2
       movsw
 Copy_2:
       rep     movsd        
       pop     es
       pop     ds
       popad
       pop     ebp
       retf    4
Ext_CopiarMemoria_ ENDP

Ext_BorrarMemoria_ PROC FAR
       pushad
       push    es
       mov     edi,eax
       mov     es,dx
       mov     ecx,ebx
       xor     eax,eax
       cld
       shr     ecx,1
       jnc     Clear_1
       stosb
 Clear_1:
       shr     ecx,1
       jnc     Clear_2
       stosw
 Clear_2:
       rep     stosd        
       pop     es
       popad
       retf
Ext_BorrarMemoria_ ENDP

Ext_RellenarMemoria_ PROC FAR
       pushad
       push    es
       mov     edi,eax
       mov     es,dx
       mov     ah,cl
       mov     al,cl
       rol     eax,16
       mov     ah,cl
       mov     al,cl
       mov     ecx,ebx
       cld
       shr     ecx,1
       jnc     Fill_1
       stosb
 Fill_1:
       shr     ecx,1
       jnc     Fill_2
       stosw
 Fill_2:
       rep     stosd
       pop     es
       popad
       retf
Ext_RellenarMemoria_ ENDP

Ext_LongitudCadena_ PROC FAR
        push    ds
        push    edi
        mov     ds,dx
        mov     edi,eax
        xor     eax,eax
 Ext_strlen_otra:
        test BYTE PTR ds:[edi+eax],0FFh
        jz      Ext_strlen_salida
        inc     eax
        jmp Ext_strlen_otra
 Ext_strlen_salida:
        pop     edi
        pop     ds
        retf
Ext_LongitudCadena_ ENDP

Ext_CrearAcceso_ PROC FAR    ;ushort Ext_CrearAcceso(tipo,dpl,defecto,granu)
        push    edx
        push    ebx
        push    ecx
        and     eax,1fh
        and     edx,3
        rol     edx,5
        add     eax,edx
        or      ebx,ebx
        jz      Ext_CrearAcceso_NoDefecto
        add     eax,4000h
 Ext_CrearAcceso_NoDefecto:
        or      ecx,ecx
        jz      Ext_CrearAcceso_NoGranularidad
        add     eax,8000h
 Ext_CrearAcceso_NoGranularidad:
        add     eax,1080h
        pop     ecx
        pop     ebx
        pop     edx
        retf
Ext_CrearAcceso_ ENDP

Ext_HacerSelector_ PROC FAR  ; CX= Selector , lo demas como Ext_CrearSelector

        push        EBX        ; Acceso
        push        EDX        ; Limite
        push        EAX        ; Base
        mov         AX,CX
Ext_HacerSelector_Salto:
        pop         DX
        pop         CX
        push        AX
        mov         BX,AX
        mov         AX,7
        int         31h        ; Poner Base
        or          AX,AX
        js          Ext_HacerSelector_Error2
        
        pop         BX
        pop         DX
        pop         CX
        push        BX
        mov         AX,8
        int         31h        ; Poner Limite
        or          AX,AX
        js          Ext_HacerSelector_Error3
        
        pop         BX
        pop         ECX
        push        BX
        mov         AX,9
        int         31h        ; Poner Acceso
        or          AX,AX
        js          Ext_HacerSelector_Error4
        xor         EAX,EAX
        pop         AX         ; Devuelve el selector
        retf                   ; Retorno sin error        
        
 Ext_HacerSelector_Error2:
        pop         BX
        mov         EAX,1
        int         31h        ; Liberar descriptor
        mov         EAX,-2        
        retf        8          ; Retorno con error -2

 Ext_HacerSelector_Error3:
        pop         BX
        mov         EAX,1
        int         31h        ; Liberar descriptor
        mov         EAX,-3        
        retf        4          ; Retorno con error -3

 Ext_HacerSelector_Error4:
        pop         BX
        mov         EAX,1
        int         31h        ; Liberar descriptor
        mov         EAX,-4        
        retf                   ; Retorno con error -4


Ext_HacerSelector_ ENDP

Ext_CrearSelector_ PROC FAR
        
        push        EBX        ; Acceso
        push        EDX        ; Limite
        push        EAX        ; Base
        
        xor         EAX,EAX
        mov         ECX,1
        int         31h        ; Crea 1 Descriptor
        or          AX,AX
        jns         Ext_HacerSelector_Salto
        mov         EAX,-1
        retf        12         ; Retorno con error -1
Ext_CrearSelector_ ENDP

Ext_DestruirSelector_ PROC FAR
        push       ebx
        mov        EBX,EAX
        mov        EAX,1
        int        31h         ; Liberar descriptor
        or         AX,AX
        js         DestruirSelector_Error
        xor        EAX,EAX     ; Retorno con exito
        retf

 DestruirSelector_Error:
        mov        EAX,-1      ; Retorno con error
        pop        ebx
        retf
Ext_DestruirSelector_ ENDP

Ext_ReservarMemoriaDPMI_ PROC FAR
        push        DS
        push        edx
        push        ecx
        push        ebx
        mov         DS,DX
        mov         EDX,EAX
        mov         CX,DS:[EDX]
        mov         BX,DS:2[EDX]
        push        EDX
        mov         AX,0501h
        int         31h
        or          AX,AX
        js          ReservarMemoria_Error
        pop         EDX
        mov         DS:4[EDX],CX
        mov         DS:6[EDX],BX
        mov         DS:8[EDX],DI
        mov         DS:10[EDX],SI
        pop         ebx
        pop         ecx
        pop         edx
        pop         DS
        xor         EAX,EAX
        retf
ReservarMemoria_Error:
        pop         EDX
        pop         ebx
        pop         ecx
        pop         edx
        pop         DS
        mov         EAX,-1
        retf
Ext_ReservarMemoriaDPMI_ ENDP

Ext_LiberarMemoriaDPMI_ PROC FAR
        push        DS
        push        edx
        push        edi
        push        esi
        mov         DS,DX
        mov         EDX,EAX
        mov         DI,DS:8[EDX]
        mov         SI,DS:10[EDX]
        pop         DS
        mov         AX,0502h
        int         31h
        or          AX,AX
        js          LiberarMemoria_Error
        xor         EAX,EAX
        pop         esi
        pop         edi
        pop         edx
        pop         DS
        retf
LiberarMemoria_Error:
        mov         EAX,-1
        pop         esi
        pop         edi
        pop         edx
        pop         DS
        retf
Ext_LiberarMemoriaDPMI_ ENDP

Ext_HacerPuntero_ PROC FAR
        push        DS
        mov         DS,CX
        mov         DS:[EBX],EDX
        mov         DS:4[EBX],AX
        pop         DS
        retf
Ext_HacerPuntero_ ENDP

Ext_Segmento_ PROC FAR
        xor         EAX,EAX
        mov         AX,DX
        retf
Ext_Segmento_ ENDP

Ext_Desplazamiento_ PROC FAR
        retf
Ext_Desplazamiento_ ENDP

ReservaMemTarea PROC FAR          ; EAX : Pila , EDX : LDT
        push       ebx
        push       ecx
        push       esi
        push       edi
        add        eax,edx
        add        eax,6Bh
        xor        ebx,ebx
        xor        ecx,ecx
        mov        cx,ax
        rol        eax,16
        mov        bx,ax
        mov        eax,501h
        int        31h
        or         ax,ax
        js         ReservaMemTarea_mal
        mov        ax,bx
        rol        eax,16
        mov        ax,cx
        mov        dx,si
        rol        edx,16
        mov        dx,di
        jmp short  ReservaMemTarea_vuelve
 ReservaMemTarea_mal:
        xor        edx,edx
        xor        eax,eax
 ReservaMemTarea_vuelve:
        pop        edi
        pop        esi          ; Devuelve:
        pop        ecx                  ; EAX = Base
        pop        ebx                  ; EDX = Handle
        retf
ReservaMemTarea ENDP

CompletaLDT PROC FAR    ; GS: SELECTOR LDT , EAX : Posicion , EDX: Base
                        ; EBX : Limite , ECX : Acceso
        push      edi
        push      eax
        push      edx
        push      ebx
        mov       edi,eax
        shl       edi,3
        mov       gs:[edi],bx
        mov       gs:[edi+2],dx
        ror       edx,16
        mov       gs:[edi+4],dl
        mov       ax,cx
        and       ax,0C0FFh
        or        ax,1000h
        ror       ebx,8
        and       bx,0F00h
        or        ax,bx
        mov       gs:[edi+5],ax
        mov       gs:[edi+7],dh
        pop       ebx
        pop       edx
        pop       eax
        pop       edi
        retf
CompletaLDT ENDP

Ext_DescriptorLDT_ PROC FAR
        push      ebp
        mov       ebp,esp
        push      gs
        mov       gs,ss:[ebp+12]
        pushad
        Llamada32_32 SELECTOR_CS32,CompletaLDT
        popad
        pop       gs
        pop       ebp
        retf 4
Ext_DescriptorLDT_ ENDP

Ext_Copy2LDT_ PROC FAR   ; AX= Selector GDT , DX= ID TASK
                         ; EBX = Entrada LDT , ECX = DPL
        push      ds
        push      es
        pushad
        push      ax
        mov       ax,offset SELECTOR_GDT
        mov       ds,ax
        add       dx,24
        mov       es,dx
        shl       ebx,3
        and       ecx,3
        pop       ax
        movzx     edx,ax
        mov       eax,ds:[edx]
        mov       es:[ebx],eax
        mov       eax,ds:[edx+4]
        or        eax,00108000h
        and       eax,0FFDF9FFFh
        rol       ecx,13
        or        eax,ecx
        mov       es:[ebx+4],eax
        popad
        pop       es
        pop       ds
        retf
Ext_Copy2LDT_ ENDP

Ext_InicTask_ PROC FAR                   ;EAX : Pila , EDX : LDT , EBX : DPL
        push       edi
        push       ebp
        sub        esp,2
        push       eax
        push       edx
        push       ebx                   
        Llamada32_32 SELECTOR_CS32,ReservaMemTarea
        or         eax,eax
        jz         Ext_InicTask_Error1
        push       edx                  
        push       eax                  
        mov        ebp,esp
        xor        eax,eax
        mov        ecx,4
        int        31h              ; Reserva 4 Descriptores
        or         ax,ax
        js         Ext_InicTask_Error2
        mov        ss:[ebp+20],ax
        mov        eax,TSS_BUSY_386  ; TSS real
        mov        edx,ss:[ebp+8]
        mov        edx,ebx
        mov        ebx,-1
        xor        ecx,ecx
        Llamada32_32 SELECTOR_CS32,Ext_CrearAcceso_
        mov        ebx,eax
        mov        eax,ss:[ebp]
        mov        edx,6bh
        mov        cx,ss:[ebp+20]
        Llamada32_32 SELECTOR_CS32,Ext_HacerSelector_
        or         eax,eax
        js         Ext_InicTask_Error3
        mov        eax,SEG_DESC+LE_SEG  ; TSS copia
        mov        edx,ss:[ebp+8]
        mov        ebx,-1
        xor        ecx,ecx
        Llamada32_32 SELECTOR_CS32,Ext_CrearAcceso_
        mov        ebx,eax
        mov        eax,ss:[ebp]
        mov        edx,6Bh
        mov        cx,ss:[ebp+20]
        add        cx,8*1
        Llamada32_32 SELECTOR_CS32,Ext_HacerSelector_
        or         eax,eax
        js         Ext_InicTask_Error3
        mov        eax,LDT_DESC         ; LDT real
        mov        edx,ss:[ebp+8]
        mov        ebx,-1
        xor        ecx,ecx
        Llamada32_32 SELECTOR_CS32,Ext_CrearAcceso_
        mov        ebx,eax
        mov        eax,ss:[ebp]
        add        eax,6Bh
        mov        edx,ss:[ebp+12]
        mov        cx,ss:[ebp+20]
        add        cx,8*2
        Llamada32_32 SELECTOR_CS32,Ext_HacerSelector_
        or         eax,eax
        js         Ext_InicTask_Error3
        mov        eax,SEG_DESC+LE_SEG  ; LDT copia
        mov        edx,ss:[ebp+8]
        mov        ebx,-1
        xor        ecx,ecx
        Llamada32_32 SELECTOR_CS32,Ext_CrearAcceso_
        mov        ebx,eax
        mov        eax,ss:[ebp]
        add        eax,6Bh
        mov        edx,ss:[ebp+12]
        mov        cx,ss:[ebp+20]
        add        cx,8*3
        Llamada32_32 SELECTOR_CS32,Ext_HacerSelector_
        or         eax,eax
        js         Ext_InicTask_Error3
        push       gs
        mov        gs,ax
        mov        eax,ss:[ebp+4]
        mov        gs:[0],eax
        mov        eax,SEG_DESC+LE_SEG  ; Pila en LDT
        mov        edx,ss:[ebp+8]
        mov        ebx,-1
        xor        ecx,ecx
        Llamada32_32 SELECTOR_CS32,Ext_CrearAcceso_
        mov        ecx,eax
        mov        edx,ss:[ebp]
        add        edx,6Bh
        add        edx,ss:[ebp+12]
        mov        ebx,ss:[ebp+16]
        mov        eax,1
        Llamada32_32 SELECTOR_CS32,CompletaLDT
        pop        gs
        xor        eax,eax
        mov        ax,ss:[ebp+20]  ; Devuelve selector base
        add        esp,22
        pop        ebp
        pop        edi
        retf
 Ext_InicTask_Error3:
        mov        bx,ss:[ebp+20]
        mov        ax,1
        int        31h
        add        bx,8
        mov        ax,1
        int        31h
        add        bx,8
        mov        ax,1
        int        31h
        add        bx,8
        mov        ax,1
        int        31h
 Ext_InicTask_Error2:
        add        esp,4
        pop        edi
        xor        esi,esi
        rol        edi,16
        mov        si,di
        ror        edi,16
        mov        eax,502h
        int        31h
 Ext_InicTask_Error1:
        add        esp,14
        pop        ebp
        pop        edi
        mov        eax,-1
        retf
Ext_InicTask_ ENDP

Ext_FreeTask_ PROC FAR
        push       gs
        pushad
        push       ax
        add        ax,24
        mov        gs,ax
        mov        esi,gs:[0]
        xor        edi,edi
        mov        di,si
        shl        esi,16
        mov        ax,0502h     ; Free DPMI mem
        int        31h
        pop        bx
        mov        ax,1
        int        31h          ; Free descriptors
        add        bx,8
        mov        ax,1
        int        31h
        add        bx,8
        mov        ax,1
        int        31h
        add        bx,8
        mov        ax,1
        int        31h
        popad
        pop        gs
        retf
Ext_FreeTask_ ENDP

Ext_NewTask_ PROC FAR           ; Ext_NewTask(Task far *)
        push       ebx
        push       ecx
        push       edx
        push       edi
        push       esi
        push       ds
        xor        cx,cx
        push       cx
        mov        ds,dx
        mov        edi,eax
        mov        eax,ds:[edi].TaskL_PILA
        mov        edx,ds:[edi].TaskL_LDT
        xor        ebx,ebx
        mov        bl,ds:[edi].TaskDPL
        Llamada32_32 SELECTOR_CS32,Ext_InicTask_
        or         ax,ax
        js         Ext_NewTask_Error
        mov        ds:[edi].TaskID,ax
        push       edi
        push       ebx
        add        edi,0bh
        xor        ebx,ebx
        mov        ds:[edi],ebx
        mov        ds:6[edi],ebx
        mov        bx,ax
        add        bx,8
        mov        ds:4[edi],bx        ; Hacer puntero TSS
        add        bx,16
        mov        ds:10[edi],bx       ; Hacer puntero LDT
        pop        ebx
        pop        edi
        pop        cx
        push       ax
        push       ax
        mov        dx,ax
        mov        ax,cs
        mov        ebx,2
        xor        ecx,ecx
        mov        cl,ds:[edi].TaskDPL
        Llamada32_32 SELECTOR_CS32,Ext_Copy2LDT_
        pop        dx
        push       dx
        mov        ax,offset SELECTOR_DS
        mov        ebx,3
        xor        ecx,ecx
        mov        cl,ds:[edi].TaskDPL
        Llamada32_32 SELECTOR_CS32,Ext_Copy2LDT_
        pop        ax
        add        ax,8
        push       es
        mov        es,ax
        xor        eax,eax
        mov        es:[00].RBACKLINK,ax
        mov        es:[00].RES1,ax
        mov        ecx,ds:[edi].TaskL_PILA
        sub        ecx,4
        mov        es:[00].RESP0,ecx
        mov        es:[00].RSS0,12
        mov        es:[00].RES2,ax
        mov        es:[00].RESP1,ecx
        mov        es:[00].RSS1,12
        mov        es:[00].RES3,ax
        mov        es:[00].RESP2,ecx
        mov        es:[00].RSS2,12
        mov        es:[00].RES4,ax
        mov        edx,cr3
        mov        es:[00].RCR3,edx
        mov        edx,ds:[edi].TaskEIP
        mov        es:[00].REIP,edx
        mov        es:[00].REFLAGS,4202h
        mov        es:[00].REAX,eax
        mov        es:[00].RECX,eax
        mov        es:[00].REDX,eax
        mov        es:[00].REBX,eax
        mov        es:[00].RESP,ecx
        mov        es:[00].REBP,ecx
        mov        es:[00].RESI,eax
        mov        es:[00].REDI,eax
        mov        es:[00].RES,28
        mov        es:[00].RES5,ax
        mov        es:[00].RCS,20
        mov        es:[00].RES6,ax
        mov        es:[00].RSS,12
        mov        es:[00].RES7,ax
        mov        es:[00].RDS,28
        mov        es:[00].RES8,ax
        mov        es:[00].RFS,28
        mov        es:[00].RES9,ax
        mov        es:[00].RGS,28
        mov        es:[00].RES10,ax
        mov        dx,es
        add        dx,8
        mov        es:[00].RLDTR,dx
        mov        es:[00].RES11,ax
        mov        es:[00].RTBIT,ax
        mov        es:[00].RIOBASE,ax
        mov        es:[00].RCOUNTDOWN,ax
        mov        es:[00].RBITS,ax
        push       ax
        push       bx   ; Poner vuelta en la pila
        sldt       ax
        mov        bx,es
        add        bx,8
        lldt       bx
        push       ds
        mov        bx,12
        mov        ds,bx
        mov dword ptr ds:[ecx],offset VueltaTarea
        pop        ds
        lldt       ax
        pop        bx
        pop        ax
        pop        es
Ext_NewTask_Error:
        xor        eax,eax                ; Devuelve 0 si hay error
        pop        ax
        pop        ds                     ; o el ID de la tarea
        pop        esi
        pop        edi
        pop        edx
        pop        ecx
        pop        ebx
       retf
Ext_NewTask_ ENDP

VueltaTarea PROC        ; Todas las tareas vuelve aqui
        mov         ax,28       ; Selector 28 LDT de toda tarea
        mov         ds,ax       ;  es la copia de SELECTOR_DS
        inc         _Ext_END_TASKS ; Sumar 1 a las tareas terminadas
        mov         ax,_Ext_TASK   ; Poner Bit de terminado 
        add         ax,8           ; Quitar Bit de activo
        mov         gs,ax
        mov         ax,gs:[00].RBITS
        or          ax,3
        mov         gs:[00].RBITS,ax
VueltaTarea_Otra:
        mov         eax,-1                       ; Vueltas maximas a
        Llamada32_32 SELECTOR_CS32,Ext_NextTask_ ;  la proxima tarea
        jmp short       VueltaTarea_Otra ; Esto no deberia ejecutarse
VueltaTarea ENDP



Ext_malloc_ PROC NEAR
_nmalloc_:
        push       ds
        push       ebx
        push       ecx
        push       esi
        push       edi
        or         eax,eax
        jz         malloc_error
        add        eax,8
        mov        cx,ax
        ror        eax,16
        mov        bx,ax
        mov        ax,0501h
        int        31h
        or         ax,ax
        js         malloc_error
        rol        ebx,16
        mov        bx,cx
        rol        esi,16
        mov        si,di
        mov        ax,offset SELECTOR_DS
        mov        ds,ax
        mov        eax,ebx
        sub        ebx,ADD_DATA_PAGE
        mov        ds:[ebx],eax
        mov        ds:[ebx+4],esi
        mov        eax,ebx
        add        eax,8
 malloc_salir:
        pop        edi
        pop        esi
        pop        ecx
        pop        ebx
        pop        ds
        ret
 malloc_error:
        xor        eax,eax
        jmp short      malloc_salir
Ext_malloc_ ENDP

Ext_free_ PROC NEAR
_nfree_:
        push       ds
        pushad
        or         eax,eax
        jz         free_salida
        mov        bx,offset SELECTOR_DS
        mov        ds,bx
        sub        eax,8
        mov        ebx,eax
        add        eax,ADD_DATA_PAGE
        cmp        ds:[ebx],eax
        jne        free_salida
        mov        esi,ds:[ebx+4]
        mov        di,si
        rol        esi,16
        mov        ax,0502h
        int        31h
 free_salida:
        popad
        pop        ds
        ret
Ext_free_ ENDP

Ext_strlen_ PROC NEAR
                push    ecx
                push    edi
                mov     edi,eax
                push    es
                mov     ax,ds
                mov     es,ax
                sub     ecx,ecx
                dec     ecx
                xor     eax,eax
                repne   scasb    
                not     ecx
                dec     ecx
                pop     es
                mov     eax,ecx
                pop     edi
                pop     ecx
                ret
Ext_strlen_ ENDP



Ext_strcpy_ PROC NEAR
                push    ecx
                push    eax
Ext_strcpy_1:   mov     cl,byte ptr [edx]
                mov     byte ptr [eax],cl
                cmp     cl,00H
                je      short Ext_strcpy_2
                mov     cl,byte ptr +1H[edx]
                add     edx,00000002H
                mov     byte ptr +1H[eax],cl
                add     eax,00000002H
                cmp     cl,00H
                jne     short Ext_strcpy_1
Ext_strcpy_2:   pop     eax
                pop     ecx
                ret
Ext_strcpy_ ENDP

                
Ext_strncpy_ PROC NEAR
                push    ecx
                push    esi
                mov     esi,eax
                jmp short   short Ext_strncpy_2
Ext_strncpy_1:  mov     cl,byte ptr [edx]
                test    cl,cl
                je      short Ext_strncpy_3
                inc     edx
                dec     ebx
                mov     byte ptr [eax],cl
                inc     eax
Ext_strncpy_2:  test    ebx,ebx
                jne     short Ext_strncpy_1
Ext_strncpy_3:  test    ebx,ebx
                je      short Ext_strncpy_4
                dec     ebx
                mov     byte ptr [eax],00H
                inc     eax
                jmp short   short Ext_strncpy_3
Ext_strncpy_4:  mov     eax,esi
                pop     esi
                pop     ecx
                ret
Ext_strncpy_ ENDP

                
Ext_strset_ PROC NEAR
                push    ebx
                mov     ebx,eax
                jmp     short Ext_strset_2
Ext_strset_1:   mov     byte ptr [eax],dl
                inc     eax
Ext_strset_2:   cmp     byte ptr [eax],00H
                jne     short Ext_strset_1
                mov     eax,ebx
                pop     ebx
                ret
Ext_strset_ ENDP

                
Ext_strnset_ PROC NEAR
                push    esi
                mov     esi,eax
                jmp     short Ext_strnset_2
Ext_strnset_1:  cmp     byte ptr [eax],00H
                je      short Ext_strnset_3
                dec     ebx
                mov     byte ptr [eax],dl
                inc     eax
Ext_strnset_2:  test    ebx,ebx
                jne     short Ext_strnset_1
Ext_strnset_3:  mov     eax,esi
                pop     esi
                ret
Ext_strnset_ ENDP
                 
Ext_strcmp_ PROC NEAR
                push    ebx
                push    ecx
                mov     ebx,eax
                cmp     eax,edx
                je      short Ext_strcmp_2
Ext_strcmp_1:   mov     eax,dword ptr [ebx]
                mov     ecx,dword ptr [edx]
                cmp     ecx,eax
                jne     short Ext_strcmp_3
                not     ecx
                add     eax,0fefefeffH
                and     eax,ecx
                and     eax,80808080H
                jne     short Ext_strcmp_2
                mov     eax,dword ptr +4H[ebx]
                mov     ecx,dword ptr +4H[edx]
                cmp     ecx,eax
                jne     short Ext_strcmp_3
                not     ecx
                add     eax,0fefefeffH
                and     eax,ecx
                and     eax,80808080H
                jne     short Ext_strcmp_2
                mov     eax,dword ptr +8H[ebx]
                mov     ecx,dword ptr +8H[edx]
                cmp     ecx,eax
                jne     short Ext_strcmp_3
                not     ecx
                add     eax,0fefefeffH
                and     eax,ecx
                and     eax,80808080H
                jne     short Ext_strcmp_2
                mov     eax,dword ptr +0cH[ebx]
                mov     ecx,dword ptr +0cH[edx]
                cmp     ecx,eax
                jne     short Ext_strcmp_3
                add     ebx,00000010H
                add     edx,00000010H
                not     ecx
                add     eax,0fefefeffH
                and     eax,ecx
                and     eax,80808080H
                je      short Ext_strcmp_1
Ext_strcmp_2:   sub     eax,eax
                pop     ecx
                pop     ebx
                ret
Ext_strcmp_3:   cmp     al,cl
                jne     short Ext_strcmp_4
                cmp     al,00H
                je      short Ext_strcmp_2
                cmp     ah,ch
                jne     short Ext_strcmp_4
                cmp     ah,00H
                je      short Ext_strcmp_2
                shr     eax,10H
                shr     ecx,10H
                cmp     al,cl
                jne     short Ext_strcmp_4
                cmp     al,00H
                je      short Ext_strcmp_2
                cmp     ah,ch
Ext_strcmp_4:   sbb     eax,eax
                or      al,01H
                pop     ecx
                pop     ebx
                ret
Ext_strcmp_ ENDP
                
Ext_strncmp_ PROC NEAR
                push    ecx
Ext_strncmp_1:  test    ebx,ebx
                jne     short Ext_strncmp_3
Ext_strncmp_2:  xor     eax,eax
                pop     ecx
                ret
Ext_strncmp_3:  mov     cl,byte ptr [eax]
                mov     ch,byte ptr [edx]
                cmp     cl,ch
                je      short Ext_strncmp_4
                xor     ebx,ebx
                xor     eax,eax
                mov     bl,cl
                mov     al,ch
                sub     ebx,eax
                mov     eax,ebx
                pop     ecx
                ret
Ext_strncmp_4:  cmp     byte ptr [eax],00H
                je      short Ext_strncmp_2
                inc     eax
                inc     edx
                dec     ebx
                jmp     short Ext_strncmp_1
Ext_strncmp_ ENDP

__STOSB:        or      ecx,ecx
                je      short stos_3
                cmp     byte ptr [eax],dl
stos_1:         test    al,03H
                je      short stos_2
                mov     byte ptr [eax],dl
                inc     eax
                ror     edx,08H
                dec     ecx
                jne     short stos_1
stos_2:         push    ecx
                shr     ecx,02H
                call    near ptr __STOSD
                pop     ecx
                and     ecx,00000003H
                je      short stos_3
                mov     byte ptr [eax],dl
                dec     ecx
                je      short stos_3
                mov     byte ptr +1H[eax],dh
                dec     ecx
                je      short stos_3
                mov     byte ptr +2H[eax],dl
stos_3:         ret
                nop     
                nop     
                nop     
                nop     
                nop     
                nop     
__STOSD:        or      ecx,ecx
                je      short stos_10
stos_4:         test    al,1fH
                je      short stos_5
                mov     dword ptr [eax],edx
                lea     eax,+4H[eax]
                dec     ecx
                jne     short stos_4
stos_5:         push    ecx
                shr     ecx,02H
                je      short stos_9
                dec     ecx
                je      short stos_8
stos_6:         mov     dword ptr [eax],edx
                mov     dword ptr +4H[eax],edx
                dec     ecx
                mov     dword ptr +8H[eax],edx
                mov     dword ptr +0cH[eax],edx
                je      short stos_7
                cmp     byte ptr +20H[eax],dl
                mov     dword ptr +10H[eax],edx
                mov     dword ptr +14H[eax],edx
                dec     ecx
                mov     dword ptr +18H[eax],edx
                mov     dword ptr +1cH[eax],edx
                lea     eax,+20H[eax]
                jne     short stos_6
                lea     eax,-10H[eax]
stos_7:         lea     eax,+10H[eax]
stos_8:         mov     dword ptr [eax],edx
                mov     dword ptr +4H[eax],edx
                mov     dword ptr +8H[eax],edx
                mov     dword ptr +0cH[eax],edx
                lea     eax,+10H[eax]
stos_9:         pop     ecx
                and     ecx,00000003H
                je      short stos_10
                mov     dword ptr [eax],edx
                lea     eax,+4H[eax]
                dec     ecx
                je      short stos_10
                mov     dword ptr [eax],edx
                lea     eax,+4H[eax]
                dec     ecx
                je      short stos_10
                mov     dword ptr [eax],edx
                lea     eax,+4H[eax]
stos_10:        ret

              
Ext_memset_ PROC NEAR
                push    eax
                push    ecx
                mov     dh,dl
                shl     edx,08H
                mov     dl,dh
                shl     edx,08H
                mov     dl,dh
                mov     ecx,ebx
                call    near ptr __STOSB
                pop     ecx
                pop     eax
                ret
Ext_memset_ ENDP
                
Ext_memcpy_ PROC NEAR
                push    ecx
                push    esi
                push    edi
                mov     edi,eax
                mov     esi,edx
                mov     ecx,ebx
                push    es
                mov     ax,ds
                mov     es,ax
                push    edi
                mov     eax,ecx
                shr     ecx,02H
                repne   movsd    
                mov     cl,al
                and     cl,03H
                repne   movsb    
                pop     edi
                pop     es
                mov     eax,edi
                pop     edi
                pop     esi
                pop     ecx
                ret
Ext_memcpy_  ENDP
                
Ext_calloc_ PROC NEAR
                push    ebx
                imul    eax,edx
                mov     ebx,eax
                call    near ptr Ext_malloc_
                test    eax,eax
                je      short Ext_calloc_1
                xor     edx,edx
                call    near ptr Ext_memset_
Ext_calloc_1:   pop     ebx
                ret
Ext_calloc_ ENDP

Ext_WaitTicks_ PROC
        pushfd
        pushad
        push    ds
        mov     ecx,eax
        mov     ax,offset SELECTOR_DS
        mov     ds,ax
        sti
 Ext_WaitTicks_otra:
        mov     eax,_Ext_TIMER_COUNT
 Ext_WaitTicks_espera:
        cmp     eax,_Ext_TIMER_COUNT
        je      Ext_WaitTicks_espera
        loop    Ext_WaitTicks_otra
        pop     ds
        popad
        popfd
        retf
Ext_WaitTicks_ ENDP

_TEXT ENDS

END
